
# Configuration Options
<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->





| No | Key | Type | Description | Default Value | Since | Supports Repo ID suffix | Source |
| --- | --- | --- | --- | --- | --- | --- | --- |
| 1. | `"aether.artifactResolver.postProcessor.trustedChecksums"` | `java.lang.Boolean` | Is post processor enabled. |  `false`  | 1.9.0 |  No  | Session Configuration |
| 2. | `"aether.artifactResolver.postProcessor.trustedChecksums.checksumAlgorithms"` | `java.lang.String` | The checksum algorithms to apply during post-processing as comma separated list. |  `"SHA-1"`  | 1.9.0 |  No  | Session Configuration |
| 3. | `"aether.artifactResolver.postProcessor.trustedChecksums.failIfMissing"` | `java.lang.Boolean` | Should post processor fail resolution if checksum is missing? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 4. | `"aether.artifactResolver.postProcessor.trustedChecksums.record"` | `java.lang.Boolean` | Should post processor go into "record" mode (and collect checksums instead of validate them)? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 5. | `"aether.artifactResolver.postProcessor.trustedChecksums.snapshots"` | `java.lang.Boolean` | Should post processor process snapshots as well? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 6. | `"aether.artifactResolver.simpleLrmInterop"` | `java.lang.Boolean` | Configuration to enable "interoperability" with Simple LRM, but this breaks RRF feature, hence this configuration is IGNORED when RRF is used, and is warmly recommended to leave it disabled even if no RRF is being used. |  `false`  |  |  No  | Session Configuration |
| 7. | `"aether.artifactResolver.snapshotNormalization"` | `java.lang.Boolean` | Configuration to enable "snapshot normalization", downloaded snapshots from remote with timestamped file names will have file names converted back to baseVersion. It replaces the timestamped snapshot file name with a filename containing the SNAPSHOT qualifier only. This only affects resolving/retrieving artifacts but not uploading those. |  `true`  |  |  No  | Session Configuration |
| 8. | `"aether.chainedLocalRepository.ignoreTailAvailability"` | `java.lang.Boolean` | When using chained local repository, should be the artifact availability ignored in tail. |  `true`  | 1.9.2 |  No  | Session Configuration |
| 9. | `"aether.conflictResolver.verbose"` | `java.lang.Object` | The key in the repository session's  used to store a  flag controlling the transformer's verbose mode. Accepted values are Boolean types, String type (where "true" would be interpreted as ) or Verbosity enum instances. |  `"NONE"`  |  |  No  | Session Configuration |
| 10. | `"aether.connector.basic.parallelPut"` | `java.lang.Boolean` | Enables or disables parallel PUT processing (parallel deploys) on basic connector globally or per remote repository. When disabled, connector behaves exactly as in Maven 3.8.x did: GETs are parallel while PUTs are sequential. |  `true`  | 1.9.5 |  Yes  | Session Configuration |
| 11. | `"aether.connector.basic.persistedChecksums"` | `java.lang.Boolean` | Flag indicating whether checksums which are retrieved during checksum validation should be persisted in the local repository next to the file they provide the checksum for. |  `true`  | 0.9.0.M4 |  No  | Session Configuration |
| 12. | `"aether.connector.basic.smartChecksums"` | `java.lang.Boolean` | Flag indicating that instead of comparing the external checksum fetched from the remote repo with the calculated one, it should try to extract the reference checksum from the actual artifact response headers This only works for HTTP transports. |  `true`  | 0.9.0.M3 |  No  | Session Configuration |
| 13. | `"aether.connector.basic.threads"` | `java.lang.Integer` | Flag indicating whether checksums which are retrieved during checksum validation should be persisted in the local repository next to the file they provide the checksum for. |  `5`  | 0.9.0.M4 |  No  | Session Configuration |
| 14. | `"aether.dependencyCollector.bf.skipper"` | `java.lang.Boolean` | The key in the repository session's  used to store a  flag controlling the resolver's skip mode. |  `true`  | 1.8.0 |  No  | Session Configuration |
| 15. | `"aether.dependencyCollector.bf.threads"` | `java.lang.Integer` | The count of threads to be used when collecting POMs in parallel. |  `5`  | 1.9.0 |  No  | Session Configuration |
| 16. | `"aether.dependencyCollector.impl"` | `java.lang.String` | The name of the dependency collector implementation to use: depth-first (original) named "df", and breadth-first (new in 1.8.0) named "bf". Both collectors produce equivalent results, but they may differ performance wise, depending on project being applied to. Our experience shows that existing "df" is well suited for smaller to medium size projects, while "bf" may perform better on huge projects with many dependencies. Experiment (and come back to us!) to figure out which one suits you the better. |  `"bf"`  | 1.8.0 |  No  | Session Configuration |
| 17. | `"aether.dependencyCollector.maxCycles"` | `java.lang.Integer` | Only up to the given amount cyclic dependencies are emitted. |  `10`  | 1.8.0 |  No  | Session Configuration |
| 18. | `"aether.dependencyCollector.maxExceptions"` | `java.lang.Integer` | Only exceptions up to the number given in this configuration property are emitted. Exceptions which exceed that number are swallowed. |  `50`  | 1.8.0 |  No  | Session Configuration |
| 19. | `"aether.dependencyCollector.pool.artifact"` | `java.lang.String` | Flag controlling interning data pool type used by dependency collector for Artifact instances, matters for heap consumption. By default, uses “weak” references (consume less heap). Using “hard” will make it much more memory aggressive and possibly faster (system and Java dependent). Supported values: "hard", "weak". |  `"weak"`  | 1.9.5 |  No  | Session Configuration |
| 20. | `"aether.dependencyCollector.pool.dependency"` | `java.lang.String` | Flag controlling interning data pool type used by dependency collector for Dependency instances, matters for heap consumption. By default, uses “weak” references (consume less heap). Using “hard” will make it much more memory aggressive and possibly faster (system and Java dependent). Supported values: "hard", "weak". |  `"weak"`  | 1.9.5 |  No  | Session Configuration |
| 21. | `"aether.dependencyCollector.pool.descriptor"` | `java.lang.String` | Flag controlling interning data pool type used by dependency collector for ArtifactDescriptor (POM) instances, matters for heap consumption. By default, uses “weak” references (consume less heap). Using “hard” will make it much more memory aggressive and possibly faster (system and Java dependent). Supported values: "hard", "weak". |  `"hard"`  | 1.9.5 |  No  | Session Configuration |
| 22. | `"aether.dependencyManager.verbose"` | `java.lang.Boolean` | The key in the repository session's  used to store a  flag controlling the verbose mode for dependency management. If enabled, the original attributes of a dependency before its update due to dependency management will be recorded * in the node's  when building a dependency graph. |  `false`  |  |  No  | Session Configuration |
| 23. | `"aether.interactive"` | `java.lang.Boolean` | A flag indicating whether interaction with the user is allowed. |  `false`  |  |  No  | Session Configuration |
| 24. | `"aether.layout.maven2.checksumAlgorithms"` | `java.lang.String` | Comma-separated list of checksum algorithms with which checksums are validated (downloaded) and generated (uploaded) with this layout. Resolver by default supports following algorithms: MD5, SHA-1, SHA-256 and SHA-512. New algorithms can be added by implementing ChecksumAlgorithmFactory component. |  `"SHA-1,MD5"`  | 1.8.0 |  No  | Session Configuration |
| 25. | `"aether.layout.maven2.omitChecksumsForExtensions"` | `java.lang.String` | Comma-separated list of extensions with leading dot (example ".asc") that should have checksums omitted. These are applied to sub-artifacts only. Note: to achieve 1.7.x aether.checksums.forSignature=true behaviour, pass empty string as value for this property. |  `".asc,.sigstore"`  | 1.8.0 |  No  | Session Configuration |
| 26. | `"aether.lrm.enhanced.localPrefix"` | `java.lang.String` | The prefix to use for locally installed artifacts. |  `"installed"`  | 1.8.1 |  No  | Session Configuration |
| 27. | `"aether.lrm.enhanced.releasesPrefix"` | `java.lang.String` | The prefix to use for release artifacts. |  `"releases"`  | 1.8.1 |  No  | Session Configuration |
| 28. | `"aether.lrm.enhanced.remotePrefix"` | `java.lang.String` | The prefix to use for remotely cached artifacts. |  `"cached"`  | 1.8.1 |  No  | Session Configuration |
| 29. | `"aether.lrm.enhanced.snapshotsPrefix"` | `java.lang.String` | The prefix to use for snapshot artifacts. |  `"snapshots"`  | 1.8.1 |  No  | Session Configuration |
| 30. | `"aether.lrm.enhanced.split"` | `java.lang.Boolean` | Whether LRM should split local and remote artifacts. |  `false`  | 1.8.1 |  No  | Session Configuration |
| 31. | `"aether.lrm.enhanced.splitLocal"` | `java.lang.Boolean` | Whether locally installed artifacts should be split by version (release/snapshot). |  `false`  | 1.8.1 |  No  | Session Configuration |
| 32. | `"aether.lrm.enhanced.splitRemote"` | `java.lang.Boolean` | Whether cached artifacts should be split by version (release/snapshot). |  `false`  | 1.8.1 |  No  | Session Configuration |
| 33. | `"aether.lrm.enhanced.splitRemoteRepository"` | `java.lang.Boolean` | Whether cached artifacts should be split by origin repository (repository ID). |  `false`  | 1.8.1 |  No  | Session Configuration |
| 34. | `"aether.lrm.enhanced.splitRemoteRepositoryLast"` | `java.lang.Boolean` | For cached artifacts, if both splitRemote and splitRemoteRepository are set to true sets the splitting order: by default it is repositoryId/version (false) or version/repositoryId (true) |  `false`  | 1.8.1 |  No  | Session Configuration |
| 35. | `"aether.lrm.enhanced.trackingFilename"` | `java.lang.String` | Filename of the file in which to track the remote repositories. |  `"_remote.repositories"`  |  |  No  | Session Configuration |
| 36. | `"aether.metadataResolver.threads"` | `java.lang.Integer` | Number of threads to use in parallel for resolving metadata. |  `4`  | 0.9.0.M4 |  No  | Session Configuration |
| 37. | `"aether.named.diagnostic.enabled"` | `java.lang.Boolean` | System property key to enable locking diagnostic collection. |  `false`  | 1.9.11 |  No  | Java System Properties |
| 38. | `"aether.named.file-lock.attempts"` | `java.lang.Integer` | Tweak: on Windows, the presence of  causes concurrency issues. This flag allows to implement similar fix as referenced JDK bug report: retry and hope the best. Default value is 5 attempts (will retry 4 times). |  `5`  | 1.7.3 |  No  | Java System Properties |
| 39. | `"aether.named.file-lock.deleteLockFiles"` | `java.lang.Boolean` | Tweak: on Windows, the presence of  causes concurrency issues. This flag allows to have it removed from effective flags, at the cost that lockfile directory becomes crowded with 0 byte sized lock files that are never cleaned up. Default value is . |  `true`  | 1.7.3 |  No  | Java System Properties |
| 40. | `"aether.named.file-lock.sleepMillis"` | `java.lang.Long` | Tweak: When  used, the amount of milliseconds to sleep between subsequent retries. Default value is 50 milliseconds. |  `50`  | 1.7.3 |  No  | Java System Properties |
| 41. | `"aether.offline.hosts"` | `java.lang.String` | Comma-separated list of hosts which are supposed to be resolved offline. |  -  |  |  No  | Session Configuration |
| 42. | `"aether.offline.protocols"` | `java.lang.String` | Comma-separated list of protocols which are supposed to be resolved offline. |  -  |  |  No  | Session Configuration |
| 43. | `"aether.priority.cached"` | `java.lang.Boolean` | A flag indicating whether the created ordered components should be cached in session. |  `true`  | 2.0.0 |  No  | Session Configuration |
| 44. | `"aether.priority.implicit"` | `java.lang.Boolean` | A flag indicating whether the priorities of pluggable extensions are implicitly given by their iteration order such that the first extension has the highest priority. If set, an extension's built-in priority as well as any corresponding  configuration properties are ignored when searching for a suitable implementation among the available extensions. This priority mode is meant for cases where the application will present/inject extensions in the desired search order. |  `false`  |  |  No  | Session Configuration |
| 45. | `"aether.remoteRepositoryFilter.groupId"` | `java.lang.Boolean` | Is filter enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 46. | `"aether.remoteRepositoryFilter.groupId.basedir"` | `java.lang.String` | The basedir where to store filter files. If path is relative, it is resolved from local repository root. |  `".remoteRepositoryFilters"`  | 1.9.0 |  No  | Session Configuration |
| 47. | `"aether.remoteRepositoryFilter.groupId.record"` | `java.lang.Boolean` | Should filter go into "record" mode (and collect encountered artifacts)? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 48. | `"aether.remoteRepositoryFilter.prefixes"` | `java.lang.Boolean` | Is filter enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 49. | `"aether.remoteRepositoryFilter.prefixes.basedir"` | `java.lang.String` | The basedir where to store filter files. If path is relative, it is resolved from local repository root. |  `".remoteRepositoryFilters"`  | 1.9.0 |  No  | Session Configuration |
| 50. | `"aether.snapshotFilter"` | `java.lang.Boolean` | The key in the repository session's  used to store a  flag whether this filter should be forced to ban snapshots. By default, snapshots are only filtered if the root artifact is not a snapshot. |  `false`  |  |  No  | Session Configuration |
| 51. | `"aether.syncContext.named.basedir.locksDir"` | `java.lang.String` | The location of the directory toi use for locks. If relative path, it is resolved from the local repository root. |  `".locks"`  | 1.9.0 |  No  | Session Configuration |
| 52. | `"aether.syncContext.named.discriminating.discriminator"` | `java.lang.String` | Configuration property to pass in discriminator, if needed. If not present, it is auto-calculated. |  -  | 1.7.0 |  No  | Session Configuration |
| 53. | `"aether.syncContext.named.discriminating.hostname"` | `java.lang.String` | Configuration property to pass in hostname, if needed. If not present, hostname as reported by system will be used. |  -  | 1.7.0 |  No  | Session Configuration |
| 54. | `"aether.syncContext.named.factory"` | `java.lang.String` | Name of the lock factory to use in session. |  `"rwlock-local"`  | 1.9.1 |  No  | Session Configuration |
| 55. | `"aether.syncContext.named.hashing.depth"` | `java.lang.Integer` | The depth how many levels should adapter create. Acceptable values are 0-4 (inclusive). |  `2`  | 1.9.0 |  No  | Session Configuration |
| 56. | `"aether.syncContext.named.nameMapper"` | `java.lang.String` | Name of the name mapper to use in session. Out of the box supported ones are "static", "gav", "file-gav", "file-hgav", "file-static" and "discriminating". |  `"gav"`  | 1.9.1 |  No  | Session Configuration |
| 57. | `"aether.syncContext.named.redisson.configFile"` | `java.lang.String` | Path to a Redisson configuration file in YAML format. Read official documentation for details. |  -  | 1.7.0 |  No  | Java System Properties |
| 58. | `"aether.syncContext.named.retry"` | `java.lang.Integer` | The amount of retries on time-out. |  `1`  | 1.7.0 |  No  | Session Configuration |
| 59. | `"aether.syncContext.named.retry.wait"` | `java.lang.Long` | The amount of milliseconds to wait between retries on time-out. |  `200`  | 1.7.0 |  No  | Session Configuration |
| 60. | `"aether.syncContext.named.time"` | `java.lang.Long` | The maximum of time amount to be blocked to obtain lock. |  `30`  | 1.7.0 |  No  | Session Configuration |
| 61. | `"aether.syncContext.named.time.unit"` | `java.lang.String` | The unit of maximum time amount to be blocked to obtain lock. Use TimeUnit enum names. |  `"SECONDS"`  | 1.7.0 |  No  | Session Configuration |
| 62. | `"aether.system.dependencyVisitor"` | `java.lang.String` | A flag indicating which visitor should be used to "flatten" the dependency graph into list. Default is same as in older resolver versions "preOrder", while it can accept values like "postOrder" and "levelOrder". |  `"preOrder"`  | 2.0.0 |  No  | Session Configuration |
| 63. | `"aether.transport.apache.https.cipherSuites"` | `java.lang.String` | Comma-separated list of <a href="https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#ciphersuites">Cipher Suites</a> which are enabled for HTTPS connections. |  -  | 2.0.0 |  No  | Session Configuration |
| 64. | `"aether.transport.apache.https.protocols"` | `java.lang.String` | Comma-separated list of <a href="https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#jssenames">Protocols </a> which are enabled for HTTPS connections. |  -  | 2.0.0 |  No  | Session Configuration |
| 65. | `"aether.transport.apache.retryHandler.name"` | `java.lang.String` | The name of retryHandler, supported values are “standard”, that obeys RFC-2616, regarding idempotent methods, and “default” that considers requests w/o payload as idempotent. |  `"standard"`  | 2.0.0 |  Yes  | Session Configuration |
| 66. | `"aether.transport.apache.retryHandler.requestSentEnabled"` | `java.lang.Boolean` | Set to true if it is acceptable to retry non-idempotent requests, that have been sent. |  `false`  | 2.0.0 |  Yes  | Session Configuration |
| 67. | `"aether.transport.apache.useSystemProperties"` | `java.lang.Boolean` | If enabled, underlying Apache HttpClient will use system properties as well to configure itself (typically used to set up HTTP Proxy via Java system properties). See HttpClientBuilder for used properties. This mode is not recommended, better use documented ways of configuration instead. |  `false`  | 2.0.0 |  Yes  | Session Configuration |
| 68. | `"aether.transport.classpath.loader"` | `java.lang.ClassLoader` | The key in the repository session's  used to store a  from which resources should be retrieved. If unspecified, the of the current thread will be used. |  -  |  |  No  | Session Configuration |
| 69. | `"aether.transport.http.connectTimeout"` | `java.lang.Integer` | The maximum amount of time (in milliseconds) to wait for a successful connection to a remote server. Non-positive values indicate no timeout. |  `10000`  |  |  Yes  | Session Configuration |
| 70. | `"aether.transport.http.connectionMaxTtl"` | `java.lang.Integer` | Total time to live in seconds for an HTTP connection, after that time, the connection will be dropped (no matter for how long it was idle). |  `300`  | 1.9.8 |  Yes  | Session Configuration |
| 71. | `"aether.transport.http.credentialEncoding"` | `java.lang.String` | The encoding/charset to use when exchanging credentials with HTTP servers. Besides this general key, clients may also specify the encoding for a specific remote repository by appending the suffix  to this key when storing the charset name. |  `"ISO-8859-1"`  |  |  Yes  | Session Configuration |
| 72. | `"aether.transport.http.expectContinue"` | `java.lang.Boolean` | Boolean flag should the HTTP transport use expect-continue handshake for PUT requests. Not all transport support this option. This option may be needed for some broken HTTP servers. Default value corresponds to given transport default one (resolver does not override those), but if configuration IS given, it will replace given transport own default value. |  -  | 1.9.17 |  Yes  | Session Configuration |
| 73. | `"aether.transport.http.headers"` | `java.util.Map` | The request headers to use for HTTP-based repository connectors. The headers are specified using a , mapping a header name to its value. Besides this general key, clients may also specify headers for a specific remote repository by appending the suffix  to this key when storing the headers map. The repository-specific headers map is supposed to be complete, i.e. is not merged with the general headers map. |  -  |  |  Yes  | Session Configuration |
| 74. | `"aether.transport.http.localAddress"` | `java.lang.String` | The local address (interface) to use with HTTP transport. Not all transport supports this option. |  -  | 2.0.0 |  Yes  | Session Configuration |
| 75. | `"aether.transport.http.maxConnectionsPerRoute"` | `java.lang.Integer` | The maximum concurrent connections per route HTTP client is allowed to use. |  `50`  | 1.9.8 |  Yes  | Session Configuration |
| 76. | `"aether.transport.http.preemptiveAuth"` | `java.lang.Boolean` | Should HTTP client use preemptive-authentication for all HTTP verbs (works only w/ BASIC). By default, is disabled, as it is considered less secure. |  `false`  | 1.9.6 |  Yes  | Session Configuration |
| 77. | `"aether.transport.http.preemptivePutAuth"` | `java.lang.Boolean` | Boolean flag should the HTTP transport use preemptive-auth for PUT requests. Not all transport support this option. |  `true`  | 2.0.0 (moved out from maven-resolver-transport-http). |  Yes  | Session Configuration |
| 78. | `"aether.transport.http.requestTimeout"` | `java.lang.Integer` | The maximum amount of time (in milliseconds) to wait for remaining data to arrive from a remote server. Note that this timeout does not restrict the overall duration of a request, it only restricts the duration of inactivity between consecutive data packets. Non-positive values indicate no timeout. |  `1800000`  |  |  Yes  | Session Configuration |
| 79. | `"aether.transport.http.retryHandler.count"` | `java.lang.Integer` | The maximum number of times a request to a remote server should be retried in case of an error. |  `3`  | 1.9.6 |  Yes  | Session Configuration |
| 80. | `"aether.transport.http.retryHandler.interval"` | `java.lang.Long` | The initial retry interval in millis of request to a remote server should be waited in case of "too many requests" (HTTP codes 429 and 503). Accepts long as milliseconds. This value is used if remote server does not use  header, in which case Server value is obeyed. |  `5000`  | 1.9.16 |  Yes  | Session Configuration |
| 81. | `"aether.transport.http.retryHandler.intervalMax"` | `java.lang.Long` | The maximum retry interval in millis of request to a remote server above which the request should be aborted instead. In theory, a malicious server could tell Maven "come back after 100 years" that would stall the build for some. Using this parameter Maven will fail the request instead, if interval is above this value. |  `300000`  | 1.9.16 |  Yes  | Session Configuration |
| 82. | `"aether.transport.http.retryHandler.serviceUnavailable"` | `java.lang.String` | The HTTP codes of remote server responses that should be handled as "too many requests" (examples: HTTP codes 429 and 503). Accepts comma separated list of HTTP response codes. |  `"429,503"`  | 1.9.16 |  Yes  | Session Configuration |
| 83. | `"aether.transport.http.reuseConnections"` | `java.lang.Boolean` | Should HTTP client reuse connections (in other words, pool connections) or not? |  `true`  | 1.9.8 |  Yes  | Session Configuration |
| 84. | `"aether.transport.http.supportWebDav"` | `java.lang.Boolean` | Boolean flag should the HTTP transport support WebDAV remote. Not all transport support this option. |  `false`  | 2.0.0 (moved out from maven-resolver-transport-http). |  Yes  | Session Configuration |
| 85. | `"aether.transport.http.userAgent"` | `java.lang.String` | The user agent that repository connectors should report to servers. |  `"Aether"`  |  |  No  | Session Configuration |
| 86. | `"aether.transport.https.securityMode"` | `java.lang.String` | The mode that sets HTTPS transport "security mode": to ignore any SSL errors (certificate validity checks, hostname verification). The default value is . |  `"default"`  | 1.9.6 |  Yes  | Session Configuration |
| 87. | `"aether.transport.jdk.httpVersion"` | `java.lang.String` | Use string representation of HttpClient version enum "HTTP_2" or "HTTP_1_1" to set default HTTP protocol to use. |  `"HTTP_2"`  | 2.0.0 |  Yes  | Session Configuration |
| 88. | `"aether.transport.wagon.config"` | `java.lang.Object` | The configuration to use for the Wagon provider. |  -  |  |  Yes  | Session Configuration |
| 89. | `"aether.transport.wagon.perms.dirMode"` | `java.lang.String` | Octal numerical notation of permissions to set for newly created directories. Only considered by certain Wagon providers. |  -  |  |  Yes  | Session Configuration |
| 90. | `"aether.transport.wagon.perms.fileMode"` | `java.lang.String` | Octal numerical notation of permissions to set for newly created files. Only considered by certain Wagon providers. |  -  |  |  Yes  | Session Configuration |
| 91. | `"aether.transport.wagon.perms.group"` | `java.lang.String` | Group which should own newly created directories/files. Only considered by certain Wagon providers. |  -  |  |  Yes  | Session Configuration |
| 92. | `"aether.trustedChecksumsSource.sparseDirectory"` | `java.lang.Boolean` | Is checksum source enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 93. | `"aether.trustedChecksumsSource.sparseDirectory.basedir"` | `java.lang.String` | The basedir where checksums are. If relative, is resolved from local repository root. |  `".checksums"`  | 1.9.0 |  No  | Session Configuration |
| 94. | `"aether.trustedChecksumsSource.sparseDirectory.originAware"` | `java.lang.Boolean` | Is source origin aware? |  `true`  | 1.9.0 |  No  | Session Configuration |
| 95. | `"aether.trustedChecksumsSource.summaryFile"` | `java.lang.Boolean` | Is checksum source enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 96. | `"aether.trustedChecksumsSource.summaryFile.basedir"` | `java.lang.String` | The basedir where checksums are. If relative, is resolved from local repository root. |  `".checksums"`  | 1.9.0 |  No  | Session Configuration |
| 97. | `"aether.trustedChecksumsSource.summaryFile.originAware"` | `java.lang.Boolean` | Is source origin aware? |  `true`  | 1.9.0 |  No  | Session Configuration |
| 98. | `"aether.updateCheckManager.sessionState"` | `java.lang.String` | Manages the session state, i.e. influences if the same download requests to artifacts/metadata will happen multiple times within the same RepositorySystemSession. If "enabled" will enable the session state. If "bypass" will enable bypassing (i.e. store all artifact ids/metadata ids which have been updates but not evaluating those). All other values lead to disabling the session state completely. |  `"enabled"`  |  |  No  | Session Configuration |


All properties which have `yes` in the column `Supports Repo ID Suffix` can be optionally configured specifically for a repository id. In that case the configuration property needs to be suffixed with a period followed by the repository id of the repository to configure, e.g. `aether.connector.http.headers.central` for repository with id `central`.

## Property Type Conversion

If the value is not given in the target type the following conversions are applied.

From | To | With
--- | --- | ---
`String` | `boolean` | [`Boolean.parseBoolean(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Boolean.html#parseBoolean(java.lang.String))
`String` | `int` | [`Integer.parseInt(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Integer.html#parseInt(java.lang.String))
`String` | `long` | [`Long.parseLong(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Long.html#parseLong(java.lang.String))
`String` | `float` | [`Float.parseFloat(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Float.html#parseFloat(java.lang.String))

## Set Configuration from Apache Maven

To set one of the configuration options from above just use system variables. As system variables only support String values the type conversion mentioned above needs to be leveraged.
Sometimes Maven uses different default values than the Maven Resolver itself or tries to extract certain values from the `settings.xml`. For details refer to <https://github.com/apache/maven/blob/master/maven-core/src/main/java/org/apache/maven/internal/aether/DefaultRepositorySystemSessionFactory.java>.
