
# Configuration Options
<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->





| No | Key | Type | Description | Default Value | Since | Supports Repo ID suffix | Source |
| --- | --- | --- | --- | --- | --- | --- | --- |
| 1. | `"aether.artifactResolver.postProcessor.trustedChecksums"` | `Boolean` | Is post processor enabled. |  `false`  | 1.9.0 |  No  | Session Configuration |
| 2. | `"aether.artifactResolver.postProcessor.trustedChecksums.checksumAlgorithms"` | `String` | The checksum algorithms to apply during post-processing as comma separated list. |  `"SHA-1"`  | 1.9.0 |  No  | Session Configuration |
| 3. | `"aether.artifactResolver.postProcessor.trustedChecksums.failIfMissing"` | `Boolean` | Should post processor fail resolution if checksum is missing? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 4. | `"aether.artifactResolver.postProcessor.trustedChecksums.record"` | `Boolean` | Should post processor go into "record" mode (and collect checksums instead of validate them)? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 5. | `"aether.artifactResolver.postProcessor.trustedChecksums.snapshots"` | `Boolean` | Should post processor process snapshots as well? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 6. | `"aether.artifactResolver.simpleLrmInterop"` | `Boolean` | Configuration to enable "interoperability" with Simple LRM, but this breaks RRF feature, hence this configuration is IGNORED when RRF is used, and is warmly recommended to leave it disabled even if no RRF is being used. |  `false`  |  |  No  | Session Configuration |
| 7. | `"aether.artifactResolver.snapshotNormalization"` | `Boolean` | Configuration to enable "snapshot normalization", downloaded snapshots from remote with timestamped file names will have file names converted back to baseVersion. It replaces the timestamped snapshot file name with a filename containing the SNAPSHOT qualifier only. This only affects resolving/retrieving artifacts but not uploading those. |  `true`  |  |  No  | Session Configuration |
| 8. | `"aether.chainedLocalRepository.ignoreTailAvailability"` | `Boolean` | When using chained local repository, should be the artifact availability ignored in tail. |  `true`  | 1.9.2 |  No  | Session Configuration |
| 9. | `"aether.checksums.omitChecksumsForExtensions"` | `String` | Comma-separated list of extensions with leading dot (example ".asc") that should have checksums omitted. These are applied to sub-artifacts only. Note: to achieve 1.7.x aether.checksums.forSignature=true behaviour, pass empty string as value for this property. |  `".asc,.sigstore"`  |  |  No  | Session Configuration |
| 10. | `"aether.conflictResolver.verbose"` | `Object` | The key in the repository session's  used to store a  flag controlling the transformer's verbose mode. Accepted values are Boolean types, String type (where "true" would be interpreted as ) or Verbosity enum instances. |  `"NONE"`  |  |  No  | Session Configuration |
| 11. | `"aether.connector.basic.parallelPut"` | `Boolean` | Enables or disables parallel PUT processing (parallel deploys) on basic connector globally or per remote repository. When disabled, connector behaves exactly as in Maven 3.8.x did: GETs are parallel while PUTs are sequential. |  `true`  | 1.9.5 |  Yes  | Session Configuration |
| 12. | `"aether.connector.basic.persistedChecksums"` | `Boolean` | Flag indicating whether checksums which are retrieved during checksum validation should be persisted in the local repository next to the file they provide the checksum for. |  `true`  | 0.9.0.M4 |  No  | Session Configuration |
| 13. | `"aether.connector.basic.smartChecksums"` | `Boolean` | Flag indicating that instead of comparing the external checksum fetched from the remote repo with the calculated one, it should try to extract the reference checksum from the actual artifact response headers This only works for HTTP transports. |  `true`  | 0.9.0.M3 |  No  | Session Configuration |
| 14. | `"aether.connector.basic.threads"` | `Integer` | Flag indicating whether checksums which are retrieved during checksum validation should be persisted in the local repository next to the file they provide the checksum for. |  `5`  | 0.9.0.M4 |  No  | Session Configuration |
| 15. | `"aether.dependencyCollector.bf.skipper"` | `Boolean` | The key in the repository session's  used to store a  flag controlling the resolver's skip mode. |  `true`  | 1.8.0 |  No  | Session Configuration |
| 16. | `"aether.dependencyCollector.bf.threads"` | `Integer` | The count of threads to be used when collecting POMs in parallel. |  `5`  | 1.9.0 |  No  | Session Configuration |
| 17. | `"aether.dependencyCollector.impl"` | `String` | The name of the dependency collector implementation to use: depth-first (original) named "df", and breadth-first (new in 1.8.0) named "bf". Both collectors produce equivalent results, but they may differ performance wise, depending on project being applied to. Our experience shows that existing "df" is well suited for smaller to medium size projects, while "bf" may perform better on huge projects with many dependencies. Experiment (and come back to us!) to figure out which one suits you the better. |  `"bf"`  | 1.8.0 |  No  | Session Configuration |
| 18. | `"aether.dependencyCollector.maxCycles"` | `Integer` | Only up to the given amount cyclic dependencies are emitted. |  `10`  | 1.8.0 |  No  | Session Configuration |
| 19. | `"aether.dependencyCollector.maxExceptions"` | `Integer` | Only exceptions up to the number given in this configuration property are emitted. Exceptions which exceed that number are swallowed. |  `50`  | 1.8.0 |  No  | Session Configuration |
| 20. | `"aether.dependencyCollector.pool.artifact"` | `String` | Flag controlling interning data pool type used by dependency collector for Artifact instances, matters for heap consumption. By default, uses “weak” references (consume less heap). Using “hard” will make it much more memory aggressive and possibly faster (system and Java dependent). Supported values: "hard", "weak". |  `"weak"`  | 1.9.5 |  No  | Session Configuration |
| 21. | `"aether.dependencyCollector.pool.dependency"` | `String` | Flag controlling interning data pool type used by dependency collector for Dependency instances, matters for heap consumption. By default, uses “weak” references (consume less heap). Using “hard” will make it much more memory aggressive and possibly faster (system and Java dependent). Supported values: "hard", "weak". |  `"weak"`  | 1.9.5 |  No  | Session Configuration |
| 22. | `"aether.dependencyCollector.pool.descriptor"` | `String` | Flag controlling interning data pool type used by dependency collector for ArtifactDescriptor (POM) instances, matters for heap consumption. By default, uses “weak” references (consume less heap). Using “hard” will make it much more memory aggressive and possibly faster (system and Java dependent). Supported values: "hard", "weak". |  `"hard"`  | 1.9.5 |  No  | Session Configuration |
| 23. | `"aether.dependencyManager.verbose"` | `Boolean` | The key in the repository session's  used to store a  flag controlling the verbose mode for dependency management. If enabled, the original attributes of a dependency before its update due to dependency management will be recorded * in the node's  when building a dependency graph. |  `false`  |  |  No  | Session Configuration |
| 24. | `"aether.generator.gpg.agentSocketLocations"` | `String` | The GnuPG agent socket(s) to try. Comma separated list of socket paths. If relative, will be resolved from user home directory. |  `".gnupg/S.gpg-agent"`  | 2.0.0 |  No  | Session Configuration |
| 25. | `"aether.generator.gpg.enabled"` | `Boolean` | Whether GnuPG signer is enabled. |  `false`  | 2.0.0 |  No  | Session Configuration |
| 26. | `"aether.generator.gpg.keyFilePath"` | `String` | The path to the OpenPGP transferable secret key file. If relative, is resolved from local repository root. |  `"maven-signing-key.key"`  | 2.0.0 |  No  | Session Configuration |
| 27. | `"aether.generator.gpg.keyFingerprint"` | `String` | The PGP Key fingerprint as hex string (40 characters long), optional. If not set, first secret key found will be used. |  -  | 2.0.0 |  No  | Session Configuration |
| 28. | `"aether.generator.gpg.useAgent"` | `Boolean` | Whether GnuPG agent should be used. |  `true`  | 2.0.0 |  No  | Session Configuration |
| 29. | `"aether.interactive"` | `Boolean` | A flag indicating whether interaction with the user is allowed. |  `false`  |  |  No  | Session Configuration |
| 30. | `"aether.layout.maven2.checksumAlgorithms"` | `String` | Comma-separated list of checksum algorithms with which checksums are validated (downloaded) and generated (uploaded) with this layout. Resolver by default supports following algorithms: MD5, SHA-1, SHA-256 and SHA-512. New algorithms can be added by implementing ChecksumAlgorithmFactory component. |  `"SHA-1,MD5"`  | 1.8.0 |  Yes  | Session Configuration |
| 31. | `"aether.lrm.enhanced.localPrefix"` | `String` | The prefix to use for locally installed artifacts. |  `"installed"`  | 1.8.1 |  No  | Session Configuration |
| 32. | `"aether.lrm.enhanced.releasesPrefix"` | `String` | The prefix to use for release artifacts. |  `"releases"`  | 1.8.1 |  No  | Session Configuration |
| 33. | `"aether.lrm.enhanced.remotePrefix"` | `String` | The prefix to use for remotely cached artifacts. |  `"cached"`  | 1.8.1 |  No  | Session Configuration |
| 34. | `"aether.lrm.enhanced.snapshotsPrefix"` | `String` | The prefix to use for snapshot artifacts. |  `"snapshots"`  | 1.8.1 |  No  | Session Configuration |
| 35. | `"aether.lrm.enhanced.split"` | `Boolean` | Whether LRM should split local and remote artifacts. |  `false`  | 1.8.1 |  No  | Session Configuration |
| 36. | `"aether.lrm.enhanced.splitLocal"` | `Boolean` | Whether locally installed artifacts should be split by version (release/snapshot). |  `false`  | 1.8.1 |  No  | Session Configuration |
| 37. | `"aether.lrm.enhanced.splitRemote"` | `Boolean` | Whether cached artifacts should be split by version (release/snapshot). |  `false`  | 1.8.1 |  No  | Session Configuration |
| 38. | `"aether.lrm.enhanced.splitRemoteRepository"` | `Boolean` | Whether cached artifacts should be split by origin repository (repository ID). |  `false`  | 1.8.1 |  No  | Session Configuration |
| 39. | `"aether.lrm.enhanced.splitRemoteRepositoryLast"` | `Boolean` | For cached artifacts, if both splitRemote and splitRemoteRepository are set to true sets the splitting order: by default it is repositoryId/version (false) or version/repositoryId (true) |  `false`  | 1.8.1 |  No  | Session Configuration |
| 40. | `"aether.lrm.enhanced.trackingFilename"` | `String` | Filename of the file in which to track the remote repositories. |  `"_remote.repositories"`  |  |  No  | Session Configuration |
| 41. | `"aether.metadataResolver.threads"` | `Integer` | Number of threads to use in parallel for resolving metadata. |  `4`  | 0.9.0.M4 |  No  | Session Configuration |
| 42. | `"aether.named.diagnostic.enabled"` | `Boolean` | System property key to enable locking diagnostic collection. |  `false`  | 1.9.11 |  No  | Java System Properties |
| 43. | `"aether.named.file-lock.attempts"` | `Integer` | Tweak: on Windows, the presence of <em>StandardOpenOption#DELETE_ON_CLOSE</em> causes concurrency issues. This flag allows to implement similar fix as referenced JDK bug report: retry and hope the best. Default value is 5 attempts (will retry 4 times). |  `5`  | 1.7.3 |  No  | Java System Properties |
| 44. | `"aether.named.file-lock.deleteLockFiles"` | `Boolean` | Tweak: on Windows, the presence of <em>StandardOpenOption#DELETE_ON_CLOSE</em> causes concurrency issues. This flag allows to have it removed from effective flags, at the cost that lockfile directory becomes crowded with 0 byte sized lock files that are never cleaned up. Default value is  on non-Windows OS. See <a href="https://bugs.openjdk.org/browse/JDK-8252883">JDK-8252883</a> for Windows related bug. Users on Windows can still force "delete on close" by explicitly setting this property to . |  `true`  | 1.7.3 |  No  | Java System Properties |
| 45. | `"aether.named.file-lock.sleepMillis"` | `Long` | Tweak: When  used, the amount of milliseconds to sleep between subsequent retries. Default value is 50 milliseconds. |  `50`  | 1.7.3 |  No  | Java System Properties |
| 46. | `"aether.offline.hosts"` | `String` | Comma-separated list of hosts which are supposed to be resolved offline. |  -  |  |  No  | Session Configuration |
| 47. | `"aether.offline.protocols"` | `String` | Comma-separated list of protocols which are supposed to be resolved offline. |  -  |  |  No  | Session Configuration |
| 48. | `"aether.priority.cached"` | `Boolean` | A flag indicating whether the created ordered components should be cached in session. |  `true`  | 2.0.0 |  No  | Session Configuration |
| 49. | `"aether.priority.implicit"` | `Boolean` | A flag indicating whether the priorities of pluggable extensions are implicitly given by their iteration order such that the first extension has the highest priority. If set, an extension's built-in priority as well as any corresponding  configuration properties are ignored when searching for a suitable implementation among the available extensions. This priority mode is meant for cases where the application will present/inject extensions in the desired search order. |  `false`  |  |  No  | Session Configuration |
| 50. | `"aether.remoteRepositoryFilter.groupId"` | `Boolean` | Is filter enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 51. | `"aether.remoteRepositoryFilter.groupId.basedir"` | `String` | The basedir where to store filter files. If path is relative, it is resolved from local repository root. |  `".remoteRepositoryFilters"`  | 1.9.0 |  No  | Session Configuration |
| 52. | `"aether.remoteRepositoryFilter.groupId.record"` | `Boolean` | Should filter go into "record" mode (and collect encountered artifacts)? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 53. | `"aether.remoteRepositoryFilter.prefixes"` | `Boolean` | Is filter enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 54. | `"aether.remoteRepositoryFilter.prefixes.basedir"` | `String` | The basedir where to store filter files. If path is relative, it is resolved from local repository root. |  `".remoteRepositoryFilters"`  | 1.9.0 |  No  | Session Configuration |
| 55. | `"aether.snapshotFilter"` | `Boolean` | The key in the repository session's  used to store a  flag whether this filter should be forced to ban snapshots. By default, snapshots are only filtered if the root artifact is not a snapshot. |  `false`  |  |  No  | Session Configuration |
| 56. | `"aether.syncContext.named.basedir.locksDir"` | `String` | The location of the directory toi use for locks. If relative path, it is resolved from the local repository root. |  `".locks"`  | 1.9.0 |  No  | Session Configuration |
| 57. | `"aether.syncContext.named.discriminating.discriminator"` | `String` | Configuration property to pass in discriminator, if needed. If not present, it is auto-calculated. |  -  | 1.7.0 |  No  | Session Configuration |
| 58. | `"aether.syncContext.named.discriminating.hostname"` | `String` | Configuration property to pass in hostname, if needed. If not present, hostname as reported by system will be used. |  -  | 1.7.0 |  No  | Session Configuration |
| 59. | `"aether.syncContext.named.factory"` | `String` | Name of the lock factory to use in session. |  `"file-lock"`  | 1.9.1 |  No  | Session Configuration |
| 60. | `"aether.syncContext.named.hashing.depth"` | `Integer` | The depth how many levels should adapter create. Acceptable values are 0-4 (inclusive). |  `2`  | 1.9.0 |  No  | Session Configuration |
| 61. | `"aether.syncContext.named.nameMapper"` | `String` | Name of the name mapper to use in session. Out of the box supported ones are "static", "gav", "file-gav", "file-hgav", "file-static" and "discriminating". |  `"file-gav"`  | 1.9.1 |  No  | Session Configuration |
| 62. | `"aether.syncContext.named.redisson.address"` | `String` | Address of the Redis instance. Optional. |  `"redis://localhost:6379"`  | 2.0.0 |  No  | Java System Properties |
| 63. | `"aether.syncContext.named.redisson.configFile"` | `String` | Path to a Redisson configuration file in YAML format. Read official documentation for details. |  -  | 1.7.0 |  No  | Java System Properties |
| 64. | `"aether.syncContext.named.retry"` | `Integer` | The amount of retries on time-out. |  `1`  | 1.7.0 |  No  | Session Configuration |
| 65. | `"aether.syncContext.named.retry.wait"` | `Long` | The amount of milliseconds to wait between retries on time-out. |  `200l`  | 1.7.0 |  No  | Session Configuration |
| 66. | `"aether.syncContext.named.time"` | `Long` | The maximum of time amount to be blocked to obtain lock. |  `30l`  | 1.7.0 |  No  | Session Configuration |
| 67. | `"aether.syncContext.named.time.unit"` | `String` | The unit of maximum time amount to be blocked to obtain lock. Use TimeUnit enum names. |  `"SECONDS"`  | 1.7.0 |  No  | Session Configuration |
| 68. | `"aether.system.dependencyVisitor"` | `String` | A flag indicating which visitor should be used to "flatten" the dependency graph into list. Default is same as in older resolver versions "preOrder", while it can accept values like "postOrder" and "levelOrder". |  `"preOrder"`  | 2.0.0 |  No  | Session Configuration |
| 69. | `"aether.transport.apache.https.cipherSuites"` | `String` | Comma-separated list of <a href="https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#ciphersuites">Cipher Suites</a> which are enabled for HTTPS connections. |  -  | 2.0.0 |  No  | Session Configuration |
| 70. | `"aether.transport.apache.https.protocols"` | `String` | Comma-separated list of <a href="https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#jssenames">Protocols </a> which are enabled for HTTPS connections. |  -  | 2.0.0 |  No  | Session Configuration |
| 71. | `"aether.transport.apache.retryHandler.name"` | `String` | The name of retryHandler, supported values are “standard”, that obeys RFC-2616, regarding idempotent methods, and “default” that considers requests w/o payload as idempotent. |  `"standard"`  | 2.0.0 |  Yes  | Session Configuration |
| 72. | `"aether.transport.apache.retryHandler.requestSentEnabled"` | `Boolean` | Set to true if it is acceptable to retry non-idempotent requests, that have been sent. |  `false`  | 2.0.0 |  Yes  | Session Configuration |
| 73. | `"aether.transport.apache.useSystemProperties"` | `Boolean` | If enabled, underlying Apache HttpClient will use system properties as well to configure itself (typically used to set up HTTP Proxy via Java system properties). See HttpClientBuilder for used properties. This mode is not recommended, better use documented ways of configuration instead. |  `false`  | 2.0.0 |  Yes  | Session Configuration |
| 74. | `"aether.transport.classpath.loader"` | `ClassLoader` | The key in the repository session's  used to store a  from which resources should be retrieved. If unspecified, the of the current thread will be used. |  -  |  |  No  | Session Configuration |
| 75. | `"aether.transport.http.connectTimeout"` | `Integer` | The maximum amount of time (in milliseconds) to wait for a successful connection to a remote server. Non-positive values indicate no timeout. |  `10000`  |  |  Yes  | Session Configuration |
| 76. | `"aether.transport.http.connectionMaxTtl"` | `Integer` | Total time to live in seconds for an HTTP connection, after that time, the connection will be dropped (no matter for how long it was idle). |  `300`  | 1.9.8 |  Yes  | Session Configuration |
| 77. | `"aether.transport.http.credentialEncoding"` | `String` | The encoding/charset to use when exchanging credentials with HTTP servers. Besides this general key, clients may also specify the encoding for a specific remote repository by appending the suffix  to this key when storing the charset name. |  `"ISO-8859-1"`  |  |  Yes  | Session Configuration |
| 78. | `"aether.transport.http.expectContinue"` | `Boolean` | Boolean flag should the HTTP transport use expect-continue handshake for PUT requests. Not all transport support this option. This option may be needed for some broken HTTP servers. Default value corresponds to given transport default one (resolver does not override those), but if configuration IS given, it will replace given transport own default value. |  -  | 1.9.17 |  Yes  | Session Configuration |
| 79. | `"aether.transport.http.headers"` | `java.util.Map` | The request headers to use for HTTP-based repository connectors. The headers are specified using a , mapping a header name to its value. Besides this general key, clients may also specify headers for a specific remote repository by appending the suffix  to this key when storing the headers map. The repository-specific headers map is supposed to be complete, i.e. is not merged with the general headers map. |  -  |  |  Yes  | Session Configuration |
| 80. | `"aether.transport.http.localAddress"` | `String` | The local address (interface) to use with HTTP transport. Not all transport supports this option. |  -  | 2.0.0 |  Yes  | Session Configuration |
| 81. | `"aether.transport.http.maxConnectionsPerRoute"` | `Integer` | The maximum concurrent connections per route HTTP client is allowed to use. |  `50`  | 1.9.8 |  Yes  | Session Configuration |
| 82. | `"aether.transport.http.preemptiveAuth"` | `Boolean` | Should HTTP client use preemptive-authentication for all HTTP verbs (works only w/ BASIC). By default, is disabled, as it is considered less secure. |  `false`  | 1.9.6 |  Yes  | Session Configuration |
| 83. | `"aether.transport.http.preemptivePutAuth"` | `Boolean` | Boolean flag should the HTTP transport use preemptive-auth for PUT requests. Not all transport support this option. |  `true`  | 2.0.0 (moved out from maven-resolver-transport-http). |  Yes  | Session Configuration |
| 84. | `"aether.transport.http.requestTimeout"` | `Integer` | The maximum amount of time (in milliseconds) to wait for remaining data to arrive from a remote server. Note that this timeout does not restrict the overall duration of a request, it only restricts the duration of inactivity between consecutive data packets. Non-positive values indicate no timeout. |  `1800000`  |  |  Yes  | Session Configuration |
| 85. | `"aether.transport.http.retryHandler.count"` | `Integer` | The maximum number of times a request to a remote server should be retried in case of an error. |  `3`  | 1.9.6 |  Yes  | Session Configuration |
| 86. | `"aether.transport.http.retryHandler.interval"` | `Long` | The initial retry interval in millis of request to a remote server should be waited in case of "too many requests" (HTTP codes 429 and 503). Accepts long as milliseconds. This value is used if remote server does not use  header, in which case Server value is obeyed. |  `5000l`  | 1.9.16 |  Yes  | Session Configuration |
| 87. | `"aether.transport.http.retryHandler.intervalMax"` | `Long` | The maximum retry interval in millis of request to a remote server above which the request should be aborted instead. In theory, a malicious server could tell Maven "come back after 100 years" that would stall the build for some. Using this parameter Maven will fail the request instead, if interval is above this value. |  `300000l`  | 1.9.16 |  Yes  | Session Configuration |
| 88. | `"aether.transport.http.retryHandler.serviceUnavailable"` | `String` | The HTTP codes of remote server responses that should be handled as "too many requests" (examples: HTTP codes 429 and 503). Accepts comma separated list of HTTP response codes. |  `"429,503"`  | 1.9.16 |  Yes  | Session Configuration |
| 89. | `"aether.transport.http.reuseConnections"` | `Boolean` | Should HTTP client reuse connections (in other words, pool connections) or not? |  `true`  | 1.9.8 |  Yes  | Session Configuration |
| 90. | `"aether.transport.http.supportWebDav"` | `Boolean` | Boolean flag should the HTTP transport support WebDAV remote. Not all transport support this option. |  `false`  | 2.0.0 (moved out from maven-resolver-transport-http). |  Yes  | Session Configuration |
| 91. | `"aether.transport.http.userAgent"` | `String` | The user agent that repository connectors should report to servers. |  `"Aether"`  |  |  No  | Session Configuration |
| 92. | `"aether.transport.https.securityMode"` | `String` | The mode that sets HTTPS transport "security mode": to ignore any SSL errors (certificate validity checks, hostname verification). The default value is . |  `"default"`  | 1.9.6 |  Yes  | Session Configuration |
| 93. | `"aether.transport.jdk.httpVersion"` | `String` | Use string representation of HttpClient version enum "HTTP_2" or "HTTP_1_1" to set default HTTP protocol to use. |  `"HTTP_2"`  | 2.0.0 |  Yes  | Session Configuration |
| 94. | `"aether.transport.jdk.maxConcurrentRequests"` | `Integer` | The hard limit of maximum concurrent requests JDK transport can do. This is a workaround for the fact, that in HTTP/2 mode, JDK HttpClient initializes this value to Integer.MAX_VALUE (!) and lowers it on first response from the remote server (but it may be too late). See JDK bug <a href="https://bugs.openjdk.org/browse/JDK-8225647">JDK-8225647</a> for details. |  `100`  | 2.0.0 |  Yes  | Session Configuration |
| 95. | `"aether.transport.wagon.config"` | `Object` | The configuration to use for the Wagon provider. |  -  |  |  Yes  | Session Configuration |
| 96. | `"aether.transport.wagon.perms.dirMode"` | `String` | Octal numerical notation of permissions to set for newly created directories. Only considered by certain Wagon providers. |  -  |  |  Yes  | Session Configuration |
| 97. | `"aether.transport.wagon.perms.fileMode"` | `String` | Octal numerical notation of permissions to set for newly created files. Only considered by certain Wagon providers. |  -  |  |  Yes  | Session Configuration |
| 98. | `"aether.transport.wagon.perms.group"` | `String` | Group which should own newly created directories/files. Only considered by certain Wagon providers. |  -  |  |  Yes  | Session Configuration |
| 99. | `"aether.trustedChecksumsSource.sparseDirectory"` | `Boolean` | Is checksum source enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 100. | `"aether.trustedChecksumsSource.sparseDirectory.basedir"` | `String` | The basedir where checksums are. If relative, is resolved from local repository root. |  `".checksums"`  | 1.9.0 |  No  | Session Configuration |
| 101. | `"aether.trustedChecksumsSource.sparseDirectory.originAware"` | `Boolean` | Is source origin aware? |  `true`  | 1.9.0 |  No  | Session Configuration |
| 102. | `"aether.trustedChecksumsSource.summaryFile"` | `Boolean` | Is checksum source enabled? |  `false`  | 1.9.0 |  No  | Session Configuration |
| 103. | `"aether.trustedChecksumsSource.summaryFile.basedir"` | `String` | The basedir where checksums are. If relative, is resolved from local repository root. |  `".checksums"`  | 1.9.0 |  No  | Session Configuration |
| 104. | `"aether.trustedChecksumsSource.summaryFile.originAware"` | `Boolean` | Is source origin aware? |  `true`  | 1.9.0 |  No  | Session Configuration |
| 105. | `"aether.updateCheckManager.sessionState"` | `String` | Manages the session state, i.e. influences if the same download requests to artifacts/metadata will happen multiple times within the same RepositorySystemSession. If "enabled" will enable the session state. If "bypass" will enable bypassing (i.e. store all artifact ids/metadata ids which have been updates but not evaluating those). All other values lead to disabling the session state completely. |  `"enabled"`  |  |  No  | Session Configuration |


All properties which have `yes` in the column `Supports Repo ID Suffix` can be optionally configured specifically for a repository id. In that case the configuration property needs to be suffixed with a period followed by the repository id of the repository to configure, e.g. `aether.connector.http.headers.central` for repository with id `central`.

## Property Type Conversion

If the value is not given in the target type the following conversions are applied.

From | To | With
--- | --- | ---
`String` | `boolean` | [`Boolean.parseBoolean(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Boolean.html#parseBoolean(java.lang.String))
`String` | `int` | [`Integer.parseInt(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Integer.html#parseInt(java.lang.String))
`String` | `long` | [`Long.parseLong(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Long.html#parseLong(java.lang.String))
`String` | `float` | [`Float.parseFloat(...)`](https://docs.oracle.com/javase/7/docs/api/java/lang/Float.html#parseFloat(java.lang.String))

## Set Configuration from Apache Maven

To set one of the configuration options from above just use system variables. As system variables only support String values the type conversion mentioned above needs to be leveraged.
Sometimes Maven uses different default values than the Maven Resolver itself or tries to extract certain values from the `settings.xml`. For details refer to <https://github.com/apache/maven/blob/master/maven-core/src/main/java/org/apache/maven/internal/aether/DefaultRepositorySystemSessionFactory.java>.
