package org.apache.maven.plugin.changelog.stubs;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.model.Scm;
import org.codehaus.plexus.PlexusTestCase;

import java.io.File;

/**
 * @author Edwin Punzalan
 * @version $Id: MavenProjectStub.java 1517983 2013-08-27 20:57:20Z krosenvold $
 */
public class MavenProjectStub
    extends org.apache.maven.plugin.testing.stubs.MavenProjectStub
{
    public static int testCounter = 0;

    public MavenProjectStub()
    {
        super();

        testCounter++;
    }

    /**
     * {@inheritDoc}
     */
    public Scm getScm()
    {
        Scm scm = new Scm();

        scm.setConnection( "scm://" );

        return scm;
    }

    /**
     * {@inheritDoc}
     */
    public File getBasedir()
    {
        return new File( PlexusTestCase.getBasedir(), "target/test-harness/" + testCounter );
    }
}
