/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.props;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.maven.internal.impl.model.DefaultInterpolator;

@Deprecated
public class MavenProperties
extends AbstractMap<String, String> {
    private static final String COMMENT_CHARS = "#!";
    private static final char[] SEPARATORS = new char[]{'=', ':'};
    private static final char[] WHITE_SPACE = new char[]{' ', '\t', '\f'};
    static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;
    private final Map<String, String> storage = new LinkedHashMap<String, String>();
    private final Map<String, Layout> layout = new LinkedHashMap<String, Layout>();
    private List<String> header;
    private List<String> footer;
    private Path location;
    private Function<String, String> callback;
    boolean substitute = true;
    boolean typed;

    public MavenProperties() {
    }

    public MavenProperties(Path location) throws IOException {
        this(location, null);
    }

    public MavenProperties(Path location, Function<String, String> callback) throws IOException {
        this.location = location;
        this.callback = callback;
        if (Files.exists(location, new LinkOption[0])) {
            this.load(location);
        }
    }

    public MavenProperties(boolean substitute) {
        this.substitute = substitute;
    }

    public MavenProperties(Path location, boolean substitute) {
        this.location = location;
        this.substitute = substitute;
    }

    public void load(Path location) throws IOException {
        try (InputStream is = Files.newInputStream(location, new OpenOption[0]);){
            this.load(is);
        }
    }

    public void load(URL location) throws IOException {
        try (InputStream is = location.openStream();){
            this.load(is);
        }
    }

    public void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is, DEFAULT_ENCODING));
    }

    public void load(Reader reader) throws IOException {
        this.loadLayout(reader, false);
    }

    public void save() throws IOException {
        this.save(this.location);
    }

    public void save(Path location) throws IOException {
        try (OutputStream os = Files.newOutputStream(location, new OpenOption[0]);){
            this.save(os);
        }
    }

    public void save(OutputStream os) throws IOException {
        this.save(new OutputStreamWriter(os, DEFAULT_ENCODING));
    }

    public void save(Writer writer) throws IOException {
        this.saveLayout(writer, this.typed);
    }

    public void store(OutputStream os, String comment) throws IOException {
        this.save(os);
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.get(key) != null) {
            return (String)this.get(key);
        }
        return defaultValue;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new Iterator<Map.Entry<String, String>>(){
                    final Iterator<Map.Entry<String, String>> keyIterator;
                    {
                        this.keyIterator = MavenProperties.this.storage.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        final Map.Entry<String, String> entry = this.keyIterator.next();
                        return new Map.Entry<String, String>(){

                            @Override
                            public String getKey() {
                                return (String)entry.getKey();
                            }

                            @Override
                            public String getValue() {
                                return (String)entry.getValue();
                            }

                            @Override
                            public String setValue(String value) {
                                Layout l;
                                String old = entry.setValue(value);
                                if (!(old != null && old.equals(value) || (l = MavenProperties.this.layout.get(entry.getKey())) == null)) {
                                    l.clearValue();
                                }
                                return old;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.keyIterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return MavenProperties.this.storage.size();
            }
        };
    }

    public Enumeration<?> propertyNames() {
        return Collections.enumeration(this.storage.keySet());
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public String put(String key, String value) {
        Layout l;
        String old = this.storage.put(key, value);
        if (!(old != null && old.equals(value) || (l = this.layout.get(key)) == null)) {
            l.clearValue();
        }
        return old;
    }

    void putAllSubstituted(Map<? extends String, ? extends String> m) {
        this.storage.putAll(m);
    }

    public String put(String key, List<String> commentLines, List<String> valueLines) {
        commentLines = new ArrayList<String>(commentLines);
        valueLines = new ArrayList<String>(valueLines);
        String escapedKey = MavenProperties.escapeKey(key);
        StringBuilder sb = new StringBuilder();
        if (valueLines.isEmpty()) {
            valueLines.add(escapedKey + "=");
            sb.append(escapedKey).append("=");
        } else {
            String rv0;
            String val0 = valueLines.get(0);
            String string = rv0 = this.typed ? val0 : MavenProperties.escapeJava(val0);
            if (!val0.trim().startsWith(escapedKey)) {
                valueLines.set(0, escapedKey + " = " + rv0);
                sb.append(escapedKey).append(" = ").append(rv0);
            } else {
                valueLines.set(0, rv0);
                sb.append(rv0);
            }
        }
        for (int i = 1; i < valueLines.size(); ++i) {
            String val = valueLines.get(i);
            valueLines.set(i, this.typed ? val : MavenProperties.escapeJava(val));
            while (!val.isEmpty() && Character.isWhitespace(val.charAt(0))) {
                val = val.substring(1);
            }
            sb.append(val);
        }
        String[] property = PropertiesReader.parseProperty(sb.toString());
        this.layout.put(key, new Layout(commentLines, valueLines));
        return this.storage.put(key, property[1]);
    }

    public String put(String key, List<String> commentLines, String value) {
        commentLines = new ArrayList<String>(commentLines);
        this.layout.put(key, new Layout(commentLines, null));
        return this.storage.put(key, value);
    }

    public String put(String key, String comment, String value) {
        return this.put(key, Collections.singletonList(comment), value);
    }

    public boolean update(Map<String, String> props) {
        MavenProperties properties;
        if (props instanceof MavenProperties) {
            properties = (MavenProperties)props;
        } else {
            properties = new MavenProperties();
            properties.putAll(props);
        }
        return this.update(properties);
    }

    public boolean update(MavenProperties properties) {
        boolean modified = false;
        for (String key : new ArrayList(this.keySet())) {
            if (properties.containsKey(key)) continue;
            this.remove(key);
            modified = true;
        }
        for (String key : properties.keySet()) {
            String v = (String)this.get(key);
            List<String> comments = properties.getComments(key);
            List<String> value = properties.getRaw(key);
            if (v == null) {
                this.put(key, comments, value);
                modified = true;
                continue;
            }
            if (v.equals(properties.get(key))) continue;
            if (comments.isEmpty()) {
                comments = this.getComments(key);
            }
            this.put(key, comments, value);
            modified = true;
        }
        return modified;
    }

    public List<String> getRaw(String key) {
        if (this.layout.containsKey(key) && this.layout.get(key).getValueLines() != null) {
            return new ArrayList<String>(this.layout.get(key).getValueLines());
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.storage.containsKey(key)) {
            result.add(this.storage.get(key));
        }
        return result;
    }

    public List<String> getComments(String key) {
        if (this.layout.containsKey(key) && this.layout.get(key).getCommentLines() != null) {
            return new ArrayList<String>(this.layout.get(key).getCommentLines());
        }
        return new ArrayList<String>();
    }

    @Override
    public String remove(Object key) {
        Layout l = this.layout.get(key);
        if (l != null) {
            l.clearValue();
        }
        return this.storage.remove(key);
    }

    @Override
    public void clear() {
        for (Layout l : this.layout.values()) {
            l.clearValue();
        }
        this.storage.clear();
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public List<String> getFooter() {
        return this.footer;
    }

    public void setFooter(List<String> footer) {
        this.footer = footer;
    }

    protected void loadLayout(Reader in, boolean maybeTyped) throws IOException {
        PropertiesReader reader = new PropertiesReader(in, maybeTyped);
        boolean hasProperty = false;
        while (reader.nextProperty()) {
            hasProperty = true;
            this.storage.put(reader.getPropertyName(), reader.getPropertyValue());
            int idx = this.checkHeaderComment(reader.getCommentLines());
            this.layout.put(reader.getPropertyName(), new Layout((List<String>)(idx < reader.getCommentLines().size() ? new ArrayList<String>(reader.getCommentLines().subList(idx, reader.getCommentLines().size())) : null), new ArrayList<String>(reader.getValueLines())));
        }
        boolean bl = this.typed = maybeTyped && reader.typed != null && reader.typed != false;
        if (!this.typed) {
            for (Map.Entry<String, String> e : this.storage.entrySet()) {
                e.setValue(MavenProperties.unescapeJava(e.getValue()));
            }
        }
        if (hasProperty) {
            this.footer = new ArrayList<String>(reader.getCommentLines());
        } else {
            this.header = new ArrayList<String>(reader.getCommentLines());
        }
        if (this.substitute) {
            this.substitute();
        }
    }

    public void substitute() {
        this.substitute(this.callback);
    }

    public void substitute(Function<String, String> callback) {
        new DefaultInterpolator().interpolate(this.storage, callback);
    }

    protected void saveLayout(Writer out, boolean typed) throws IOException {
        PropertiesWriter writer = new PropertiesWriter(out, typed);
        if (this.header != null) {
            for (String s : this.header) {
                writer.writeln(s);
            }
        }
        for (String key : this.storage.keySet()) {
            Layout l = this.layout.get(key);
            if (l != null && l.getCommentLines() != null) {
                for (String s : l.getCommentLines()) {
                    writer.writeln(s);
                }
            }
            if (l != null && l.getValueLines() != null) {
                for (int i = 0; i < l.getValueLines().size(); ++i) {
                    String s;
                    s = l.getValueLines().get(i);
                    if (i < l.getValueLines().size() - 1) {
                        writer.writeln(s + "\\");
                        continue;
                    }
                    writer.writeln(s);
                }
                continue;
            }
            writer.writeProperty(key, this.storage.get(key));
        }
        if (this.footer != null) {
            for (String s : this.footer) {
                writer.writeln(s);
            }
        }
        writer.flush();
    }

    private int checkHeaderComment(List<String> commentLines) {
        if (this.getHeader() == null && this.layout.isEmpty()) {
            int index;
            for (index = commentLines.size() - 1; index >= 0 && !commentLines.get(index).isEmpty(); --index) {
            }
            this.setHeader(new ArrayList<String>(commentLines.subList(0, index + 1)));
            return index + 1;
        }
        return 0;
    }

    static boolean isCommentLine(String line) {
        String s = line.trim();
        return s.isEmpty() || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    protected static String unescapeJava(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder out = new StringBuilder(sz);
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + String.valueOf(unicode), nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\'': {
                        out.append('\'');
                        break;
                    }
                    case '\"': {
                        out.append('\"');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    protected static String escapeJava(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder out = new StringBuilder(sz * 2);
        block11: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.append("\\u").append(MavenProperties.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.append("\\u0").append(MavenProperties.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.append("\\u00").append(MavenProperties.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00").append(MavenProperties.hex(ch));
                            break;
                        }
                        out.append("\\u000").append(MavenProperties.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block11;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block11;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    protected static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static boolean contains(char[] array, char valueToFind) {
        if (array == null) {
            return false;
        }
        for (char c : array) {
            if (valueToFind != c) continue;
            return true;
        }
        return false;
    }

    private static String escapeKey(String key) {
        StringBuilder newkey = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (MavenProperties.contains(SEPARATORS, c) || MavenProperties.contains(WHITE_SPACE, c)) {
                newkey.append('\\');
                newkey.append(c);
                continue;
            }
            newkey.append(c);
        }
        return newkey.toString();
    }

    protected static class Layout {
        private List<String> commentLines;
        private List<String> valueLines;

        public Layout() {
        }

        public Layout(List<String> commentLines, List<String> valueLines) {
            this.commentLines = commentLines;
            this.valueLines = valueLines;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public void setCommentLines(List<String> commentLines) {
            this.commentLines = commentLines;
        }

        public List<String> getValueLines() {
            return this.valueLines;
        }

        public void setValueLines(List<String> valueLines) {
            this.valueLines = valueLines;
        }

        public void clearValue() {
            this.valueLines = null;
        }
    }

    public static class PropertiesReader
    extends LineNumberReader {
        private final List<String> commentLines = new ArrayList<String>();
        private final List<String> valueLines = new ArrayList<String>();
        private String propertyName;
        private String propertyValue;
        private boolean maybeTyped;
        Boolean typed;

        public PropertiesReader(Reader reader, boolean maybeTyped) {
            super(reader);
            this.maybeTyped = maybeTyped;
        }

        public String readProperty() throws IOException {
            this.commentLines.clear();
            this.valueLines.clear();
            StringBuilder buffer = new StringBuilder();
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (MavenProperties.isCommentLine(line)) {
                    this.commentLines.add(line);
                    continue;
                }
                boolean combine = PropertiesReader.checkCombineLines(line);
                if (combine) {
                    line = line.substring(0, line.length() - 1);
                }
                this.valueLines.add(line);
                while (line.length() > 0 && MavenProperties.contains(WHITE_SPACE, line.charAt(0))) {
                    line = line.substring(1, line.length());
                }
                buffer.append(line);
                if (!combine) break;
            }
            return buffer.toString();
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            String[] property = PropertiesReader.parseProperty(line);
            boolean typed = false;
            if (this.maybeTyped && property[1].length() >= 2) {
                typed = property[1].matches("\\s*[TILFDXSCBilfdxscb]?(\\[[\\S\\s]*\\]|\\([\\S\\s]*\\)|\\{[\\S\\s]*\\}|\"[\\S\\s]*\")\\s*");
            }
            this.typed = this.typed == null ? Boolean.valueOf(typed) : Boolean.valueOf(this.typed & typed);
            this.propertyName = MavenProperties.unescapeJava(property[0]);
            this.propertyValue = property[1];
            return true;
        }

        public List<String> getCommentLines() {
            return this.commentLines;
        }

        public List<String> getValueLines() {
            return this.valueLines;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        private static boolean checkCombineLines(String line) {
            int bsCount = 0;
            for (int idx = line.length() - 1; idx >= 0 && line.charAt(idx) == '\\'; --idx) {
                ++bsCount;
            }
            return bsCount % 2 != 0;
        }

        private static String[] parseProperty(String line) {
            String[] result = new String[2];
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            int state = 0;
            block7: for (int pos = 0; pos < line.length(); ++pos) {
                char c = line.charAt(pos);
                switch (state) {
                    case 0: {
                        if (c == '\\') {
                            state = 1;
                            continue block7;
                        }
                        if (MavenProperties.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block7;
                        }
                        if (MavenProperties.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block7;
                        }
                        key.append(c);
                        continue block7;
                    }
                    case 1: {
                        if (MavenProperties.contains(SEPARATORS, c) || MavenProperties.contains(WHITE_SPACE, c)) {
                            key.append(c);
                        } else {
                            key.append('\\');
                            key.append(c);
                        }
                        state = 0;
                        continue block7;
                    }
                    case 2: {
                        if (MavenProperties.contains(WHITE_SPACE, c)) {
                            state = 2;
                            continue block7;
                        }
                        if (MavenProperties.contains(SEPARATORS, c)) {
                            state = 3;
                            continue block7;
                        }
                        value.append(c);
                        state = 4;
                        continue block7;
                    }
                    case 3: {
                        if (MavenProperties.contains(WHITE_SPACE, c)) {
                            state = 3;
                            continue block7;
                        }
                        value.append(c);
                        state = 4;
                        continue block7;
                    }
                    case 4: {
                        value.append(c);
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            result[0] = key.toString();
            result[1] = value.toString();
            return result;
        }
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private boolean typed;

        public PropertiesWriter(Writer writer, boolean typed) {
            super(writer);
            this.typed = typed;
        }

        public void writeProperty(String key, String value) throws IOException {
            this.write(MavenProperties.escapeKey(key));
            this.write(" = ");
            this.write(this.typed ? value : MavenProperties.escapeJava(value));
            this.writeln(null);
        }

        public void writeln(String s) throws IOException {
            if (s != null) {
                this.write(s);
            }
            this.write(LINE_SEPARATOR);
        }
    }
}

