/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Message {
    public static final int BUILD_REQUEST = 1;
    public static final int BUILD_STARTED = 2;
    public static final int BUILD_FINISHED = 3;
    public static final int PROJECT_STARTED = 4;
    public static final int PROJECT_STOPPED = 5;
    public static final int MOJO_STARTED = 6;
    public static final int PROJECT_LOG_MESSAGE = 7;
    public static final int BUILD_LOG_MESSAGE = 8;
    public static final int BUILD_EXCEPTION = 9;
    public static final int KEEP_ALIVE = 10;
    public static final int STOP = 11;
    public static final int DISPLAY = 12;
    public static final int PROMPT = 13;
    public static final int PROMPT_RESPONSE = 14;
    public static final int BUILD_STATUS = 15;
    public static final int KEYBOARD_INPUT = 16;
    public static final int CANCEL_BUILD = 17;
    public static final int TRANSFER_INITIATED = 18;
    public static final int TRANSFER_STARTED = 19;
    public static final int TRANSFER_PROGRESSED = 20;
    public static final int TRANSFER_CORRUPTED = 21;
    public static final int TRANSFER_SUCCEEDED = 22;
    public static final int TRANSFER_FAILED = 23;
    public static final int EXECUTION_FAILURE = 24;
    public static final int PRINT_OUT = 25;
    public static final int PRINT_ERR = 26;
    public static final int REQUEST_INPUT = 27;
    public static final int INPUT_DATA = 28;
    final int type;
    private static final AtomicLong sequence = new AtomicLong();
    final long seq = sequence.incrementAndGet();
    final long timestamp = System.nanoTime();
    private static final String INVALID_BYTE = "Invalid byte";
    private static final int UTF_BUFS_CHAR_CNT = 256;
    private static final int UTF_BUFS_BYTE_CNT = 768;
    private static final ThreadLocal<byte[]> BUF_TLS = ThreadLocal.withInitial(() -> new byte[768]);

    Message(int type) {
        this.type = type;
    }

    public static Message read(DataInputStream input) throws IOException {
        int type = input.read();
        if (type < 0) {
            return null;
        }
        switch (type) {
            case 1: {
                return BuildRequest.read(input);
            }
            case 2: {
                return BuildStarted.read(input);
            }
            case 3: {
                return BuildFinished.read(input);
            }
            case 6: {
                return MojoStartedEvent.read(input);
            }
            case 7: 
            case 12: {
                return ProjectEvent.read(type, input);
            }
            case 9: {
                return BuildException.read(input);
            }
            case 10: {
                return BareMessage.KEEP_ALIVE_SINGLETON;
            }
            case 11: {
                return BareMessage.STOP_SINGLETON;
            }
            case 13: {
                return Prompt.read(input);
            }
            case 14: {
                return PromptResponse.read(input);
            }
            case 4: 
            case 5: 
            case 8: 
            case 15: {
                return StringMessage.read(type, input);
            }
            case 17: {
                return BareMessage.CANCEL_BUILD_SINGLETON;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return TransferEvent.read(type, input);
            }
            case 24: {
                return ExecutionFailureEvent.read(input);
            }
            case 25: 
            case 26: {
                return StringMessage.read(type, input);
            }
            case 27: {
                return RequestInput.read(input);
            }
            case 28: {
                return InputData.read(input);
            }
        }
        throw new IllegalStateException("Unexpected message type: " + type);
    }

    public static Comparator<Message> getMessageComparator() {
        return Comparator.comparingInt(Message::getClassOrder).thenComparingLong(Message::seq);
    }

    public static int getClassOrder(Message m) {
        switch (m.getType()) {
            case 1: 
            case 10: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 12: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 24: {
                return 10;
            }
            case 18: 
            case 19: {
                return 40;
            }
            case 20: {
                return 41;
            }
            case 21: 
            case 22: 
            case 23: {
                return 42;
            }
            case 7: {
                return 50;
            }
            case 8: {
                return 51;
            }
            case 5: {
                return 95;
            }
            case 3: {
                return 96;
            }
            case 9: {
                return 97;
            }
            case 11: {
                return 99;
            }
        }
        throw new IllegalStateException("Unexpected message type " + m.getType() + ": " + String.valueOf(m));
    }

    public long seq() {
        return this.seq;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public void write(DataOutputStream output) throws IOException {
        output.write(this.type);
    }

    static void writeStringList(DataOutputStream output, List<String> value) throws IOException {
        output.writeInt(value.size());
        for (String v : value) {
            Message.writeUTF(output, v);
        }
    }

    static void writeStringMap(DataOutputStream output, Map<String, String> value) throws IOException {
        output.writeInt(value.size());
        for (Map.Entry<String, String> e : value.entrySet()) {
            Message.writeUTF(output, e.getKey());
            Message.writeUTF(output, e.getValue());
        }
    }

    static List<String> readStringList(DataInputStream input) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        int nb = input.readInt();
        for (int i = 0; i < nb; ++i) {
            l.add(Message.readUTF(input));
        }
        return l;
    }

    static Map<String, String> readStringMap(DataInputStream input) throws IOException {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        int nb = input.readInt();
        for (int i = 0; i < nb; ++i) {
            String k = Message.readUTF(input);
            String v = Message.readUTF(input);
            m.put(k, v);
        }
        return m;
    }

    static String readUTF(DataInputStream input) throws IOException {
        byte[] byteBuf = BUF_TLS.get();
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        char[] chars = new char[len];
        int i = 0;
        int cnt = 0;
        int charIdx = 0;
        while (charIdx < len) {
            int b;
            int a;
            if (i == cnt) {
                cnt = input.read(byteBuf, 0, Math.min(768, len - charIdx));
                if (cnt < 0) {
                    throw new EOFException();
                }
                i = 0;
            }
            if ((a = byteBuf[i++] & 0xFF) < 128) {
                chars[charIdx++] = (char)a;
                continue;
            }
            if (a < 192) {
                throw new UTFDataFormatException(INVALID_BYTE);
            }
            if (a < 224) {
                if (i == cnt) {
                    cnt = input.read(byteBuf, 0, Math.min(768, len - charIdx));
                    if (cnt < 0) {
                        throw new EOFException();
                    }
                    i = 0;
                }
                if (((b = byteBuf[i++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException(INVALID_BYTE);
                }
                chars[charIdx++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if (a < 240) {
                int c;
                if (i == cnt) {
                    cnt = input.read(byteBuf, 0, Math.min(768, len - charIdx));
                    if (cnt < 0) {
                        throw new EOFException();
                    }
                    i = 0;
                }
                if (((b = byteBuf[i++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException(INVALID_BYTE);
                }
                if (i == cnt) {
                    cnt = input.read(byteBuf, 0, Math.min(768, len - charIdx));
                    if (cnt < 0) {
                        throw new EOFException();
                    }
                    i = 0;
                }
                if (((c = byteBuf[i++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException(INVALID_BYTE);
                }
                chars[charIdx++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException(INVALID_BYTE);
        }
        return String.valueOf(chars);
    }

    static void writeUTF(DataOutputStream output, String s) throws IOException {
        byte[] byteBuf = BUF_TLS.get();
        if (s == null) {
            output.writeInt(-1);
            return;
        }
        int length = s.length();
        output.writeInt(length);
        int strIdx = 0;
        int byteIdx = 0;
        while (strIdx < length) {
            char c;
            if ((c = s.charAt(strIdx++)) > '\u0000' && c <= '\u007f') {
                byteBuf[byteIdx++] = (byte)c;
            } else if (c <= '\u07ff') {
                byteBuf[byteIdx++] = (byte)(0xC0 | 0x1F & c >> 6);
                byteBuf[byteIdx++] = (byte)(0x80 | 0x3F & c);
            } else {
                byteBuf[byteIdx++] = (byte)(0xE0 | 0xF & c >> 12);
                byteBuf[byteIdx++] = (byte)(0x80 | 0x3F & c >> 6);
                byteBuf[byteIdx++] = (byte)(0x80 | 0x3F & c);
            }
            if (byteIdx <= 764) continue;
            output.write(byteBuf, 0, byteIdx);
            byteIdx = 0;
        }
        if (byteIdx > 0) {
            output.write(byteBuf, 0, byteIdx);
        }
    }

    public int getType() {
        return this.type;
    }

    public static StringMessage buildStatus(String payload) {
        return new StringMessage(15, payload);
    }

    public static RequestInput requestInput(String projectId) {
        return new RequestInput(projectId);
    }

    public static InputData inputResponse(String data) {
        return new InputData(data);
    }

    public static StringMessage out(String message) {
        return new StringMessage(25, message);
    }

    public static StringMessage err(String message) {
        return new StringMessage(26, message);
    }

    public static StringMessage log(String message) {
        return new StringMessage(8, message);
    }

    public static ProjectEvent log(String projectId, String message) {
        return new ProjectEvent(7, projectId, message);
    }

    public static StringMessage keyboardInput(char keyStroke) {
        return new StringMessage(16, String.valueOf(keyStroke));
    }

    public static StringMessage projectStarted(String projectId) {
        return new StringMessage(4, projectId);
    }

    public static StringMessage projectStopped(String projectId) {
        return new StringMessage(5, projectId);
    }

    public static ExecutionFailureEvent executionFailure(String projectId, boolean halted, String exception) {
        return new ExecutionFailureEvent(projectId, halted, exception);
    }

    public static Message mojoStarted(String artifactId, String pluginGroupId, String pluginArtifactId, String pluginGoalPrefix, String pluginVersion, String mojo, String executionId) {
        return new MojoStartedEvent(artifactId, pluginGroupId, pluginArtifactId, pluginGoalPrefix, pluginVersion, mojo, executionId);
    }

    public static ProjectEvent display(String projectId, String message) {
        return new ProjectEvent(12, projectId, message);
    }

    public static TransferEvent transfer(String projectId, int transferEventType, int requestType, String repositoryId, String repositoryUrl, String resourceName, long contentLength, long transferredBytes, String exception) {
        return new TransferEvent(transferEventType, projectId, requestType, repositoryId, repositoryUrl, resourceName, contentLength, transferredBytes, exception);
    }

    public static class BuildRequest
    extends Message {
        final List<String> args;
        final String workingDir;
        final String projectDir;
        final Map<String, String> env;

        public static Message read(DataInputStream input) throws IOException {
            List<String> args = BuildRequest.readStringList(input);
            String workingDir = BuildRequest.readUTF(input);
            String projectDir = BuildRequest.readUTF(input);
            Map<String, String> env = BuildRequest.readStringMap(input);
            return new BuildRequest(args, workingDir, projectDir, env);
        }

        public BuildRequest(List<String> args, String workingDir, String projectDir, Map<String, String> env) {
            super(1);
            this.args = args;
            this.workingDir = workingDir;
            this.projectDir = projectDir;
            this.env = env;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public String getWorkingDir() {
            return this.workingDir;
        }

        public String getProjectDir() {
            return this.projectDir;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public String toString() {
            return "BuildRequest{args=" + String.valueOf(this.args) + ", workingDir='" + this.workingDir + "', projectDir='" + this.projectDir + "'}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            BuildRequest.writeStringList(output, this.args);
            BuildRequest.writeUTF(output, this.workingDir);
            BuildRequest.writeUTF(output, this.projectDir);
            BuildRequest.writeStringMap(output, this.env);
        }
    }

    public static class BuildStarted
    extends Message {
        final String projectId;
        final int projectCount;
        final int maxThreads;
        final int artifactIdDisplayLength;

        public static BuildStarted read(DataInputStream input) throws IOException {
            String projectId = BuildStarted.readUTF(input);
            int projectCount = input.readInt();
            int maxThreads = input.readInt();
            int artifactIdDisplayLength = input.readInt();
            return new BuildStarted(projectId, projectCount, maxThreads, artifactIdDisplayLength);
        }

        public BuildStarted(String projectId, int projectCount, int maxThreads, int artifactIdDisplayLength) {
            super(2);
            this.projectId = projectId;
            this.projectCount = projectCount;
            this.maxThreads = maxThreads;
            this.artifactIdDisplayLength = artifactIdDisplayLength;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public int getProjectCount() {
            return this.projectCount;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public int getArtifactIdDisplayLength() {
            return this.artifactIdDisplayLength;
        }

        public String toString() {
            return "BuildStarted{projectId='" + this.projectId + "', projectCount=" + this.projectCount + ", maxThreads=" + this.maxThreads + ", artifactIdDisplayLength=" + this.artifactIdDisplayLength + "}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            BuildStarted.writeUTF(output, this.projectId);
            output.writeInt(this.projectCount);
            output.writeInt(this.maxThreads);
            output.writeInt(this.artifactIdDisplayLength);
        }
    }

    public static class BuildFinished
    extends Message {
        final int exitCode;

        public static Message read(DataInputStream input) throws IOException {
            int exitCode = input.readInt();
            return new BuildFinished(exitCode);
        }

        public BuildFinished(int exitCode) {
            super(3);
            this.exitCode = exitCode;
        }

        public String toString() {
            return "BuildFinished{exitCode=" + this.exitCode + "}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            output.writeInt(this.exitCode);
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    public static class MojoStartedEvent
    extends Message {
        final String artifactId;
        final String pluginGroupId;
        final String pluginArtifactId;
        final String pluginGoalPrefix;
        final String pluginVersion;
        final String mojo;
        final String executionId;

        public static MojoStartedEvent read(DataInputStream input) throws IOException {
            String artifactId = MojoStartedEvent.readUTF(input);
            String pluginGroupId = MojoStartedEvent.readUTF(input);
            String pluginArtifactId = MojoStartedEvent.readUTF(input);
            String pluginGoalPrefix = MojoStartedEvent.readUTF(input);
            String pluginVersion = MojoStartedEvent.readUTF(input);
            String mojo = MojoStartedEvent.readUTF(input);
            String executionId = MojoStartedEvent.readUTF(input);
            return new MojoStartedEvent(artifactId, pluginGroupId, pluginArtifactId, pluginGoalPrefix, pluginVersion, mojo, executionId);
        }

        public MojoStartedEvent(String artifactId, String pluginGroupId, String pluginArtifactId, String pluginGoalPrefix, String pluginVersion, String mojo, String executionId) {
            super(6);
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId cannot be null");
            this.pluginGroupId = Objects.requireNonNull(pluginGroupId, "pluginGroupId cannot be null");
            this.pluginArtifactId = Objects.requireNonNull(pluginArtifactId, "pluginArtifactId cannot be null");
            this.pluginGoalPrefix = Objects.requireNonNull(pluginGoalPrefix, "pluginGoalPrefix cannot be null");
            this.pluginVersion = Objects.requireNonNull(pluginVersion, "pluginVersion cannot be null");
            this.mojo = Objects.requireNonNull(mojo, "mojo cannot be null");
            this.executionId = Objects.requireNonNull(executionId, "executionId cannot be null");
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getPluginGroupId() {
            return this.pluginGroupId;
        }

        public String getPluginArtifactId() {
            return this.pluginArtifactId;
        }

        public String getPluginGoalPrefix() {
            return this.pluginGoalPrefix;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public String getMojo() {
            return this.mojo;
        }

        public String toString() {
            return "MojoStarted{artifactId='" + this.artifactId + "', pluginGroupId='" + this.pluginGroupId + "', pluginArtifactId='" + this.pluginArtifactId + "', pluginGoalPrefix='" + this.pluginGoalPrefix + "', pluginVersion='" + this.pluginVersion + "', mojo='" + this.mojo + "', executionId='" + this.executionId + "'}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            MojoStartedEvent.writeUTF(output, this.artifactId);
            MojoStartedEvent.writeUTF(output, this.pluginGroupId);
            MojoStartedEvent.writeUTF(output, this.pluginArtifactId);
            MojoStartedEvent.writeUTF(output, this.pluginGoalPrefix);
            MojoStartedEvent.writeUTF(output, this.pluginVersion);
            MojoStartedEvent.writeUTF(output, this.mojo);
            MojoStartedEvent.writeUTF(output, this.executionId);
        }
    }

    public static class ProjectEvent
    extends Message {
        final String projectId;
        final String message;

        public static Message read(int type, DataInputStream input) throws IOException {
            String projectId = ProjectEvent.readUTF(input);
            String message = ProjectEvent.readUTF(input);
            return new ProjectEvent(type, projectId, message);
        }

        private ProjectEvent(int type, String projectId, String message) {
            super(type);
            this.projectId = Objects.requireNonNull(projectId, "projectId cannot be null");
            this.message = Objects.requireNonNull(message, "message cannot be null");
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.mnemonic() + "{projectId='" + this.projectId + "', message='" + this.message + "'}";
        }

        private String mnemonic() {
            switch (this.type) {
                case 12: {
                    return "Display";
                }
                case 7: {
                    return "ProjectLogMessage";
                }
            }
            throw new IllegalStateException("Unexpected type " + this.type);
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            ProjectEvent.writeUTF(output, this.projectId);
            ProjectEvent.writeUTF(output, this.message);
        }
    }

    public static class BuildException
    extends Message {
        final String message;
        final String className;
        final String stackTrace;

        public static Message read(DataInputStream input) throws IOException {
            String message = BuildException.readUTF(input);
            String className = BuildException.readUTF(input);
            String stackTrace = BuildException.readUTF(input);
            return new BuildException(message, className, stackTrace);
        }

        public BuildException(Throwable t) {
            this(t.getMessage(), t.getClass().getName(), BuildException.getStackTrace(t));
        }

        public static String getStackTrace(Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)sw, true));
            return sw.toString();
        }

        public BuildException(String message, String className, String stackTrace) {
            super(9);
            this.message = message;
            this.className = className;
            this.stackTrace = stackTrace;
        }

        public String getMessage() {
            return this.message;
        }

        public String getClassName() {
            return this.className;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public String toString() {
            return "BuildException{message='" + this.message + "', className='" + this.className + "', stackTrace='" + this.stackTrace + "'}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            BuildException.writeUTF(output, this.message);
            BuildException.writeUTF(output, this.className);
            BuildException.writeUTF(output, this.stackTrace);
        }
    }

    public static class BareMessage
    extends Message {
        public static final BareMessage KEEP_ALIVE_SINGLETON = new BareMessage(10);
        public static final BareMessage STOP_SINGLETON = new BareMessage(11);
        public static final BareMessage CANCEL_BUILD_SINGLETON = new BareMessage(17);

        private BareMessage(int type) {
            super(type);
        }

        public String toString() {
            switch (this.type) {
                case 10: {
                    return "KeepAlive";
                }
                case 3: {
                    return "BuildStopped";
                }
                case 11: {
                    return "Stop";
                }
                case 17: {
                    return "BuildCanceled";
                }
            }
            throw new IllegalStateException("Unexpected type " + this.type);
        }
    }

    public static class Prompt
    extends Message {
        final String projectId;
        final String uid;
        final String message;
        final boolean password;

        public static Prompt read(DataInputStream input) throws IOException {
            String projectId = Message.readUTF(input);
            String uid = Message.readUTF(input);
            String message = Message.readUTF(input);
            boolean password = input.readBoolean();
            return new Prompt(projectId, uid, message, password);
        }

        public Prompt(String projectId, String uid, String message, boolean password) {
            super(13);
            this.projectId = projectId;
            this.uid = uid;
            this.message = message;
            this.password = password;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getUid() {
            return this.uid;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isPassword() {
            return this.password;
        }

        public String toString() {
            return "Prompt{projectId='" + this.projectId + "', uid='" + this.uid + "', message='" + this.message + "', password=" + this.password + "}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            Prompt.writeUTF(output, this.projectId);
            Prompt.writeUTF(output, this.uid);
            Prompt.writeUTF(output, this.message);
            output.writeBoolean(this.password);
        }

        public PromptResponse response(String message) {
            return new PromptResponse(this.projectId, this.uid, message);
        }
    }

    public static class PromptResponse
    extends Message {
        final String projectId;
        final String uid;
        final String message;

        public static Message read(DataInputStream input) throws IOException {
            String projectId = Message.readUTF(input);
            String uid = Message.readUTF(input);
            String message = Message.readUTF(input);
            return new PromptResponse(projectId, uid, message);
        }

        private PromptResponse(String projectId, String uid, String message) {
            super(14);
            this.projectId = projectId;
            this.uid = uid;
            this.message = message;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getUid() {
            return this.uid;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "PromptResponse{projectId='" + this.projectId + "', uid='" + this.uid + "', message='" + this.message + "'}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            PromptResponse.writeUTF(output, this.projectId);
            PromptResponse.writeUTF(output, this.uid);
            PromptResponse.writeUTF(output, this.message);
        }
    }

    public static class StringMessage
    extends Message {
        final String message;

        public static StringMessage read(int type, DataInputStream input) throws IOException {
            String message = StringMessage.readUTF(input);
            return new StringMessage(type, message);
        }

        private StringMessage(int type, String message) {
            super(type);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            StringMessage.writeUTF(output, this.message);
        }

        public String toString() {
            return this.mnemonic() + "{payload='" + this.message + "'}";
        }

        private String mnemonic() {
            switch (this.type) {
                case 4: {
                    return "ProjectStarted";
                }
                case 5: {
                    return "ProjectStopped";
                }
                case 15: {
                    return "BuildStatus";
                }
                case 16: {
                    return "KeyboardInput";
                }
                case 8: {
                    return "BuildLogMessage";
                }
                case 25: {
                    return "PrintOut";
                }
                case 26: {
                    return "PrintErr";
                }
            }
            throw new IllegalStateException("Unexpected type " + this.type);
        }
    }

    public static class TransferEvent
    extends Message {
        public static final int INITIATED = 0;
        public static final int STARTED = 1;
        public static final int PROGRESSED = 2;
        public static final int CORRUPTED = 3;
        public static final int SUCCEEDED = 4;
        public static final int FAILED = 5;
        public static final int GET = 0;
        public static final int GET_EXISTENCE = 1;
        public static final int PUT = 2;
        final String projectId;
        final int requestType;
        final String repositoryId;
        final String repositoryUrl;
        final String resourceName;
        final long contentLength;
        final long transferredBytes;
        final String exception;

        private TransferEvent(int type, String projectId, int requestType, String repositoryId, String repositoryUrl, String resourceName, long contentLength, long transferredBytes, String exception) {
            super(type);
            this.projectId = projectId;
            this.requestType = requestType;
            this.repositoryId = repositoryId;
            this.repositoryUrl = repositoryUrl;
            this.resourceName = resourceName;
            this.contentLength = contentLength;
            this.transferredBytes = transferredBytes;
            this.exception = exception;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public int getRequestType() {
            return this.requestType;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public long getTransferredBytes() {
            return this.transferredBytes;
        }

        public String getException() {
            return this.exception;
        }

        public String toString() {
            return this.mnemonic() + "{projectId=" + this.projectId + ", requestType=" + this.requestType + ", repositoryId='" + this.repositoryId + "', repositoryUrl='" + this.repositoryUrl + "', resourceName='" + this.resourceName + "', contentLength=" + this.contentLength + ", transferredBytes=" + this.transferredBytes + (String)(this.exception != null ? ", exception='" + this.exception + "'" : "") + "}";
        }

        private String mnemonic() {
            switch (this.type) {
                case 18: {
                    return "TransferInitiated";
                }
                case 19: {
                    return "TransferStarted";
                }
                case 20: {
                    return "TransferProgressed";
                }
                case 21: {
                    return "TransferCorrupted";
                }
                case 22: {
                    return "TransferSucceeded";
                }
                case 23: {
                    return "TransferFailed";
                }
            }
            throw new IllegalStateException("Unexpected type " + this.type);
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            TransferEvent.writeUTF(output, this.projectId);
            output.writeByte(this.requestType);
            TransferEvent.writeUTF(output, this.repositoryId);
            TransferEvent.writeUTF(output, this.repositoryUrl);
            TransferEvent.writeUTF(output, this.resourceName);
            output.writeLong(this.contentLength);
            output.writeLong(this.transferredBytes);
            TransferEvent.writeUTF(output, this.exception);
        }

        public static TransferEvent read(int type, DataInputStream input) throws IOException {
            String projectId = TransferEvent.readUTF(input);
            byte request = input.readByte();
            String repositoryId = TransferEvent.readUTF(input);
            String repositoryUrl = TransferEvent.readUTF(input);
            String resourceName = TransferEvent.readUTF(input);
            long contentLength = input.readLong();
            long transferredBytes = input.readLong();
            String exception = TransferEvent.readUTF(input);
            return new TransferEvent(type, projectId, request, repositoryId, repositoryUrl, resourceName, contentLength, transferredBytes, exception);
        }
    }

    public static class ExecutionFailureEvent
    extends Message {
        final String projectId;
        final boolean halted;
        final String exception;

        private ExecutionFailureEvent(String projectId, boolean halted, String exception) {
            super(24);
            this.projectId = projectId;
            this.halted = halted;
            this.exception = exception;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public boolean isHalted() {
            return this.halted;
        }

        public String getException() {
            return this.exception;
        }

        public String toString() {
            return "ExecutionFailure{projectId='" + this.projectId + "', halted=" + this.halted + ", exception='" + this.exception + "'}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            ExecutionFailureEvent.writeUTF(output, this.projectId);
            output.writeBoolean(this.halted);
            ExecutionFailureEvent.writeUTF(output, this.exception);
        }

        public static ExecutionFailureEvent read(DataInputStream input) throws IOException {
            String projectId = ExecutionFailureEvent.readUTF(input);
            boolean halted = input.readBoolean();
            String exception = ExecutionFailureEvent.readUTF(input);
            return new ExecutionFailureEvent(projectId, halted, exception);
        }
    }

    public static class RequestInput
    extends Message {
        private String projectId;

        public static RequestInput read(DataInputStream input) throws IOException {
            String projectId = RequestInput.readUTF(input);
            return new RequestInput(projectId);
        }

        public RequestInput(String projectId) {
            super(27);
            this.projectId = projectId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String toString() {
            return "RequestInput{projectId='" + this.projectId + "'}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            RequestInput.writeUTF(output, this.projectId);
        }
    }

    public static class InputData
    extends Message {
        final String data;

        public static Message read(DataInputStream input) throws IOException {
            String data = InputData.readUTF(input);
            return new InputData(data);
        }

        private InputData(String data) {
            super(28);
            this.data = data;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            return "InputResponse{data='" + this.data + "'}";
        }

        @Override
        public void write(DataOutputStream output) throws IOException {
            super.write(output);
            InputData.writeUTF(output, this.data);
        }
    }
}

