/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cling.invoker.LayeredOptions;

public class LayeredMavenOptions<O extends MavenOptions>
extends LayeredOptions<O>
implements MavenOptions {
    public static MavenOptions layerMavenOptions(Collection<MavenOptions> options) {
        List<MavenOptions> o = options.stream().filter(Objects::nonNull).toList();
        if (o.isEmpty()) {
            throw new IllegalArgumentException("No options specified (or all were null)");
        }
        if (o.size() == 1) {
            return o.get(0);
        }
        return new LayeredMavenOptions<MavenOptions>(o);
    }

    protected LayeredMavenOptions(List<O> options) {
        super(options);
    }

    public Optional<String> alternatePomFile() {
        return this.returnFirstPresentOrEmpty(MavenOptions::alternatePomFile);
    }

    public Optional<Boolean> offline() {
        return this.returnFirstPresentOrEmpty(MavenOptions::offline);
    }

    public Optional<Boolean> nonRecursive() {
        return this.returnFirstPresentOrEmpty(MavenOptions::nonRecursive);
    }

    public Optional<Boolean> updateSnapshots() {
        return this.returnFirstPresentOrEmpty(MavenOptions::updateSnapshots);
    }

    public Optional<List<String>> activatedProfiles() {
        return this.collectListIfPresentOrEmpty(MavenOptions::activatedProfiles);
    }

    public Optional<Boolean> suppressSnapshotUpdates() {
        return this.returnFirstPresentOrEmpty(MavenOptions::suppressSnapshotUpdates);
    }

    public Optional<Boolean> strictChecksums() {
        return this.returnFirstPresentOrEmpty(MavenOptions::strictChecksums);
    }

    public Optional<Boolean> relaxedChecksums() {
        return this.returnFirstPresentOrEmpty(MavenOptions::relaxedChecksums);
    }

    public Optional<Boolean> failFast() {
        return this.returnFirstPresentOrEmpty(MavenOptions::failFast);
    }

    public Optional<Boolean> failAtEnd() {
        return this.returnFirstPresentOrEmpty(MavenOptions::failAtEnd);
    }

    public Optional<Boolean> failNever() {
        return this.returnFirstPresentOrEmpty(MavenOptions::failNever);
    }

    public Optional<Boolean> resume() {
        return this.returnFirstPresentOrEmpty(MavenOptions::resume);
    }

    public Optional<String> resumeFrom() {
        return this.returnFirstPresentOrEmpty(MavenOptions::resumeFrom);
    }

    public Optional<List<String>> projects() {
        return this.collectListIfPresentOrEmpty(MavenOptions::projects);
    }

    public Optional<Boolean> alsoMake() {
        return this.returnFirstPresentOrEmpty(MavenOptions::alsoMake);
    }

    public Optional<Boolean> alsoMakeDependents() {
        return this.returnFirstPresentOrEmpty(MavenOptions::alsoMakeDependents);
    }

    public Optional<String> threads() {
        return this.returnFirstPresentOrEmpty(MavenOptions::threads);
    }

    public Optional<String> builder() {
        return this.returnFirstPresentOrEmpty(MavenOptions::builder);
    }

    public Optional<Boolean> noTransferProgress() {
        return this.returnFirstPresentOrEmpty(MavenOptions::noTransferProgress);
    }

    public Optional<Boolean> cacheArtifactNotFound() {
        return this.returnFirstPresentOrEmpty(MavenOptions::cacheArtifactNotFound);
    }

    public Optional<Boolean> strictArtifactDescriptorPolicy() {
        return this.returnFirstPresentOrEmpty(MavenOptions::strictArtifactDescriptorPolicy);
    }

    public Optional<Boolean> ignoreTransitiveRepositories() {
        return this.returnFirstPresentOrEmpty(MavenOptions::ignoreTransitiveRepositories);
    }

    public Optional<List<String>> goals() {
        return this.collectListIfPresentOrEmpty(MavenOptions::goals);
    }

    public MavenOptions interpolate(Collection<Map<String, String>> properties) {
        ArrayList<MavenOptions> interpolatedOptions = new ArrayList<MavenOptions>(this.options.size());
        for (MavenOptions o : this.options) {
            interpolatedOptions.add(o.interpolate(properties));
        }
        return LayeredMavenOptions.layerMavenOptions(interpolatedOptions);
    }
}

