/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.model.RootLocator;
import org.apache.maven.cling.logging.Slf4jConfiguration;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.BasicInterpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public final class Utils {
    private Utils() {
    }

    @Nonnull
    public static String stripLeadingAndTrailingQuotes(String str) {
        Objects.requireNonNull(str, "str");
        int length = str.length();
        if (length > 1 && str.startsWith("\"") && str.endsWith("\"") && str.substring(1, length - 1).indexOf(34) == -1) {
            str = str.substring(1, length - 1);
        }
        return str;
    }

    @Nonnull
    public static Path getCanonicalPath(Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return Utils.getCanonicalPath(path.getParent()).resolve(path.getFileName());
        }
    }

    @Nonnull
    public static Map<String, String> toMap(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    @Nonnull
    public static Properties toProperties(Map<String, String> properties) {
        Objects.requireNonNull(properties, "properties");
        Properties map = new Properties();
        for (String key : properties.keySet()) {
            map.put(key, properties.get(key));
        }
        return map;
    }

    @Nonnull
    public static BasicInterpolator createInterpolator(final Collection<Map<String, String>> properties) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                for (Map props : properties) {
                    String val = (String)props.get(expression);
                    if (val == null) continue;
                    return val;
                }
                return null;
            }
        });
        return interpolator;
    }

    @Nonnull
    public static Function<String, String> prefix(String prefix, Function<String, String> cb) {
        return s -> {
            String v = null;
            if (s.startsWith(prefix)) {
                v = (String)cb.apply(s.substring(prefix.length()));
            }
            return v;
        };
    }

    @SafeVarargs
    @Nonnull
    public static Function<String, String> or(Function<String, String> ... callbacks) {
        return s -> {
            for (Function cb : callbacks) {
                String r = (String)cb.apply(s);
                if (r == null) continue;
                return r;
            }
            return null;
        };
    }

    public static int toMavenExecutionRequestLoggingLevel(Slf4jConfiguration.Level level) {
        Objects.requireNonNull(level, "level");
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Slf4jConfiguration.Level.DEBUG -> 0;
            case Slf4jConfiguration.Level.INFO -> 1;
            case Slf4jConfiguration.Level.ERROR -> 3;
        };
    }

    public static int toPlexusLoggingLevel(Slf4jConfiguration.Level level) {
        Objects.requireNonNull(level, "level");
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Slf4jConfiguration.Level.DEBUG -> 0;
            case Slf4jConfiguration.Level.INFO -> 1;
            case Slf4jConfiguration.Level.ERROR -> 3;
        };
    }

    @Nullable
    public static Path findRoot(Path topDirectory) {
        Objects.requireNonNull(topDirectory, "topDirectory");
        Path rootDirectory = ServiceLoader.load(RootLocator.class).iterator().next().findRoot(topDirectory);
        if (rootDirectory != null) {
            return Utils.getCanonicalPath(rootDirectory);
        }
        return null;
    }

    @Nonnull
    public static Path findMandatoryRoot(Path topDirectory) {
        Objects.requireNonNull(topDirectory, "topDirectory");
        return Utils.getCanonicalPath(Optional.ofNullable(ServiceLoader.load(RootLocator.class).iterator().next().findMandatoryRoot(topDirectory)).orElseThrow());
    }
}

