/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model.profile;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.internal.impl.model.ProfileActivationFilePathInterpolator;
import org.apache.maven.internal.impl.model.profile.ConditionParser;

public class ConditionFunctions {
    private final ProfileActivationContext context;
    private final VersionParser versionParser;
    private final ProfileActivationFilePathInterpolator interpolator;

    public ConditionFunctions(ProfileActivationContext context, VersionParser versionParser, ProfileActivationFilePathInterpolator interpolator) {
        this.context = context;
        this.versionParser = versionParser;
        this.interpolator = interpolator;
    }

    public Object length(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("length function requires exactly one argument");
        }
        String s = ConditionParser.toString(args.get(0));
        return s.length();
    }

    public Object upper(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("upper function requires exactly one argument");
        }
        String s = ConditionParser.toString(args.get(0));
        return s.toUpperCase();
    }

    public Object lower(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("lower function requires exactly one argument");
        }
        String s = ConditionParser.toString(args.get(0));
        return s.toLowerCase();
    }

    public Object substring(List<Object> args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new IllegalArgumentException("substring function requires 2 or 3 arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        int start = ConditionParser.toInt(args.get(1));
        int end = args.size() == 3 ? ConditionParser.toInt(args.get(2)) : s.length();
        return s.substring(start, end);
    }

    public Object indexOf(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("indexOf function requires exactly two arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        String substring = ConditionParser.toString(args.get(1));
        return s.indexOf(substring);
    }

    public Object contains(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("contains function requires exactly two arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        String substring = ConditionParser.toString(args.get(1));
        return s.contains(substring);
    }

    public Object matches(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("matches function requires exactly two arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        String regex = ConditionParser.toString(args.get(1));
        return s.matches(regex);
    }

    public Object not(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("not function requires exactly one argument");
        }
        return ConditionParser.toBoolean(args.get(0)) == false;
    }

    public Object if_(List<Object> args) {
        if (args.size() != 3) {
            throw new IllegalArgumentException("if function requires exactly three arguments");
        }
        boolean condition = ConditionParser.toBoolean(args.get(0));
        return condition ? args.get(1) : args.get(2);
    }

    public Object exists(List<Object> args) throws IOException {
        if (args.size() != 1) {
            throw new IllegalArgumentException("exists function requires exactly one argument");
        }
        String path = ConditionParser.toString(args.get(0));
        return this.fileExists(path);
    }

    public Object missing(List<Object> args) throws IOException {
        if (args.size() != 1) {
            throw new IllegalArgumentException("missing function requires exactly one argument");
        }
        String path = ConditionParser.toString(args.get(0));
        return !this.fileExists(path);
    }

    private boolean fileExists(String path) throws IOException {
        String glob;
        String fixed;
        int firstWildcardIndex;
        String pattern = this.interpolator.interpolate(path, this.context);
        int asteriskIndex = pattern.indexOf(42);
        int questionMarkIndex = pattern.indexOf(63);
        int n = questionMarkIndex < 0 ? asteriskIndex : (firstWildcardIndex = asteriskIndex < 0 ? questionMarkIndex : Math.min(asteriskIndex, questionMarkIndex));
        if (firstWildcardIndex < 0) {
            fixed = pattern;
            glob = "";
        } else {
            int lastSep = pattern.substring(0, firstWildcardIndex).lastIndexOf(File.separatorChar);
            if (lastSep < 0) {
                fixed = "";
                glob = pattern;
            } else {
                fixed = pattern.substring(0, lastSep);
                glob = pattern.substring(lastSep + 1);
            }
        }
        final Path fixedPath = Paths.get(fixed, new String[0]);
        if (!Files.exists(fixedPath, new LinkOption[0])) {
            return false;
        }
        if (!glob.isEmpty()) {
            final PathMatcher matcher = fixedPath.getFileSystem().getPathMatcher("glob:" + glob);
            final AtomicBoolean found = new AtomicBoolean(false);
            Files.walkFileTree(fixedPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (found.get() || matcher.matches(fixedPath.relativize(file))) {
                        found.set(true);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return found.get();
        }
        return true;
    }

    public Object inrange(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("inrange function requires exactly two arguments");
        }
        String version = ConditionParser.toString(args.get(0));
        String range = ConditionParser.toString(args.get(1));
        return this.versionParser.parseVersionRange(range).contains(this.versionParser.parseVersion(version));
    }
}

