/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Scm;
import org.apache.maven.api.model.Site;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.model.ModelUrlNormalizer;
import org.apache.maven.api.services.model.UrlNormalizer;

@Named
@Singleton
public class DefaultModelUrlNormalizer
implements ModelUrlNormalizer {
    private final UrlNormalizer urlNormalizer;

    @Inject
    public DefaultModelUrlNormalizer(UrlNormalizer urlNormalizer) {
        this.urlNormalizer = urlNormalizer;
    }

    @Override
    public Model normalize(Model model, ModelBuilderRequest request) {
        Site site;
        DistributionManagement dist;
        if (model == null) {
            return null;
        }
        Model.Builder builder = Model.newBuilder((Model)model);
        builder.url(this.normalize(model.getUrl()));
        Scm scm = model.getScm();
        if (scm != null) {
            builder.scm(Scm.newBuilder((Scm)scm).url(this.normalize(scm.getUrl())).connection(this.normalize(scm.getConnection())).developerConnection(this.normalize(scm.getDeveloperConnection())).build());
        }
        if ((dist = model.getDistributionManagement()) != null && (site = dist.getSite()) != null) {
            builder.distributionManagement(dist.withSite(site.withUrl(this.normalize(site.getUrl()))));
        }
        return builder.build();
    }

    private String normalize(String url) {
        return this.urlNormalizer.normalize(url);
    }
}

