/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Source;

@Experimental
public interface ToolchainsBuilderRequest {
    @Nonnull
    public ProtoSession getSession();

    @Nonnull
    public Optional<Source> getInstallationToolchainsSource();

    @Nonnull
    public Optional<Source> getUserToolchainsSource();

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull ProtoSession session, @Nullable Source installationToolchainsFile, @Nullable Source userToolchainsSource) {
        return ToolchainsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).installationToolchainsSource(installationToolchainsFile).userToolchainsSource(userToolchainsSource).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull ProtoSession session, @Nullable Path installationToolchainsFile, @Nullable Path userToolchainsPath) {
        return ToolchainsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).installationToolchainsSource(installationToolchainsFile != null && Files.exists(installationToolchainsFile, new LinkOption[0]) ? Source.fromPath(installationToolchainsFile) : null).userToolchainsSource(userToolchainsPath != null && Files.exists(userToolchainsPath, new LinkOption[0]) ? Source.fromPath(userToolchainsPath) : null).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequestBuilder builder() {
        return new ToolchainsBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class ToolchainsBuilderRequestBuilder {
        ProtoSession session;
        Source installationToolchainsSource;
        Source userToolchainsSource;

        public ToolchainsBuilderRequestBuilder session(ProtoSession session) {
            this.session = session;
            return this;
        }

        public ToolchainsBuilderRequestBuilder installationToolchainsSource(Source installationToolchainsSource) {
            this.installationToolchainsSource = installationToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequestBuilder userToolchainsSource(Source userToolchainsSource) {
            this.userToolchainsSource = userToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequest build() {
            return new DefaultToolchainsBuilderRequest(this.session, this.installationToolchainsSource, this.userToolchainsSource);
        }

        private static class DefaultToolchainsBuilderRequest
        extends BaseRequest<ProtoSession>
        implements ToolchainsBuilderRequest {
            private final Source installationToolchainsSource;
            private final Source userToolchainsSource;

            DefaultToolchainsBuilderRequest(@Nonnull ProtoSession session, @Nullable Source installationToolchainsSource, @Nullable Source userToolchainsSource) {
                super(session);
                this.installationToolchainsSource = installationToolchainsSource;
                this.userToolchainsSource = userToolchainsSource;
            }

            @Override
            @Nonnull
            public Optional<Source> getInstallationToolchainsSource() {
                return Optional.ofNullable(this.installationToolchainsSource);
            }

            @Override
            @Nonnull
            public Optional<Source> getUserToolchainsSource() {
                return Optional.ofNullable(this.userToolchainsSource);
            }
        }
    }
}

