/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.internal.impl.resolver.RelocatedArtifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.DefaultDependencyResolutionResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.RepositorySessionDecorator;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.visitor.DependencyGraphDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RepositorySystem repoSystem;
    private final List<RepositorySessionDecorator> decorators;

    @Inject
    public DefaultProjectDependenciesResolver(RepositorySystem repoSystem, List<RepositorySessionDecorator> decorators) {
        this.repoSystem = repoSystem;
        this.decorators = decorators;
    }

    @Override
    public DependencyResolutionResult resolve(DependencyResolutionRequest request) throws DependencyResolutionException {
        DependencyNode node;
        DependencyManagement dependencyManagement;
        RequestTrace trace = RequestTrace.newChild(null, (Object)request);
        DefaultDependencyResolutionResult result = new DefaultDependencyResolutionResult();
        MavenProject project = request.getMavenProject();
        DependencyFilter filter = request.getResolutionFilter();
        RepositorySystemSession session = request.getRepositorySession();
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        if (this.logger.isDebugEnabled() && session.getConfigProperties().get("aether.dependencyManager.verbose") == null) {
            DefaultRepositorySystemSession verbose = new DefaultRepositorySystemSession(session);
            verbose.setConfigProperty("aether.dependencyManager.verbose", (Object)Boolean.TRUE);
            session = verbose;
        }
        for (RepositorySessionDecorator repositorySessionDecorator : this.decorators) {
            RepositorySystemSession repositorySystemSession = repositorySessionDecorator.decorate(project, session);
            if (repositorySystemSession == null) continue;
            session = repositorySystemSession;
        }
        CollectRequest collect = new CollectRequest();
        collect.setRootArtifact(RepositoryUtils.toArtifact(project.getArtifact()));
        collect.setRequestContext("project");
        collect.setRepositories(project.getRemoteProjectRepositories());
        if (project.getDependencyArtifacts() == null) {
            for (Dependency dependency : project.getDependencies()) {
                if (dependency.getGroupId() == null || dependency.getGroupId().isEmpty() || dependency.getArtifactId() == null || dependency.getArtifactId().isEmpty() || dependency.getVersion() == null || dependency.getVersion().isEmpty()) continue;
                collect.addDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        } else {
            HashMap<String, Dependency> hashMap = new HashMap<String, Dependency>();
            for (Dependency dependency2 : project.getDependencies()) {
                ArtifactType type;
                String classifier = dependency2.getClassifier();
                if (classifier == null && (type = stereotypes.get(dependency2.getType())) != null) {
                    classifier = type.getClassifier();
                }
                String key = ArtifactIdUtils.toVersionlessId((String)dependency2.getGroupId(), (String)dependency2.getArtifactId(), (String)dependency2.getType(), (String)classifier);
                hashMap.put(key, dependency2);
            }
            Iterator<org.apache.maven.artifact.Artifact> iterator = project.getDependencyArtifacts().iterator();
            while (iterator.hasNext()) {
                org.apache.maven.artifact.Artifact artifact;
                String key = (artifact = iterator.next()).getDependencyConflictId();
                Dependency dependency3 = (Dependency)hashMap.get(key);
                List exclusions = dependency3 != null ? dependency3.getExclusions() : null;
                org.eclipse.aether.graph.Dependency dep = RepositoryUtils.toDependency(artifact, exclusions);
                if (!DependencyScope.SYSTEM.is(dep.getScope()) && dep.getArtifact().getFile() != null) {
                    Artifact art = dep.getArtifact();
                    art = art.setFile(null).setVersion(art.getBaseVersion());
                    dep = dep.setArtifact(art);
                }
                collect.addDependency(dep);
            }
        }
        if ((dependencyManagement = project.getDependencyManagement()) != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                collect.addManagedDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collect, filter);
        dependencyRequest.setTrace(trace);
        try {
            collect.setTrace(RequestTrace.newChild((RequestTrace)trace, (Object)dependencyRequest));
            node = this.repoSystem.collectDependencies(session, collect).getRoot();
            result.setDependencyGraph(node);
        }
        catch (DependencyCollectionException e) {
            result.setDependencyGraph(e.getResult().getRoot());
            result.setCollectionErrors(e.getResult().getExceptions());
            throw new DependencyResolutionException(result, "Could not collect dependencies for project " + project.getId(), e);
        }
        dependencyRequest.setRoot(node);
        if (this.logger.isWarnEnabled()) {
            for (DependencyNode child : node.getChildren()) {
                String string;
                if (child.getRelocations().isEmpty()) continue;
                Artifact artifact = child.getDependency().getArtifact();
                if (artifact instanceof RelocatedArtifact) {
                    RelocatedArtifact relocated = (RelocatedArtifact)artifact;
                    string = relocated.getMessage();
                } else {
                    string = null;
                }
                String message = string;
                this.logger.warn("The artifact " + String.valueOf(child.getRelocations().get(0)) + " has been relocated to " + String.valueOf(artifact) + (String)(message != null ? ": " + message : ""));
            }
        }
        if (this.logger.isDebugEnabled()) {
            node.accept((DependencyVisitor)new DependencyGraphDumper(arg_0 -> ((Logger)this.logger).debug(arg_0)));
        }
        try {
            this.process(result, this.repoSystem.resolveDependencies(session, dependencyRequest).getArtifactResults());
        }
        catch (org.eclipse.aether.resolution.DependencyResolutionException e) {
            this.process(result, e.getResult().getArtifactResults());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId(), e);
        }
        return result;
    }

    private void process(DefaultDependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult ar : results) {
            DependencyNode node = ar.getRequest().getDependencyNode();
            if (ar.isResolved()) {
                result.addResolvedDependency(node.getDependency());
                continue;
            }
            result.setResolutionErrors(node.getDependency(), ar.getExceptions());
        }
    }
}

