/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.internal.impl.resolver.RelocatedArtifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.MavenPluginDependenciesValidator;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.DependencyGraphDumper;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RepositorySystem repoSystem;
    private final List<MavenPluginDependenciesValidator> dependenciesValidators;

    @Inject
    public DefaultPluginDependenciesResolver(RepositorySystem repoSystem, List<MavenPluginDependenciesValidator> dependenciesValidators) {
        this.repoSystem = repoSystem;
        this.dependenciesValidators = dependenciesValidators;
    }

    private Artifact toArtifact(Plugin plugin, RepositorySystemSession session) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "jar", plugin.getVersion(), session.getArtifactTypeRegistry().get("maven-plugin"));
    }

    @Override
    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, (Object)plugin);
        Artifact pluginArtifact = this.toArtifact(plugin, session);
        try {
            String requiredMavenVersion;
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(true, false));
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor((RepositorySystemSession)pluginSession, request);
            for (MavenPluginDependenciesValidator dependenciesValidator : this.dependenciesValidators) {
                dependenciesValidator.validate(session, pluginArtifact, result);
            }
            pluginArtifact = result.getArtifact();
            if (this.logger.isWarnEnabled() && !result.getRelocations().isEmpty()) {
                Object object;
                if (pluginArtifact instanceof RelocatedArtifact) {
                    RelocatedArtifact relocated = (RelocatedArtifact)pluginArtifact;
                    object = ": " + relocated.getMessage();
                } else {
                    object = "";
                }
                String message = object;
                this.logger.warn("The artifact {} has been relocated to {}{}", new Object[]{result.getRelocations().get(0), pluginArtifact, message});
            }
            if ((requiredMavenVersion = (String)result.getProperties().get("prerequisites.maven")) != null) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginArtifact.getProperties());
                props.put("requiredMavenVersion", requiredMavenVersion);
                pluginArtifact = pluginArtifact.setProperties(props);
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new PluginResolutionException(plugin, e.getResult().getExceptions(), e);
        }
        try {
            ArtifactRequest request = new ArtifactRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            pluginArtifact = this.repoSystem.resolveArtifact(session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, e.getResult().getExceptions(), e);
        }
        return pluginArtifact;
    }

    public DependencyResult resolveCoreExtension(Plugin plugin, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, null, dependencyFilter, repositories, session);
    }

    @Override
    public DependencyResult resolvePlugin(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, pluginArtifact, dependencyFilter, repositories, session);
    }

    @Override
    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, pluginArtifact, dependencyFilter, repositories, session).getRoot();
    }

    private DependencyResult resolveInternal(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, (Object)plugin);
        if (pluginArtifact == null) {
            pluginArtifact = this.toArtifact(plugin, session);
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(new String[]{"provided", "test"});
        DependencyFilter resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)collectionFilter, (DependencyFilter)dependencyFilter);
        try {
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setDependencySelector(session.getDependencySelector());
            pluginSession.setDependencyGraphTransformer(session.getDependencyGraphTransformer());
            CollectRequest request = new CollectRequest();
            request.setRequestContext(REPOSITORY_CONTEXT);
            request.setRepositories(repositories);
            request.setRoot(new Dependency(pluginArtifact, null));
            for (org.apache.maven.model.Dependency dependency : plugin.getDependencies()) {
                Dependency pluginDep = RepositoryUtils.toDependency(dependency, session.getArtifactTypeRegistry());
                if (!DependencyScope.SYSTEM.is(pluginDep.getScope())) {
                    pluginDep = pluginDep.setScope(DependencyScope.RUNTIME.id());
                }
                request.addDependency(pluginDep);
            }
            DependencyRequest depRequest = new DependencyRequest(request, resolutionFilter);
            depRequest.setTrace(trace);
            request.setTrace(RequestTrace.newChild((RequestTrace)trace, (Object)depRequest));
            DependencyNode node = this.repoSystem.collectDependencies((RepositorySystemSession)pluginSession, request).getRoot();
            if (this.logger.isDebugEnabled()) {
                node.accept((DependencyVisitor)new DependencyGraphDumper(arg_0 -> ((Logger)this.logger).debug(arg_0)));
            }
            depRequest.setRoot(node);
            return this.repoSystem.resolveDependencies(session, depRequest);
        }
        catch (DependencyCollectionException e) {
            throw new PluginResolutionException(plugin, e.getResult().getExceptions(), e);
        }
        catch (DependencyResolutionException e) {
            List<Exception> exceptions = Stream.concat(e.getResult().getCollectExceptions().stream(), e.getResult().getArtifactResults().stream().filter(r -> !r.isResolved()).flatMap(r -> r.getExceptions().stream())).collect(Collectors.toList());
            throw new PluginResolutionException(plugin, exceptions, e);
        }
    }
}

