/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.impl.AbstractSession;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.internal.impl.PropertiesAsMap;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;

public class DefaultSession
extends AbstractSession
implements InternalMavenSession {
    private final MavenSession mavenSession;
    private final MavenRepositorySystem mavenRepositorySystem;
    private final RuntimeInformation runtimeInformation;
    private final Map<String, Project> allProjects = new ConcurrentHashMap<String, Project>();

    public DefaultSession(@Nonnull MavenSession session, @Nonnull RepositorySystem repositorySystem, @Nullable List<RemoteRepository> remoteRepositories, @Nonnull MavenRepositorySystem mavenRepositorySystem, @Nonnull Lookup lookup, @Nonnull RuntimeInformation runtimeInformation) {
        super(((MavenSession)Utils.nonNull((Object)session)).getRepositorySession(), repositorySystem, remoteRepositories, remoteRepositories == null ? Utils.map(session.getRequest().getRemoteRepositories(), RepositoryUtils::toRepo) : null, lookup);
        this.mavenSession = session;
        this.mavenRepositorySystem = mavenRepositorySystem;
        this.runtimeInformation = runtimeInformation;
    }

    @Override
    public MavenSession getMavenSession() {
        if (this.mavenSession == null) {
            throw new IllegalArgumentException("Found null mavenSession on session " + String.valueOf(this));
        }
        return this.mavenSession;
    }

    @Override
    public List<Project> getProjects(List<MavenProject> projects) {
        return projects == null ? null : Utils.map(projects, this::getProject);
    }

    @Override
    public Project getProject(MavenProject project) {
        return project != null && project.getBasedir() != null ? this.allProjects.computeIfAbsent(project.getId(), id -> new DefaultProject(this, project)) : null;
    }

    @Override
    public List<ArtifactRepository> toArtifactRepositories(List<RemoteRepository> repositories) {
        return repositories == null ? null : Utils.map(repositories, this::toArtifactRepository);
    }

    @Nonnull
    public Settings getSettings() {
        return this.getMavenSession().getSettings().getDelegate();
    }

    @Nonnull
    public Map<String, String> getUserProperties() {
        return Collections.unmodifiableMap(new PropertiesAsMap((Map)this.getMavenSession().getUserProperties()));
    }

    @Nonnull
    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(new PropertiesAsMap((Map)this.getMavenSession().getSystemProperties()));
    }

    @Nonnull
    public Map<String, String> getEffectiveProperties(@Nullable Project project) {
        HashMap<String, String> result = new HashMap<String, String>(this.getSystemProperties());
        if (project != null) {
            result.putAll(project.getModel().getProperties());
        }
        result.putAll(this.getUserProperties());
        return result;
    }

    @Nonnull
    public Version getMavenVersion() {
        return this.parseVersion(this.runtimeInformation.getMavenVersion());
    }

    public int getDegreeOfConcurrency() {
        return this.getMavenSession().getRequest().getDegreeOfConcurrency();
    }

    @Nonnull
    public Instant getStartTime() {
        return this.getMavenSession().getRequest().getStartTime().toInstant();
    }

    public Path getRootDirectory() {
        return this.getMavenSession().getRequest().getRootDirectory();
    }

    public Path getTopDirectory() {
        return this.getMavenSession().getRequest().getTopDirectory();
    }

    @Nonnull
    public List<Project> getProjects() {
        return this.getProjects(this.getMavenSession().getProjects());
    }

    @Nonnull
    public Map<String, Object> getPluginContext(Project project) {
        Utils.nonNull((Object)project, (String)"project");
        try {
            MojoExecution mojoExecution = (MojoExecution)this.lookup.lookup(MojoExecution.class);
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
            return this.getMavenSession().getPluginContext(pluginDescriptor, ((DefaultProject)project).getProject());
        }
        catch (LookupException e) {
            throw new MavenException("The PluginContext is only available during a mojo execution", (Throwable)e);
        }
    }

    protected Session newSession(RepositorySystemSession repoSession, List<RemoteRepository> repositories) {
        MavenSession ms = (MavenSession)Utils.nonNull((Object)this.getMavenSession());
        MavenSession mss = repoSession != ms.getRepositorySession() ? new MavenSession(repoSession, ms.getRequest(), ms.getResult()) : ms;
        return this.newSession(mss, repositories);
    }

    protected Session newSession(MavenSession mavenSession, List<RemoteRepository> repositories) {
        return new DefaultSession((MavenSession)Utils.nonNull((Object)mavenSession), this.getRepositorySystem(), repositories, this.mavenRepositorySystem, this.lookup, this.runtimeInformation);
    }

    @Override
    public ArtifactRepository toArtifactRepository(RemoteRepository repository) {
        if (repository instanceof DefaultRemoteRepository) {
            org.eclipse.aether.repository.RemoteRepository rr = ((DefaultRemoteRepository)repository).getRepository();
            try {
                return this.mavenRepositorySystem.createRepository(rr.getUrl(), rr.getId(), rr.getPolicy(false).isEnabled(), rr.getPolicy(false).getUpdatePolicy(), rr.getPolicy(true).isEnabled(), rr.getPolicy(true).getUpdatePolicy(), rr.getPolicy(false).getChecksumPolicy());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create repository", e);
            }
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

