/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.MojoExecution;
import org.apache.maven.api.Node;
import org.apache.maven.api.Plugin;
import org.apache.maven.api.plugin.descriptor.MojoDescriptor;
import org.apache.maven.api.plugin.descriptor.PluginDescriptor;
import org.apache.maven.api.plugin.descriptor.lifecycle.Lifecycle;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.impl.DefaultNode;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

public class DefaultMojoExecution
implements MojoExecution {
    private final InternalMavenSession session;
    private final org.apache.maven.plugin.MojoExecution delegate;

    public DefaultMojoExecution(InternalMavenSession session, org.apache.maven.plugin.MojoExecution delegate) {
        this.session = session;
        this.delegate = delegate;
    }

    public org.apache.maven.plugin.MojoExecution getDelegate() {
        return this.delegate;
    }

    public Plugin getPlugin() {
        return new Plugin(){

            public org.apache.maven.api.model.Plugin getModel() {
                return DefaultMojoExecution.this.delegate.getPlugin().getDelegate();
            }

            public PluginDescriptor getDescriptor() {
                return DefaultMojoExecution.this.delegate.getMojoDescriptor().getPluginDescriptor().getPluginDescriptorV4();
            }

            public List<Lifecycle> getLifecycles() {
                try {
                    return Collections.unmodifiableList(new ArrayList(DefaultMojoExecution.this.delegate.getMojoDescriptor().getPluginDescriptor().getLifecycleMappings().values()));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load plugin lifecycles", e);
                }
            }

            public ClassLoader getClassLoader() {
                return DefaultMojoExecution.this.delegate.getMojoDescriptor().getRealm();
            }

            public org.apache.maven.api.Artifact getArtifact() {
                org.apache.maven.artifact.Artifact artifact = DefaultMojoExecution.this.delegate.getMojoDescriptor().getPluginDescriptor().getPluginArtifact();
                Artifact resolverArtifact = RepositoryUtils.toArtifact(artifact);
                return resolverArtifact != null ? DefaultMojoExecution.this.session.getArtifact(resolverArtifact) : null;
            }

            public Map<String, Dependency> getDependenciesMap() {
                DependencyNode resolverNode = DefaultMojoExecution.this.delegate.getMojoDescriptor().getPluginDescriptor().getDependencyNode();
                DefaultNode node = new DefaultNode((InternalSession)DefaultMojoExecution.this.session, resolverNode, false);
                return Collections.unmodifiableMap(node.stream().filter(Objects::nonNull).map(Node::getDependency).filter(Objects::nonNull).collect(Collectors.toMap(d -> d.getGroupId() + ":" + d.getArtifactId(), d -> d)));
            }
        };
    }

    public org.apache.maven.api.model.PluginExecution getModel() {
        return this.delegate.getPlugin().getExecutions().stream().filter(pe -> Objects.equals(pe.getId(), this.getExecutionId())).findFirst().map(PluginExecution::getDelegate).orElse(null);
    }

    public MojoDescriptor getDescriptor() {
        return this.delegate.getMojoDescriptor().getMojoDescriptorV4();
    }

    public String getLifecyclePhase() {
        return this.delegate.getLifecyclePhase();
    }

    public String getExecutionId() {
        return this.delegate.getExecutionId();
    }

    public String getGoal() {
        return this.delegate.getGoal();
    }

    public Optional<XmlNode> getConfiguration() {
        return Optional.of(this.delegate.getConfiguration()).map(Xpp3Dom::getDom);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

