/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.SessionScoped;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.internal.impl.DefaultArtifact;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.Typed;

@Named
@Typed
@SessionScoped
public class DefaultArtifactManager
implements ArtifactManager {
    @Nonnull
    private final InternalMavenSession session;
    private final Map<String, Path> paths = new ConcurrentHashMap<String, Path>();

    @Inject
    public DefaultArtifactManager(@Nonnull InternalMavenSession session) {
        this.session = session;
    }

    @Nonnull
    public Optional<Path> getPath(@Nonnull org.apache.maven.api.Artifact artifact) {
        Path path;
        String id = this.id((org.apache.maven.api.Artifact)Utils.nonNull((Object)artifact, (String)"artifact"));
        if (this.session.getMavenSession().getAllProjects() != null) {
            for (MavenProject project : this.session.getMavenSession().getAllProjects()) {
                if (!id.equals(this.id(project.getArtifact())) || project.getArtifact().getFile() == null) continue;
                return Optional.of(project.getArtifact().getFile().toPath());
            }
        }
        if ((path = this.paths.get(id)) == null && artifact instanceof DefaultArtifact) {
            path = ((DefaultArtifact)artifact).getArtifact().getPath();
        }
        return Optional.ofNullable(path);
    }

    public void setPath(@Nonnull ProducedArtifact artifact, Path path) {
        String id = this.id((org.apache.maven.api.Artifact)Utils.nonNull((Object)artifact, (String)"artifact"));
        if (this.session.getMavenSession().getAllProjects() != null) {
            this.session.getMavenSession().getAllProjects().stream().flatMap(this::getProjectArtifacts).filter(a -> Objects.equals(id, this.id((Artifact)a))).forEach(a -> a.setFile(path != null ? path.toFile() : null));
        }
        if (path == null) {
            this.paths.remove(id);
        } else {
            this.paths.put(id, path);
        }
    }

    private Stream<Artifact> getProjectArtifacts(MavenProject project) {
        return Stream.concat(Stream.of(project.getArtifact()), project.getAttachedArtifacts().stream());
    }

    private String id(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getArtifactHandler().getExtension() + (String)(artifact.getClassifier() == null || artifact.getClassifier().isEmpty() ? "" : ":" + artifact.getClassifier()) + ":" + artifact.getVersion();
    }

    private String id(org.apache.maven.api.Artifact artifact) {
        return artifact.key();
    }
}

