/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.cli.extensions.CoreExtension;

public abstract class BaseInvokerRequest
implements InvokerRequest {
    private final ParserRequest parserRequest;
    private final Path cwd;
    private final Path installationDirectory;
    private final Path userHomeDirectory;
    private final List<String> jvmArguments;
    private final Map<String, String> userProperties;
    private final Map<String, String> systemProperties;
    private final Path topDirectory;
    private final Path rootDirectory;
    private final List<CoreExtension> coreExtensions;
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;

    public BaseInvokerRequest(@Nonnull ParserRequest parserRequest, @Nonnull Path cwd, @Nonnull Path installationDirectory, @Nonnull Path userHomeDirectory, @Nonnull Map<String, String> userProperties, @Nonnull Map<String, String> systemProperties, @Nonnull Path topDirectory, @Nullable Path rootDirectory, @Nullable InputStream in, @Nullable OutputStream out, @Nullable OutputStream err, @Nullable List<CoreExtension> coreExtensions, @Nullable List<String> jvmArguments) {
        this.parserRequest = Objects.requireNonNull(parserRequest);
        this.cwd = Objects.requireNonNull(cwd);
        this.installationDirectory = Objects.requireNonNull(installationDirectory);
        this.userHomeDirectory = Objects.requireNonNull(userHomeDirectory);
        this.jvmArguments = jvmArguments;
        this.userProperties = Objects.requireNonNull(userProperties);
        this.systemProperties = Objects.requireNonNull(systemProperties);
        this.topDirectory = Objects.requireNonNull(topDirectory);
        this.rootDirectory = rootDirectory;
        this.coreExtensions = coreExtensions;
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public ParserRequest parserRequest() {
        return this.parserRequest;
    }

    public Path cwd() {
        return this.cwd;
    }

    public Path installationDirectory() {
        return this.installationDirectory;
    }

    public Path userHomeDirectory() {
        return this.userHomeDirectory;
    }

    public Optional<List<String>> jvmArguments() {
        return Optional.ofNullable(this.jvmArguments);
    }

    public Map<String, String> userProperties() {
        return this.userProperties;
    }

    public Map<String, String> systemProperties() {
        return this.systemProperties;
    }

    public Path topDirectory() {
        return this.topDirectory;
    }

    public Optional<Path> rootDirectory() {
        return Optional.ofNullable(this.rootDirectory);
    }

    public Optional<InputStream> in() {
        return Optional.ofNullable(this.in);
    }

    public Optional<OutputStream> out() {
        return Optional.ofNullable(this.out);
    }

    public Optional<OutputStream> err() {
        return Optional.ofNullable(this.err);
    }

    public Optional<List<CoreExtension>> coreExtensions() {
        return Optional.ofNullable(this.coreExtensions);
    }
}

