/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.exception;

import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.exception.ExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginExecutionException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;

@Named
@Singleton
public class DefaultExceptionHandler
implements ExceptionHandler {
    @Override
    public ExceptionSummary handleException(Throwable exception) {
        return this.handle("", exception);
    }

    private ExceptionSummary handle(String message, Throwable exception) {
        String reference = this.getReference(Collections.newSetFromMap(new IdentityHashMap()), exception);
        ArrayList<ExceptionSummary> children = null;
        if (exception instanceof ProjectBuildingException) {
            List<ProjectBuildingResult> results = ((ProjectBuildingException)exception).getResults();
            children = new ArrayList<ExceptionSummary>();
            for (ProjectBuildingResult result : results) {
                ExceptionSummary child = this.handle(result);
                if (child == null) continue;
                children.add(child);
            }
            message = "The build could not read " + children.size() + " project" + (children.size() == 1 ? "" : "s");
        } else {
            message = this.getMessage((String)message, exception);
        }
        return new ExceptionSummary(exception, (String)message, reference, children);
    }

    private ExceptionSummary handle(ProjectBuildingResult result) {
        ArrayList<ExceptionSummary> children = new ArrayList<ExceptionSummary>();
        for (ModelProblem problem : result.getProblems()) {
            ExceptionSummary child = this.handle(problem, result.getProjectId());
            if (child == null) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            return null;
        }
        String message = System.lineSeparator() + "The project " + (String)(result.getProjectId().isEmpty() ? "" : result.getProjectId() + " ") + "(" + String.valueOf(result.getPomFile()) + ") has " + children.size() + " error" + (children.size() == 1 ? "" : "s");
        return new ExceptionSummary(null, message, null, children);
    }

    private ExceptionSummary handle(ModelProblem problem, String projectId) {
        if (ModelProblem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) >= 0) {
            Object message = problem.getMessage();
            String location = ModelProblemUtils.formatLocation((ModelProblem)problem, (String)projectId);
            if (!location.isEmpty()) {
                message = (String)message + " @ " + location;
            }
            return this.handle((String)message, problem.getException());
        }
        return null;
    }

    private String getReference(Set<Throwable> dejaVu, Throwable exception) {
        Object reference = "";
        if (!dejaVu.add(exception)) {
            return reference;
        }
        if (exception != null) {
            if (exception instanceof MojoExecutionException) {
                reference = MojoExecutionException.class.getSimpleName();
                Throwable cause = exception.getCause();
                if (cause instanceof IOException && (cause = cause.getCause()) instanceof ConnectException) {
                    reference = ConnectException.class.getSimpleName();
                }
            } else if (exception instanceof LinkageError) {
                reference = LinkageError.class.getSimpleName();
            } else if (exception instanceof PluginExecutionException) {
                String message;
                Throwable cause2;
                Throwable cause = exception.getCause();
                if (cause instanceof PluginContainerException && (cause2 = cause.getCause()) instanceof NoClassDefFoundError && (message = cause2.getMessage()) != null && message.contains("org/sonatype/aether/")) {
                    reference = "AetherClassNotFound";
                }
                if (reference == null || ((String)reference).isEmpty()) {
                    reference = this.getReference(dejaVu, cause);
                }
                if (reference == null || ((String)reference).isEmpty()) {
                    reference = exception.getClass().getSimpleName();
                }
            } else if (exception instanceof LifecycleExecutionException) {
                reference = this.getReference(dejaVu, exception.getCause());
            } else if (this.isNoteworthyException(exception)) {
                reference = exception.getClass().getSimpleName();
            }
        }
        if (reference != null && !((String)reference).isEmpty() && !((String)reference).startsWith("http:")) {
            reference = "http://cwiki.apache.org/confluence/display/MAVEN/" + (String)reference;
        }
        return reference;
    }

    private boolean isNoteworthyException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof Error) {
            return true;
        }
        if (exception instanceof RuntimeException) {
            return false;
        }
        return !exception.getClass().getName().startsWith("java");
    }

    private String getMessage(String message, Throwable exception) {
        String fullMessage = message != null ? message : "";
        Set dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        for (Throwable t = exception; t != null && t != t.getCause(); t = t.getCause()) {
            String exceptionMessage = t.getMessage();
            String longMessage = null;
            if (t instanceof AbstractMojoExecutionException) {
                longMessage = ((AbstractMojoExecutionException)t).getLongMessage();
            } else if (t instanceof MojoException) {
                longMessage = ((MojoException)t).getLongMessage();
            }
            if (longMessage != null && !longMessage.isEmpty()) {
                if (exceptionMessage == null || exceptionMessage.isEmpty() || longMessage.contains(exceptionMessage)) {
                    exceptionMessage = longMessage;
                } else if (!exceptionMessage.contains(longMessage)) {
                    exceptionMessage = this.join(exceptionMessage, System.lineSeparator() + longMessage);
                }
            }
            if (exceptionMessage == null || exceptionMessage.isEmpty()) {
                exceptionMessage = t.getClass().getSimpleName();
            }
            if (t instanceof UnknownHostException && !fullMessage.contains("host")) {
                fullMessage = this.join(fullMessage, "Unknown host " + exceptionMessage);
            } else if (!fullMessage.contains(exceptionMessage)) {
                fullMessage = this.join(fullMessage, exceptionMessage);
            }
            if (dejaVu.add(t)) continue;
            fullMessage = this.join(fullMessage, "[CIRCULAR REFERENCE]");
            break;
        }
        return fullMessage.trim();
    }

    private String join(String message1, String message2) {
        Object message = "";
        if (message1 != null && !message1.isEmpty()) {
            message = message1.trim();
        }
        if (message2 != null && !message2.isEmpty()) {
            if (message != null && !((String)message).isEmpty()) {
                message = ((String)message).endsWith(".") || ((String)message).endsWith("!") || ((String)message).endsWith(":") ? (String)message + " " : (String)message + ": ";
            }
            message = (String)message + message2;
        }
        return message;
    }
}

