/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.Collections;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface ArtifactInstallerRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Collection<ProducedArtifact> getArtifacts();

    @Nonnull
    public static ArtifactInstallerRequestBuilder builder() {
        return new ArtifactInstallerRequestBuilder();
    }

    @Nonnull
    public static ArtifactInstallerRequest build(Session session, Collection<ProducedArtifact> artifacts) {
        return ArtifactInstallerRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).artifacts(BaseRequest.nonNull(artifacts, "artifacts cannot be null")).build();
    }

    @NotThreadSafe
    public static class ArtifactInstallerRequestBuilder {
        Session session;
        Collection<ProducedArtifact> artifacts = Collections.emptyList();

        ArtifactInstallerRequestBuilder() {
        }

        @Nonnull
        public ArtifactInstallerRequestBuilder session(@Nonnull Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public ArtifactInstallerRequestBuilder artifacts(@Nullable Collection<ProducedArtifact> artifacts) {
            this.artifacts = artifacts != null ? artifacts : Collections.emptyList();
            return this;
        }

        @Nonnull
        public ArtifactInstallerRequest build() {
            return new DefaultArtifactInstallerRequest(this.session, this.artifacts);
        }

        static class DefaultArtifactInstallerRequest
        extends BaseRequest<Session>
        implements ArtifactInstallerRequest {
            private final Collection<ProducedArtifact> artifacts;

            DefaultArtifactInstallerRequest(@Nonnull Session session, @Nonnull Collection<ProducedArtifact> artifacts) {
                super(session);
                this.artifacts = DefaultArtifactInstallerRequest.unmodifiable(DefaultArtifactInstallerRequest.nonNull(artifacts, "artifacts cannot be null"));
            }

            @Override
            @Nonnull
            public Collection<ProducedArtifact> getArtifacts() {
                return this.artifacts;
            }
        }
    }
}

