/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.ParserException;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cli.CommonsCliDaemonMavenOptions;
import org.apache.maven.cli.DaemonMavenCling;
import org.apache.maven.cling.invoker.BaseParser;
import org.apache.maven.cling.invoker.mvn.MavenParser;
import org.mvndaemon.mvnd.common.Environment;

public class DaemonMavenParser
extends MavenParser {
    protected MavenOptions parseArgs(String source, List<String> args) throws ParserException {
        try {
            return CommonsCliDaemonMavenOptions.parse(source, args.toArray(new String[0]));
        }
        catch (ParseException e) {
            throw new ParserException("Failed to parse source " + source + ": " + e.getMessage(), e.getCause());
        }
    }

    protected Map<String, String> populateSystemProperties(BaseParser.LocalContext context) throws ParserException {
        HashMap<String, String> systemProperties = new HashMap<String, String>(super.populateSystemProperties(context));
        Map env = (Map)((DaemonMavenCling.Environment)context.parserRequest.lookup().lookup(DaemonMavenCling.Environment.class)).get();
        systemProperties.putAll(env);
        return systemProperties;
    }

    protected List<CoreExtension> readCoreExtensionsDescriptor(BaseParser.LocalContext context) {
        return Stream.of(Environment.MVND_CORE_EXTENSIONS.asString().split(";")).filter(s -> s != null && !s.isEmpty()).map(s -> {
            String[] parts = s.split(":");
            return CoreExtension.newBuilder().groupId(parts[0]).artifactId(parts[1]).version(parts[2]).build();
        }).toList();
    }
}

