/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class MavenBuildTimestamp {
    public static final String DEFAULT_BUILD_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final TimeZone DEFAULT_BUILD_TIME_ZONE = TimeZone.getTimeZone("Etc/UTC");
    private final String formattedTimestamp;

    public MavenBuildTimestamp() {
        this(Instant.now());
    }

    public MavenBuildTimestamp(Instant time) {
        this(time, DEFAULT_BUILD_TIMESTAMP_FORMAT);
    }

    public MavenBuildTimestamp(Instant time, Map<String, String> properties) {
        this(time, properties != null ? properties.get("maven.build.timestamp.format") : null);
    }

    @Deprecated
    public MavenBuildTimestamp(Instant time, Properties properties) {
        this(time, properties != null ? properties.getProperty("maven.build.timestamp.format") : null);
    }

    public MavenBuildTimestamp(Instant time, String timestampFormat) {
        if (timestampFormat == null) {
            timestampFormat = DEFAULT_BUILD_TIMESTAMP_FORMAT;
        }
        if (time == null) {
            time = Instant.now();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(timestampFormat);
        dateFormat.setCalendar(new GregorianCalendar());
        dateFormat.setTimeZone(DEFAULT_BUILD_TIME_ZONE);
        this.formattedTimestamp = dateFormat.format(new Date(time.toEpochMilli()));
    }

    public String formattedTimestamp() {
        return this.formattedTimestamp;
    }
}

