/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.logging;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.function.Consumer;
import org.apache.maven.logging.ProjectBuildLogAppender;

public class LoggingOutputStream
extends FilterOutputStream {
    static final byte[] LINE_SEP = System.lineSeparator().getBytes();
    final EolBaos buf;
    final Consumer<String> consumer;

    public LoggingOutputStream(Consumer<String> consumer) {
        this(new EolBaos(), consumer);
    }

    LoggingOutputStream(EolBaos out, Consumer<String> consumer) {
        super(out);
        this.buf = out;
        this.consumer = consumer;
    }

    public PrintStream printStream() {
        return new LoggingPrintStream(this);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        if (this.buf.isEol()) {
            String line = new String(this.buf.toByteArray(), 0, this.buf.size() - LINE_SEP.length);
            ProjectBuildLogAppender.updateMdc();
            this.consumer.accept(line);
            this.buf.reset();
        }
    }

    public void forceFlush() {
        if (this.buf.size() > 0) {
            String line = new String(this.buf.toByteArray(), 0, this.buf.size());
            ProjectBuildLogAppender.updateMdc();
            this.consumer.accept(line);
            this.buf.reset();
        }
    }

    public static void forceFlush(PrintStream ps) {
        if (ps instanceof LoggingPrintStream) {
            ((LoggingPrintStream)ps).forceFlush();
        }
    }

    static class EolBaos
    extends ByteArrayOutputStream {
        EolBaos() {
        }

        boolean isEol() {
            if (this.count >= LINE_SEP.length) {
                for (int i = 0; i < LINE_SEP.length; ++i) {
                    if (this.buf[this.count - LINE_SEP.length + i] == LINE_SEP[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class LoggingPrintStream
    extends PrintStream {
        public LoggingPrintStream(LoggingOutputStream out) {
            super(out, true);
        }

        public void forceFlush() {
            ((LoggingOutputStream)this.out).forceFlush();
        }
    }
}

