/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathType;
import org.apache.maven.internal.impl.PathModularization;

class PathModularizationCache {
    private final Map<Path, PathModularization> moduleInfo = new HashMap<Path, PathModularization>();
    private final Map<Path, PathType> pathTypes = new HashMap<Path, PathType>();

    PathModularizationCache() {
    }

    PathModularization getModuleInfo(Path path) throws IOException {
        PathModularization info = this.moduleInfo.get(path);
        if (info == null) {
            info = new PathModularization(path, true);
            this.moduleInfo.put(path, info);
            this.pathTypes.put(path, (PathType)info.getPathType());
        }
        return info;
    }

    private PathType getPathType(Path path) throws IOException {
        PathType type = this.pathTypes.get(path);
        if (type == null) {
            type = new PathModularization(path, false).getPathType();
            this.pathTypes.put(path, type);
        }
        return type;
    }

    Optional<PathType> selectPathType(Set<PathType> types, Predicate<PathType> filter, Path path) throws IOException {
        Object selected = null;
        boolean classes = false;
        boolean modules = false;
        boolean unknown = false;
        boolean processorClasses = false;
        boolean processorModules = false;
        for (PathType type : types) {
            if (!filter.test(type)) continue;
            if (JavaPathType.CLASSES.equals((Object)type)) {
                classes = true;
            } else if (JavaPathType.MODULES.equals((Object)type)) {
                modules = true;
            } else if (JavaPathType.PROCESSOR_CLASSES.equals((Object)type)) {
                processorClasses = true;
            } else if (JavaPathType.PROCESSOR_MODULES.equals((Object)type)) {
                processorModules = true;
            } else {
                unknown = true;
            }
            if (selected == null) {
                selected = type;
                continue;
            }
            if (!unknown) continue;
            return Optional.empty();
        }
        if (classes | modules) {
            selected = classes & modules ? this.getPathType(path) : (classes ? JavaPathType.CLASSES : JavaPathType.MODULES);
        } else if (processorClasses & processorModules) {
            selected = this.getPathType(path);
            if (JavaPathType.CLASSES.equals(selected)) {
                selected = JavaPathType.PROCESSOR_CLASSES;
            } else if (JavaPathType.MODULES.equals(selected)) {
                selected = JavaPathType.PROCESSOR_MODULES;
            }
        }
        return Optional.ofNullable(selected);
    }

    Optional<String> warningForFilenameBasedAutomodules(Collection<Path> modulePaths) throws IOException {
        if (modulePaths == null) {
            return Optional.empty();
        }
        ArrayList<String> automodulesDetected = new ArrayList<String>();
        for (Path p : modulePaths) {
            this.getModuleInfo(p).addIfFilenameBasedAutomodules(automodulesDetected);
        }
        if (automodulesDetected.isEmpty()) {
            return Optional.empty();
        }
        String lineSeparator = System.lineSeparator();
        StringJoiner joiner = new StringJoiner(lineSeparator + "  - ", "Filename-based automodules detected on the module-path: " + lineSeparator + "  - ", lineSeparator + "Please don't publish this project to a public artifact repository.");
        automodulesDetected.forEach(joiner::add);
        return Optional.of(joiner.toString());
    }
}

