/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.ParserRequest;

public abstract class LayeredOptions<O extends Options>
implements Options {
    protected final List<O> options;

    protected LayeredOptions(List<O> options) {
        this.options = new ArrayList<O>(options);
    }

    public Optional<Map<String, String>> userProperties() {
        return this.collectMapIfPresentOrEmpty(Options::userProperties);
    }

    public String source() {
        return String.format("layered(%s)", this.options.stream().map(Options::source).toList());
    }

    public Optional<Boolean> showVersionAndExit() {
        return this.returnFirstPresentOrEmpty(Options::showVersionAndExit);
    }

    public Optional<Boolean> showVersion() {
        return this.returnFirstPresentOrEmpty(Options::showVersion);
    }

    public Optional<Boolean> quiet() {
        return this.returnFirstPresentOrEmpty(Options::quiet);
    }

    public Optional<Boolean> verbose() {
        return this.returnFirstPresentOrEmpty(Options::verbose);
    }

    public Optional<Boolean> showErrors() {
        return this.returnFirstPresentOrEmpty(Options::showErrors);
    }

    public Optional<String> failOnSeverity() {
        return this.returnFirstPresentOrEmpty(Options::failOnSeverity);
    }

    public Optional<Boolean> nonInteractive() {
        return this.returnFirstPresentOrEmpty(Options::nonInteractive);
    }

    public Optional<Boolean> forceInteractive() {
        return this.returnFirstPresentOrEmpty(Options::forceInteractive);
    }

    public Optional<String> altUserSettings() {
        return this.returnFirstPresentOrEmpty(Options::altUserSettings);
    }

    public Optional<String> altProjectSettings() {
        return this.returnFirstPresentOrEmpty(Options::altProjectSettings);
    }

    public Optional<String> altInstallationSettings() {
        return this.returnFirstPresentOrEmpty(Options::altInstallationSettings);
    }

    public Optional<String> altUserToolchains() {
        return this.returnFirstPresentOrEmpty(Options::altUserToolchains);
    }

    public Optional<String> altInstallationToolchains() {
        return this.returnFirstPresentOrEmpty(Options::altInstallationToolchains);
    }

    public Optional<String> logFile() {
        return this.returnFirstPresentOrEmpty(Options::logFile);
    }

    public Optional<Boolean> rawStreams() {
        return this.returnFirstPresentOrEmpty(Options::rawStreams);
    }

    public Optional<String> color() {
        return this.returnFirstPresentOrEmpty(Options::color);
    }

    public Optional<Boolean> help() {
        return this.returnFirstPresentOrEmpty(Options::help);
    }

    public void warnAboutDeprecatedOptions(ParserRequest request, Consumer<String> printWriter) {
    }

    public void displayHelp(ParserRequest request, Consumer<String> printWriter) {
        ((Options)this.options.get(0)).displayHelp(request, printWriter);
    }

    protected <T> Optional<T> returnFirstPresentOrEmpty(Function<O, Optional<T>> getter) {
        for (Options option : this.options) {
            Optional<T> o = getter.apply(option);
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    protected Optional<List<String>> collectListIfPresentOrEmpty(Function<O, Optional<List<String>>> getter) {
        int had = 0;
        ArrayList items = new ArrayList();
        for (Options option : this.options) {
            Optional<List<String>> o = getter.apply(option);
            if (!o.isPresent()) continue;
            ++had;
            items.addAll(o.get());
        }
        return had == 0 ? Optional.empty() : Optional.of(List.copyOf(items));
    }

    protected Optional<Map<String, String>> collectMapIfPresentOrEmpty(Function<O, Optional<Map<String, String>>> getter) {
        int had = 0;
        HashMap<String, String> items = new HashMap<String, String>();
        for (Options option : this.options) {
            Optional<Map<String, String>> up = getter.apply(option);
            if (!up.isPresent()) continue;
            ++had;
            items.putAll(up.get());
        }
        return had == 0 ? Optional.empty() : Optional.of(Map.copyOf(items));
    }
}

