/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.concurrent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.internal.MultilineMessageHelper;
import org.apache.maven.internal.impl.DefaultLifecycleRegistry;
import org.apache.maven.internal.impl.util.PhasingExecutor;
import org.apache.maven.internal.transformation.ConsumerPomArtifactTransformer;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.apache.maven.lifecycle.internal.BuildThreadFactory;
import org.apache.maven.lifecycle.internal.CompoundProjectExecutionListener;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.GoalTask;
import org.apache.maven.lifecycle.internal.LifecycleTask;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.Task;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.concurrent.BuildPlan;
import org.apache.maven.lifecycle.internal.concurrent.BuildPlanLogger;
import org.apache.maven.lifecycle.internal.concurrent.BuildStep;
import org.apache.maven.lifecycle.internal.concurrent.PluginLifecycle;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BuildPlanExecutor {
    private static final Object GLOBAL = new Object();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MojoExecutor mojoExecutor;
    private final ExecutionEventCatapult eventCatapult;
    private final ProjectExecutionListener projectExecutionListener;
    private final ConsumerPomArtifactTransformer consumerPomArtifactTransformer;
    private final BuildPlanLogger buildPlanLogger;
    private final Map<String, MojoExecutionConfigurator> mojoExecutionConfigurators;
    private final MavenPluginManager mavenPluginManager;
    private final MojoDescriptorCreator mojoDescriptorCreator;
    private final LifecycleRegistry lifecycles;

    @Inject
    public BuildPlanExecutor(@Named(value="concurrent") MojoExecutor mojoExecutor, ExecutionEventCatapult eventCatapult, List<ProjectExecutionListener> listeners, ConsumerPomArtifactTransformer consumerPomArtifactTransformer, BuildPlanLogger buildPlanLogger, Map<String, MojoExecutionConfigurator> mojoExecutionConfigurators, MavenPluginManager mavenPluginManager, MojoDescriptorCreator mojoDescriptorCreator, LifecycleRegistry lifecycles) {
        this.mojoExecutor = mojoExecutor;
        this.eventCatapult = eventCatapult;
        this.projectExecutionListener = new CompoundProjectExecutionListener(listeners);
        this.consumerPomArtifactTransformer = consumerPomArtifactTransformer;
        this.buildPlanLogger = buildPlanLogger;
        this.mojoExecutionConfigurators = mojoExecutionConfigurators;
        this.mavenPluginManager = mavenPluginManager;
        this.mojoDescriptorCreator = mojoDescriptorCreator;
        this.lifecycles = lifecycles;
    }

    public void execute(MavenSession session, ReactorContext reactorContext, List<TaskSegment> taskSegments) throws ExecutionException, InterruptedException {
        try (BuildContext ctx = new BuildContext(session, reactorContext, taskSegments);){
            ctx.execute();
        }
    }

    private void resolvePlugin(MavenSession session, List<RemoteRepository> repositories, Plugin plugin) {
        try {
            this.mavenPluginManager.getPluginDescriptor(plugin, repositories, session.getRepositorySession());
        }
        catch (Exception e) {
            throw new MavenException((Throwable)e);
        }
    }

    private static String gav(MavenProject p) {
        return p.getGroupId() + ":" + p.getArtifactId() + ":" + p.getVersion();
    }

    private static String gav(Plugin p) {
        return p.getGroupId() + ":" + p.getArtifactId() + ":" + p.getVersion();
    }

    private void finalizeMojoConfiguration(MojoExecution mojoExecution) {
        XmlNode executionConfiguration;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        XmlNode xmlNode = executionConfiguration = mojoExecution.getConfiguration() != null ? mojoExecution.getConfiguration().getDom() : null;
        if (executionConfiguration == null) {
            executionConfiguration = new XmlNodeImpl("configuration");
        }
        XmlNode defaultConfiguration = this.getMojoConfiguration(mojoDescriptor);
        ArrayList<XmlNode> children = new ArrayList<XmlNode>();
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                XmlNode parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                XmlNode parameterDefaults = defaultConfiguration.getChild(parameter.getName());
                if ((parameterConfiguration = parameterConfiguration != null ? parameterConfiguration.merge(parameterDefaults, Boolean.TRUE) : parameterDefaults) == null) continue;
                HashMap<String, String> attributes = new HashMap<String, String>(parameterConfiguration.getAttributes());
                String attributeForImplementation = parameterConfiguration.getAttribute("implementation");
                String parameterForImplementation = parameter.getImplementation();
                if ((attributeForImplementation == null || attributeForImplementation.isEmpty()) && parameterForImplementation != null && !parameterForImplementation.isEmpty()) {
                    attributes.put("implementation", parameter.getImplementation());
                }
                parameterConfiguration = new XmlNodeImpl(parameter.getName(), parameterConfiguration.getValue(), attributes, parameterConfiguration.getChildren(), parameterConfiguration.getInputLocation());
                children.add(parameterConfiguration);
            }
        }
        XmlNodeImpl finalConfiguration = new XmlNodeImpl("configuration", null, null, children, null);
        mojoExecution.setConfiguration((XmlNode)finalConfiguration);
    }

    private XmlNode getMojoConfiguration(MojoDescriptor mojoDescriptor) {
        if (mojoDescriptor.isV4Api()) {
            return MojoDescriptorCreator.convert(mojoDescriptor.getMojoDescriptorV4());
        }
        return MojoDescriptorCreator.convert(mojoDescriptor).getDom();
    }

    private MojoExecutionConfigurator mojoExecutionConfigurator(MojoExecution mojoExecution) {
        MojoExecutionConfigurator mojoExecutionConfigurator;
        String configuratorId = mojoExecution.getMojoDescriptor().getComponentConfigurator();
        if (configuratorId == null) {
            configuratorId = "default";
        }
        if ((mojoExecutionConfigurator = this.mojoExecutionConfigurators.get(configuratorId)) == null) {
            mojoExecutionConfigurator = this.mojoExecutionConfigurators.get("default");
        }
        return mojoExecutionConfigurator;
    }

    public static void attachToThread(MavenProject currentProject) {
        ClassRealm projectRealm = currentProject.getClassRealm();
        if (projectRealm != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
        }
    }

    class BuildContext
    implements AutoCloseable {
        final MavenSession session;
        final ReactorContext reactorContext;
        final PhasingExecutor executor;
        final Map<Object, Clock> clocks = new ConcurrentHashMap<Object, Clock>();
        final ReadWriteLock lock = new ReentrantReadWriteLock();
        final int threads;
        BuildPlan plan;

        BuildContext(MavenSession session, ReactorContext reactorContext, List<TaskSegment> taskSegments) {
            this.session = session;
            this.reactorContext = reactorContext;
            this.threads = Math.min(session.getRequest().getDegreeOfConcurrency(), session.getProjects().size());
            session.setParallel(this.threads > 1);
            this.executor = new PhasingExecutor(Executors.newFixedThreadPool(this.threads, new BuildThreadFactory()));
            this.plan = this.buildInitialPlan(taskSegments);
        }

        BuildContext() {
            this.session = null;
            this.reactorContext = null;
            this.threads = 1;
            this.executor = null;
            this.plan = null;
        }

        public BuildPlan buildInitialPlan(List<TaskSegment> taskSegments) {
            int nThreads = Math.min(this.session.getRequest().getDegreeOfConcurrency(), this.session.getProjects().size());
            boolean parallel = nThreads > 1;
            this.session.setParallel(parallel);
            ProjectDependencyGraph dependencyGraph = this.session.getProjectDependencyGraph();
            MavenProject rootProject = this.session.getTopLevelProject();
            LinkedHashMap<MavenProject, List<MavenProject>> allProjects = new LinkedHashMap<MavenProject, List<MavenProject>>();
            dependencyGraph.getSortedProjects().forEach(p -> allProjects.put((MavenProject)p, dependencyGraph.getUpstreamProjects((MavenProject)p, false)));
            BuildPlan plan = new BuildPlan(allProjects);
            for (TaskSegment taskSegment : taskSegments) {
                LinkedHashMap<MavenProject, List<MavenProject>> projects = taskSegment.isAggregating() ? Collections.singletonMap(rootProject, (List)allProjects.get(rootProject)) : allProjects;
                BuildPlan segment = this.calculateMojoExecutions(projects, taskSegment.getTasks());
                plan.then(segment);
            }
            for (MavenProject project : plan.getAllProjects().keySet()) {
                BuildStep pplan = new BuildStep("$plan$", project, null);
                pplan.status.set(1);
                BuildStep setup = new BuildStep("$setup$", project, null);
                BuildStep teardown = new BuildStep("$teardown$", project, null);
                setup.executeAfter(pplan);
                plan.steps(project).forEach(step -> {
                    if (step.predecessors.isEmpty()) {
                        step.executeAfter(setup);
                    } else if (step.successors.isEmpty()) {
                        teardown.executeAfter((BuildStep)step);
                    }
                });
                Stream.of(pplan, setup, teardown).forEach(step -> plan.addStep(project, step.name, (BuildStep)step));
            }
            return plan;
        }

        private void checkUnboundVersions(BuildPlan buildPlan) {
            String defaulModelId = DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_MODELID;
            List<String> unversionedPlugins = buildPlan.allSteps().flatMap(step -> step.mojos.values().stream().flatMap(map -> map.values().stream())).map(MojoExecution::getPlugin).filter(p -> p.getLocation((Object)"version") != null && p.getLocation((Object)"version").getSource() != null && defaulModelId.equals(p.getLocation((Object)"version").getSource().getModelId())).distinct().map(Plugin::getArtifactId).toList();
            if (!unversionedPlugins.isEmpty()) {
                BuildPlanExecutor.this.logger.warn("Version not locked for default bindings plugins " + String.valueOf(unversionedPlugins) + ", you should define versions in pluginManagement section of your pom.xml or parent");
            }
        }

        private void checkThreadSafety(BuildPlan buildPlan) {
            Set unsafeExecutions;
            if (this.threads > 1 && !(unsafeExecutions = buildPlan.allSteps().flatMap(step -> step.mojos.values().stream().flatMap(map -> map.values().stream())).filter(execution -> !execution.getMojoDescriptor().isV4Api()).collect(Collectors.toSet())).isEmpty()) {
                for (String s : MultilineMessageHelper.format("Your build is requesting concurrent execution, but this project contains the following plugin(s) that have goals not built with Maven 4 to support concurrent execution. While this /may/ work fine, please look for plugin updates and/or request plugins be made thread-safe. If reporting an issue, report it against the plugin in question, not against Apache Maven.")) {
                    BuildPlanExecutor.this.logger.warn(s);
                }
                if (BuildPlanExecutor.this.logger.isDebugEnabled()) {
                    Set unsafeGoals = unsafeExecutions.stream().map(MojoExecution::getMojoDescriptor).collect(Collectors.toSet());
                    BuildPlanExecutor.this.logger.warn("The following goals are not Maven 4 goals:");
                    for (MojoDescriptor unsafeGoal : unsafeGoals) {
                        BuildPlanExecutor.this.logger.warn("  " + unsafeGoal.getId());
                    }
                } else {
                    Set unsafePlugins = unsafeExecutions.stream().map(MojoExecution::getPlugin).collect(Collectors.toSet());
                    BuildPlanExecutor.this.logger.warn("The following plugins are not Maven 4 plugins:");
                    for (Plugin unsafePlugin : unsafePlugins) {
                        BuildPlanExecutor.this.logger.warn("  " + unsafePlugin.getId());
                    }
                    BuildPlanExecutor.this.logger.warn("");
                    BuildPlanExecutor.this.logger.warn("Enable verbose output (-X) to see precisely which goals are not marked as thread-safe.");
                }
                BuildPlanExecutor.this.logger.warn(MultilineMessageHelper.separatorLine());
            }
        }

        void execute() {
            try (AutoCloseable phase = this.executor.phase();){
                this.plan();
                this.executePlan();
            }
            catch (Exception e) {
                this.session.getResult().addException(e);
            }
        }

        @Override
        public void close() {
            this.executor.close();
        }

        private void executePlan() {
            if (this.reactorContext.getReactorBuildStatus().isHalted()) {
                return;
            }
            Clock global = this.clocks.computeIfAbsent(GLOBAL, p -> new Clock());
            global.start();
            this.lock.readLock().lock();
            try {
                this.plan.sortedNodes().stream().filter(step -> step.status.get() == 0).filter(step -> step.predecessors.stream().allMatch(s -> s.status.get() == 3)).filter(step -> step.status.compareAndSet(0, 2)).forEach(step -> {
                    boolean nextIsPlanning = step.successors.stream().anyMatch(st -> "$plan$".equals(st.name));
                    this.executor.execute(() -> {
                        try {
                            this.executeStep((BuildStep)step);
                            if (nextIsPlanning) {
                                this.lock.writeLock().lock();
                                try {
                                    this.plan();
                                }
                                finally {
                                    this.lock.writeLock().unlock();
                                }
                            }
                            this.executePlan();
                        }
                        catch (Exception e) {
                            step.status.compareAndSet(2, 4);
                            global.stop();
                            this.handleBuildError(this.reactorContext, this.session, step.project, e, global);
                        }
                    });
                });
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void executeStep(BuildStep step) throws IOException, LifecycleExecutionException {
            Clock clock = this.getClock(step.project);
            switch (step.name) {
                case "$plan$": {
                    throw new IllegalStateException();
                }
                case "$setup$": {
                    BuildPlanExecutor.this.consumerPomArtifactTransformer.injectTransformedArtifacts(this.session.getRepositorySession(), step.project);
                    BuildPlanExecutor.this.projectExecutionListener.beforeProjectExecution(new ProjectExecutionEvent(this.session, step.project));
                    BuildPlanExecutor.this.eventCatapult.fire(ExecutionEvent.Type.ProjectStarted, this.session, null);
                    break;
                }
                case "$teardown$": {
                    BuildPlanExecutor.this.projectExecutionListener.afterProjectExecutionSuccess(new ProjectExecutionEvent(this.session, step.project, Collections.emptyList()));
                    this.reactorContext.getResult().addBuildSummary(new BuildSuccess(step.project, clock.wallTime(), clock.execTime()));
                    BuildPlanExecutor.this.eventCatapult.fire(ExecutionEvent.Type.ProjectSucceeded, this.session, null);
                    break;
                }
                default: {
                    List<MojoExecution> executions = step.executions().collect(Collectors.toList());
                    if (executions.isEmpty()) break;
                    BuildPlanExecutor.attachToThread(step.project);
                    this.session.setCurrentProject(step.project);
                    clock.start();
                    executions.forEach(mojoExecution -> {
                        BuildPlanExecutor.this.mojoExecutionConfigurator((MojoExecution)mojoExecution).configure(step.project, (MojoExecution)mojoExecution, true);
                        BuildPlanExecutor.this.finalizeMojoConfiguration((MojoExecution)mojoExecution);
                    });
                    BuildPlanExecutor.this.mojoExecutor.execute(this.session, executions);
                    clock.stop();
                }
            }
            step.status.compareAndSet(2, 3);
        }

        private Clock getClock(Object key) {
            return this.clocks.computeIfAbsent(key, p -> new Clock());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void plan() {
            this.lock.writeLock().lock();
            try {
                Set planSteps = this.plan.allSteps().filter(st -> "$plan$".equals(st.name)).filter(step -> step.predecessors.stream().allMatch(s -> s.status.get() == 3)).filter(step -> step.status.compareAndSet(1, 2)).collect(Collectors.toSet());
                for (BuildStep step2 : planSteps) {
                    MavenProject project = step2.project;
                    for (Plugin plugin : project.getBuild().getPlugins()) {
                        for (PluginExecution execution : plugin.getExecutions()) {
                            for (String goal : execution.getGoals()) {
                                MojoDescriptor mojoDescriptor = this.getMojoDescriptor(project, plugin, goal);
                                String phase = execution.getPhase() != null ? execution.getPhase() : mojoDescriptor.getPhase();
                                String tmpResolvedPhase = this.plan.aliases().getOrDefault(phase, phase);
                                String resolvedPhase = tmpResolvedPhase.startsWith("at:") ? tmpResolvedPhase.substring("at:".length()) : tmpResolvedPhase;
                                this.plan.step(project, resolvedPhase).ifPresent(n -> {
                                    MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, execution.getId());
                                    mojoExecution.setLifecyclePhase(phase);
                                    n.addMojo(mojoExecution, execution.getPriority());
                                    if (mojoDescriptor.getDependencyCollectionRequired() != null || mojoDescriptor.getDependencyResolutionRequired() != null) {
                                        for (MavenProject p : this.plan.getAllProjects().get(project)) {
                                            this.plan.step(p, "after:package").ifPresent(a -> this.plan.requiredStep(project, resolvedPhase).executeAfter((BuildStep)a));
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
                BuildPlan buildPlan = this.plan;
                for (BuildStep step3 : planSteps.stream().flatMap(p -> this.plan.steps(p.project)).toList()) {
                    for (MojoExecution execution : step3.executions().toList()) {
                        buildPlan = this.computeForkPlan(step3, execution, buildPlan);
                    }
                }
                for (BuildStep step3 : planSteps) {
                    MavenProject project = step3.project;
                    BuildPlanExecutor.this.buildPlanLogger.writePlan(this.plan, project);
                    step3.status.compareAndSet(2, 3);
                }
                this.checkThreadSafety(this.plan);
                this.checkUnboundVersions(this.plan);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected BuildPlan computeForkPlan(BuildStep step, MojoExecution execution, BuildPlan buildPlan) {
            Lifecycle lifecycle;
            MojoDescriptor mojoDescriptor = execution.getMojoDescriptor();
            PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
            String forkedGoal = mojoDescriptor.getExecuteGoal();
            String phase = mojoDescriptor.getExecutePhase();
            if (forkedGoal != null && !forkedGoal.isEmpty()) {
                MojoDescriptor forkedMojoDescriptor = pluginDescriptor.getMojo(forkedGoal);
                if (forkedMojoDescriptor == null) {
                    throw new MavenException((Throwable)new MojoNotFoundException(forkedGoal, pluginDescriptor));
                }
                ArrayList<MavenProject> toFork = new ArrayList<MavenProject>();
                toFork.add(step.project);
                if (mojoDescriptor.isAggregator() && step.project.getCollectedProjects() != null) {
                    toFork.addAll(step.project.getCollectedProjects());
                }
                BuildPlan plan = new BuildPlan();
                for (MavenProject project : toFork) {
                    BuildStep st = new BuildStep(forkedGoal, project, null);
                    MojoExecution mojoExecution = new MojoExecution(forkedMojoDescriptor, forkedGoal);
                    st.addMojo(mojoExecution, 0);
                    HashMap<String, BuildStep> n = new HashMap<String, BuildStep>();
                    n.put(forkedGoal, st);
                    plan.addProject(project, n);
                }
                for (BuildStep astep : plan.allSteps().toList()) {
                    for (MojoExecution aexecution : astep.executions().toList()) {
                        plan = this.computeForkPlan(astep, aexecution, plan);
                    }
                }
                return plan;
            }
            if (phase == null || phase.isEmpty()) return buildPlan;
            String forkedLifecycle = mojoDescriptor.getExecuteLifecycle();
            if (forkedLifecycle != null && !forkedLifecycle.isEmpty()) {
                org.apache.maven.api.plugin.descriptor.lifecycle.Lifecycle lifecycleOverlay;
                try {
                    lifecycleOverlay = pluginDescriptor.getLifecycleMapping(forkedLifecycle);
                }
                catch (IOException | XMLStreamException e) {
                    throw new MavenException((Throwable)new PluginDescriptorParsingException(pluginDescriptor.getPlugin(), pluginDescriptor.getSource(), e));
                }
                if (lifecycleOverlay == null) {
                    Optional lf = BuildPlanExecutor.this.lifecycles.lookup(forkedLifecycle);
                    if (!lf.isPresent()) throw new MavenException((Throwable)new LifecycleNotFoundException(forkedLifecycle));
                    lifecycle = (Lifecycle)lf.get();
                } else {
                    lifecycle = new PluginLifecycle(lifecycleOverlay, pluginDescriptor);
                }
            } else if (execution.getLifecyclePhase() != null) {
                String n = execution.getLifecyclePhase();
                String phaseName = n.startsWith("before:") ? n.substring("before:".length()) : (n.startsWith("after:") ? n.substring("after:".length()) : n);
                lifecycle = BuildPlanExecutor.this.lifecycles.stream().filter(l -> l.allPhases().anyMatch(p -> phaseName.equals(p.name()))).findFirst().orElse(null);
                if (lifecycle == null) {
                    throw new IllegalStateException();
                }
            } else {
                lifecycle = (Lifecycle)BuildPlanExecutor.this.lifecycles.require("default");
            }
            String resolvedPhase = this.getResolvedPhase(lifecycle, phase);
            Map<MavenProject, List<MavenProject>> map = Collections.singletonMap(step.project, this.plan.getAllProjects().get(step.project));
            BuildPlan forkedPlan = this.calculateLifecycleMappings(map, lifecycle, resolvedPhase);
            forkedPlan.then(buildPlan);
            return forkedPlan;
        }

        private String getResolvedPhase(Lifecycle lifecycle, String phase) {
            return lifecycle.aliases().stream().filter(a -> phase.equals(a.v3Phase())).findFirst().map(Lifecycle.Alias::v4Phase).orElse(phase);
        }

        private String getResolvedPhase(String phase) {
            return BuildPlanExecutor.this.lifecycles.stream().flatMap(l -> l.aliases().stream()).filter(a -> phase.equals(a.v3Phase())).findFirst().map(Lifecycle.Alias::v4Phase).orElse(phase);
        }

        protected void handleBuildError(ReactorContext buildContext, MavenSession session, MavenProject mavenProject, Throwable t, Clock clock) {
            buildContext.getResult().addException(t);
            buildContext.getResult().addBuildSummary(new BuildFailure(mavenProject, clock.execTime(), clock.wallTime(), t));
            if (t instanceof Exception && !(t instanceof RuntimeException)) {
                BuildPlanExecutor.this.eventCatapult.fire(ExecutionEvent.Type.ProjectFailed, session, null, (Exception)t);
            }
            if (t instanceof RuntimeException || !(t instanceof Exception)) {
                buildContext.getReactorBuildStatus().halt();
            } else if (!"FAIL_NEVER".equals(session.getReactorFailureBehavior())) {
                if ("FAIL_AT_END".equals(session.getReactorFailureBehavior())) {
                    buildContext.getReactorBuildStatus().blackList(mavenProject);
                } else if ("FAIL_FAST".equals(session.getReactorFailureBehavior())) {
                    buildContext.getReactorBuildStatus().halt();
                } else {
                    BuildPlanExecutor.this.logger.error("invalid reactor failure behavior " + session.getReactorFailureBehavior());
                    buildContext.getReactorBuildStatus().halt();
                }
            }
        }

        public BuildPlan calculateMojoExecutions(Map<MavenProject, List<MavenProject>> projects, List<Task> tasks) {
            BuildPlan buildPlan = new BuildPlan(projects);
            for (Task task : tasks) {
                BuildPlan step;
                if (task instanceof GoalTask) {
                    String pluginGoal = task.getValue();
                    String executionId = "default-cli";
                    int executionIdx = pluginGoal.indexOf(64);
                    if (executionIdx > 0) {
                        executionId = pluginGoal.substring(executionIdx + 1);
                    }
                    step = new BuildPlan();
                    for (MavenProject project : projects.keySet()) {
                        BuildStep st = new BuildStep(pluginGoal, project, null);
                        MojoDescriptor mojoDescriptor = this.getMojoDescriptor(project, pluginGoal);
                        MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, executionId, MojoExecution.Source.CLI);
                        st.addMojo(mojoExecution, 0);
                        HashMap<String, BuildStep> n = new HashMap<String, BuildStep>();
                        n.put(pluginGoal, st);
                        step.addProject(project, n);
                    }
                } else if (task instanceof LifecycleTask) {
                    String lifecyclePhase = task.getValue();
                    step = this.calculateLifecycleMappings(projects, lifecyclePhase);
                } else {
                    throw new IllegalStateException("unexpected task " + String.valueOf(task));
                }
                buildPlan.then(step);
            }
            return buildPlan;
        }

        private MojoDescriptor getMojoDescriptor(MavenProject project, Plugin plugin, String goal) {
            try {
                return BuildPlanExecutor.this.mavenPluginManager.getMojoDescriptor(plugin, goal, project.getRemotePluginRepositories(), this.session.getRepositorySession());
            }
            catch (MavenException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MavenException((Throwable)e);
            }
        }

        private MojoDescriptor getMojoDescriptor(MavenProject project, String task) {
            try {
                return BuildPlanExecutor.this.mojoDescriptorCreator.getMojoDescriptor(task, this.session, project);
            }
            catch (MavenException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MavenException((Throwable)e);
            }
        }

        public BuildPlan calculateLifecycleMappings(Map<MavenProject, List<MavenProject>> projects, String lifecyclePhase) {
            String resolvedPhase = this.getResolvedPhase(lifecyclePhase);
            String mainPhase = resolvedPhase.startsWith("before:") ? resolvedPhase.substring("before:".length()) : (resolvedPhase.startsWith("after:") ? resolvedPhase.substring("after:".length()) : (resolvedPhase.startsWith("at:") ? resolvedPhase.substring("at:".length()) : resolvedPhase));
            Lifecycle lifecycle = BuildPlanExecutor.this.lifecycles.stream().filter(l -> l.allPhases().anyMatch(p -> mainPhase.equals(p.name()))).findFirst().orElse(null);
            if (lifecycle == null) {
                throw new MavenException((Throwable)new LifecyclePhaseNotFoundException("Unknown lifecycle phase \"" + lifecyclePhase + "\". You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + BuildPlanExecutor.this.lifecycles.stream().flatMap(l -> l.orderedPhases().map(Collection::stream).orElseGet(() -> l.allPhases().map(Lifecycle.Phase::name))).collect(Collectors.joining(", ")) + ".", lifecyclePhase));
            }
            return this.calculateLifecycleMappings(projects, lifecycle, resolvedPhase);
        }

        public BuildPlan calculateLifecycleMappings(Map<MavenProject, List<MavenProject>> projects, Lifecycle lifecycle, String lifecyclePhase) {
            BuildPlan plan = new BuildPlan(projects);
            for (MavenProject project2 : projects.keySet()) {
                Map<String, BuildStep> steps = lifecycle.allPhases().flatMap(phase -> {
                    BuildStep a = new BuildStep("before:" + phase.name(), project2, (Lifecycle.Phase)phase);
                    BuildStep b = new BuildStep(phase.name(), project2, (Lifecycle.Phase)phase);
                    BuildStep c = new BuildStep("after:" + phase.name(), project2, (Lifecycle.Phase)phase);
                    b.executeAfter(a);
                    c.executeAfter(b);
                    return Stream.of(a, b, c);
                }).collect(Collectors.toMap(n -> n.name, n -> n));
                lifecycle.allPhases().forEach(phase -> phase.phases().forEach(child -> {
                    ((BuildStep)steps.get("before:" + child.name())).executeAfter((BuildStep)steps.get("before:" + phase.name()));
                    ((BuildStep)steps.get("after:" + phase.name())).executeAfter((BuildStep)steps.get("after:" + child.name()));
                }));
                lifecycle.allPhases().forEach(phase -> phase.links().stream().filter(l -> l.pointer().type() == Lifecycle.Pointer.Type.PROJECT).forEach(link -> {
                    String n1 = phase.name();
                    String n2 = link.pointer().phase();
                    if (link.kind() == Lifecycle.Link.Kind.AFTER) {
                        ((BuildStep)steps.get("before:" + n1)).executeAfter((BuildStep)steps.get("after:" + n2));
                    } else {
                        ((BuildStep)steps.get("before:" + n2)).executeAfter((BuildStep)steps.get("after:" + n1));
                    }
                }));
                String endPhase = lifecyclePhase.startsWith("before:") || lifecyclePhase.startsWith("after:") ? lifecyclePhase : (lifecyclePhase.startsWith("at:") ? lifecyclePhase.substring("at:".length()) : "after:" + lifecyclePhase);
                Set toKeep = steps.get(endPhase).allPredecessors().collect(Collectors.toSet());
                steps.values().stream().filter(n -> !toKeep.contains(n)).forEach(BuildStep::skip);
                plan.addProject(project2, steps);
            }
            plan.allSteps().filter(step -> step.phase != null).forEach(step -> {
                Lifecycle.Phase phase = step.phase;
                MavenProject project = step.project;
                phase.links().stream().filter(l -> l.pointer().type() != Lifecycle.Pointer.Type.PROJECT).forEach(link -> {
                    String n1 = phase.name();
                    String n2 = link.pointer().phase();
                    this.getLinkedProjects(projects, project, (Lifecycle.Link)link).forEach(p -> plan.step((MavenProject)p, "after:" + n2).ifPresent(a -> plan.requiredStep(project, "before:" + n1).executeAfter((BuildStep)a)));
                });
            });
            Map<String, MavenProject> reactorGavs = projects.keySet().stream().collect(Collectors.toMap(BuildPlanExecutor::gav, p -> p));
            ArrayList toResolve = new ArrayList();
            projects.keySet().forEach(project -> project.getBuild().getPlugins().forEach(plugin -> {
                MavenProject pluginProject = (MavenProject)reactorGavs.get(BuildPlanExecutor.gav(plugin));
                if (pluginProject != null) {
                    plan.requiredStep((MavenProject)project, "$plan$").executeAfter(plan.requiredStep(pluginProject, "ready"));
                } else {
                    toResolve.add(() -> BuildPlanExecutor.this.resolvePlugin(this.session, project.getRemotePluginRepositories(), (Plugin)plugin));
                }
            }));
            toResolve.parallelStream().forEach(Runnable::run);
            lifecycle.aliases().forEach(alias -> plan.aliases().put(alias.v3Phase(), alias.v4Phase()));
            return plan;
        }

        private List<MavenProject> getLinkedProjects(Map<MavenProject, List<MavenProject>> projects, MavenProject project, Lifecycle.Link link) {
            if (link.pointer().type() == Lifecycle.Pointer.Type.DEPENDENCIES) {
                return projects.get(project);
            }
            if (link.pointer().type() == Lifecycle.Pointer.Type.CHILDREN) {
                return project.getCollectedProjects();
            }
            throw new IllegalArgumentException("Unsupported pointer type: " + String.valueOf(link.pointer().type()));
        }
    }

    protected static class Clock {
        long start;
        long end;
        long resumed;
        long exec;

        protected Clock() {
        }

        protected void start() {
            this.resumed = this.start == 0L ? (this.start = System.nanoTime()) : System.nanoTime();
        }

        protected void stop() {
            this.end = System.nanoTime();
            this.exec += this.end - this.resumed;
        }

        protected long wallTime() {
            return TimeUnit.NANOSECONDS.toMillis(this.end - this.start);
        }

        protected long execTime() {
            return TimeUnit.NANOSECONDS.toMillis(this.exec);
        }
    }
}

