/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Qualifier;
import org.apache.maven.api.di.Scope;
import org.apache.maven.di.Key;
import org.apache.maven.di.impl.Binding;
import org.apache.maven.di.impl.BindingInitializer;
import org.apache.maven.di.impl.DIException;
import org.apache.maven.di.impl.Dependency;
import org.apache.maven.di.impl.Types;
import org.apache.maven.di.impl.Utils;

public final class ReflectionUtils {
    private static final String IDENT = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern PACKAGE = Pattern.compile("(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*");
    private static final Pattern PACKAGE_AND_PARENT = Pattern.compile(PACKAGE.pattern() + "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\$\\d*)?");
    private static final Pattern ARRAY_SIGNATURE = Pattern.compile("\\[L(.*?);");

    public static String getDisplayName(Type type) {
        Object typeName;
        Class<?> raw = Types.getRawType(type);
        if (raw.isAnonymousClass()) {
            Type superclass = raw.getGenericSuperclass();
            typeName = "? extends " + superclass.getTypeName();
        } else {
            typeName = type.getTypeName();
        }
        return PACKAGE_AND_PARENT.matcher(ARRAY_SIGNATURE.matcher((CharSequence)typeName).replaceAll("$1[]")).replaceAll("");
    }

    @Nullable
    public static Object getOuterClassInstance(Object innerClassInstance) {
        if (innerClassInstance == null) {
            return null;
        }
        Class<?> cls = innerClassInstance.getClass();
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isSynthetic() || !field.getName().startsWith("this$") || field.getType() != enclosingClass) continue;
            field.setAccessible(true);
            try {
                return field.get(innerClassInstance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    public static Object qualifierOf(AnnotatedElement annotatedElement) {
        Object qualifier = null;
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            Class<? extends Annotation> annotationType;
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            if (qualifier != null) {
                throw new DIException("More than one qualifier annotation on " + String.valueOf(annotatedElement));
            }
            qualifier = annotation instanceof Named ? ((Named)annotation).value() : (Utils.isMarker(annotationType = annotation.annotationType()) ? annotationType : annotation);
        }
        return qualifier;
    }

    @Nullable
    public static Annotation scopeOf(AnnotatedElement annotatedElement) {
        Annotation scope = null;
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Scope.class)) continue;
            if (scope != null) {
                throw new DIException("More than one scope annotation on " + String.valueOf(annotatedElement));
            }
            scope = annotation;
        }
        return scope;
    }

    public static <T> Key<T> keyOf(@Nullable Type container, Type type, AnnotatedElement annotatedElement) {
        return Key.ofType(container != null ? Types.bind(type, Types.getAllTypeBindings(container)) : type, ReflectionUtils.qualifierOf(annotatedElement));
    }

    public static <T extends AnnotatedElement & Member> List<T> getAnnotatedElements(Class<?> cls, Class<? extends Annotation> annotationType, Function<Class<?>, T[]> extractor, boolean allowStatic) {
        ArrayList<AnnotatedElement> result = new ArrayList<AnnotatedElement>();
        while (cls != null) {
            for (AnnotatedElement element : (AnnotatedElement[])extractor.apply(cls)) {
                if (!element.isAnnotationPresent(annotationType)) continue;
                if (!allowStatic && Modifier.isStatic(((Member)((Object)element)).getModifiers())) {
                    throw new DIException("@" + annotationType.getSimpleName() + " annotation is not allowed on " + String.valueOf(element));
                }
                result.add(element);
            }
            cls = cls.getSuperclass();
        }
        return result;
    }

    @Nullable
    public static <T> Binding<T> generateImplicitBinding(Key<T> key) {
        Binding<T> binding = ReflectionUtils.generateConstructorBinding(key);
        if (binding != null) {
            Annotation scope = ReflectionUtils.scopeOf(key.getRawType());
            if (scope != null) {
                binding = binding.scope(scope);
            }
            binding = binding.initializeWith(ReflectionUtils.generateInjectingInitializer(key));
        }
        return binding;
    }

    @Nullable
    public static <T> Binding<T> generateConstructorBinding(Key<T> key) {
        Class cls = key.getRawType();
        List<Constructor<?>> constructors = Arrays.asList(cls.getDeclaredConstructors());
        List<Constructor> injectConstructors = constructors.stream().filter(c -> c.isAnnotationPresent(Inject.class)).toList();
        List<Method> factoryMethods = Arrays.stream(cls.getDeclaredMethods()).filter(method -> method.getReturnType() == cls && Modifier.isStatic(method.getModifiers())).toList();
        List<Method> injectFactoryMethods = factoryMethods.stream().filter(method -> method.isAnnotationPresent(Inject.class)).toList();
        if (!injectConstructors.isEmpty()) {
            if (injectConstructors.size() > 1) {
                throw ReflectionUtils.failedImplicitBinding(key, "more than one inject constructor");
            }
            if (!injectFactoryMethods.isEmpty()) {
                throw ReflectionUtils.failedImplicitBinding(key, "both inject constructor and inject factory method are present");
            }
            return ReflectionUtils.bindingFromConstructor(key, injectConstructors.iterator().next());
        }
        if (!injectFactoryMethods.isEmpty()) {
            if (injectFactoryMethods.size() > 1) {
                throw ReflectionUtils.failedImplicitBinding(key, "more than one inject factory method");
            }
            return ReflectionUtils.bindingFromMethod(injectFactoryMethods.iterator().next());
        }
        if (constructors.isEmpty()) {
            throw ReflectionUtils.failedImplicitBinding(key, "inject annotation on interface");
        }
        if (constructors.size() > 1) {
            throw ReflectionUtils.failedImplicitBinding(key, "inject annotation on class with multiple constructors");
        }
        Constructor<?> declaredConstructor = constructors.iterator().next();
        Class<?> enclosingClass = cls.getEnclosingClass();
        if (enclosingClass != null && !Modifier.isStatic(cls.getModifiers()) && declaredConstructor.getParameterCount() != 1) {
            throw ReflectionUtils.failedImplicitBinding(key, "inject annotation on local class that closes over outside variables and/or has no default constructor");
        }
        return ReflectionUtils.bindingFromConstructor(key, declaredConstructor);
    }

    private static DIException failedImplicitBinding(Key<?> requestedKey, String message) {
        return new DIException("Failed to generate implicit binding for " + requestedKey.getDisplayString() + ", " + message);
    }

    public static <T> BindingInitializer<T> generateInjectingInitializer(Key<T> container) {
        Class<T> rawType = container.getRawType();
        List initializers = Stream.concat(ReflectionUtils.getAnnotatedElements(rawType, Inject.class, Class::getDeclaredFields, false).stream().map(field -> ReflectionUtils.fieldInjector(container, field)), ReflectionUtils.getAnnotatedElements(rawType, Inject.class, Class::getDeclaredMethods, true).stream().filter(method -> !Modifier.isStatic(method.getModifiers())).map(method -> ReflectionUtils.methodInjector(container, method))).collect(Collectors.toList());
        return BindingInitializer.combine(initializers);
    }

    public static <T> BindingInitializer<T> fieldInjector(Key<T> container, final Field field) {
        field.setAccessible(true);
        Key<T> key = ReflectionUtils.keyOf(container.getType(), field.getGenericType(), field);
        boolean optional = field.isAnnotationPresent(Nullable.class);
        final Dependency<T> dep = new Dependency<T>(key, optional);
        return new BindingInitializer<T>(Collections.singleton(dep)){

            @Override
            public Consumer<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
                Supplier<?> binding = compiler.apply(dep);
                return instance -> {
                    Object arg = binding.get();
                    try {
                        field.set(instance, arg);
                    }
                    catch (IllegalAccessException e) {
                        throw new DIException("Not allowed to set injectable field " + String.valueOf(field), e);
                    }
                };
            }
        };
    }

    public static <T> BindingInitializer<T> methodInjector(Key<T> container, final Method method) {
        method.setAccessible(true);
        Dependency<?>[] dependencies = ReflectionUtils.toDependencies(container.getType(), method);
        return new BindingInitializer<T>(new HashSet(Arrays.asList(dependencies))){

            @Override
            public Consumer<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
                return instance -> {
                    Object[] args = this.getDependencies().stream().map(compiler).map(Supplier::get).toArray();
                    try {
                        method.invoke(instance, args);
                    }
                    catch (IllegalAccessException e) {
                        throw new DIException("Not allowed to call injectable method " + String.valueOf(method), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new DIException("Failed to call injectable method " + String.valueOf(method), e.getCause());
                    }
                };
            }
        };
    }

    public static Dependency<?>[] toDependencies(@Nullable Type container, Executable executable) {
        Dependency<?>[] keys = ReflectionUtils.toArgDependencies(container, executable);
        if (executable instanceof Constructor || Modifier.isStatic(executable.getModifiers())) {
            return keys;
        }
        Dependency[] nkeys = new Dependency[keys.length + 1];
        nkeys[0] = new Dependency(Key.ofType(container), false);
        System.arraycopy(keys, 0, nkeys, 1, keys.length);
        return nkeys;
    }

    private static Dependency<?>[] toArgDependencies(@Nullable Type container, Executable executable) {
        Parameter[] parameters = executable.getParameters();
        Dependency[] dependencies = new Dependency[parameters.length];
        if (parameters.length == 0) {
            return dependencies;
        }
        Type[] genericParameterTypes = executable.getGenericParameterTypes();
        for (int i = 0; i < dependencies.length; ++i) {
            Type type = genericParameterTypes[i];
            Parameter parameter = parameters[i];
            boolean optional = parameter.isAnnotationPresent(Nullable.class);
            dependencies[i] = new Dependency(ReflectionUtils.keyOf(container, type, parameter), optional);
        }
        return dependencies;
    }

    public static <T> Binding<T> bindingFromMethod(Method method) {
        method.setAccessible(true);
        Binding<Object> binding = Binding.to(Key.ofType(method.getGenericReturnType(), ReflectionUtils.qualifierOf(method)), args -> {
            try {
                Object[] params;
                Object instance;
                if (Modifier.isStatic(method.getModifiers())) {
                    instance = null;
                    params = args;
                } else {
                    instance = args[0];
                    params = Arrays.copyOfRange(args, 1, args.length);
                }
                Object result = method.invoke(instance, params);
                if (result == null) {
                    throw new NullPointerException("@Provides method must return non-null result, method " + String.valueOf(method));
                }
                return result;
            }
            catch (IllegalAccessException e) {
                throw new DIException("Not allowed to call method " + String.valueOf(method), e);
            }
            catch (InvocationTargetException e) {
                throw new DIException("Failed to call method " + String.valueOf(method), e.getCause());
            }
        }, ReflectionUtils.toDependencies(method.getDeclaringClass(), method));
        Priority priority = method.getAnnotation(Priority.class);
        if (priority != null) {
            binding = binding.prioritize(priority.value());
        }
        return binding;
    }

    public static <T> Binding<T> bindingFromConstructor(Key<T> key, Constructor<T> constructor) {
        constructor.setAccessible(true);
        Dependency<?>[] dependencies = ReflectionUtils.toDependencies(key.getType(), constructor);
        Binding<Object> binding = Binding.to(key, args -> {
            try {
                return constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new DIException("Cannot instantiate object from the constructor " + String.valueOf(constructor) + " to provide requested key " + String.valueOf(key), e);
            }
            catch (IllegalAccessException e) {
                throw new DIException("Not allowed to call constructor " + String.valueOf(constructor) + " to provide requested key " + String.valueOf(key), e);
            }
            catch (InvocationTargetException e) {
                throw new DIException("Failed to call constructor " + String.valueOf(constructor) + " to provide requested key " + String.valueOf(key), e.getCause());
            }
        }, dependencies);
        Priority priority = constructor.getDeclaringClass().getAnnotation(Priority.class);
        if (priority != null) {
            binding = binding.prioritize(priority.value());
        }
        return binding.withKey(key);
    }
}

