/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginConfiguration;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Resource;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class BuildBase
extends PluginConfiguration
implements Serializable,
InputLocationTracker {
    final String defaultGoal;
    final List<Resource> resources;
    final List<Resource> testResources;
    final String directory;
    final String finalName;
    final List<String> filters;

    protected BuildBase(Builder builder) {
        super(builder);
        String string = builder.defaultGoal != null ? builder.defaultGoal : (this.defaultGoal = builder.base != null ? builder.base.defaultGoal : null);
        this.resources = ImmutableCollections.copy(builder.resources != null ? builder.resources : (builder.base != null ? builder.base.resources : null));
        this.testResources = ImmutableCollections.copy(builder.testResources != null ? builder.testResources : (builder.base != null ? builder.base.testResources : null));
        String string2 = builder.directory != null ? builder.directory : (this.directory = builder.base != null ? builder.base.directory : null);
        String string3 = builder.finalName != null ? builder.finalName : (this.finalName = builder.base != null ? builder.base.finalName : null);
        this.filters = ImmutableCollections.copy(builder.filters != null ? builder.filters : (builder.base != null ? builder.base.filters : null));
    }

    public String getDefaultGoal() {
        return this.defaultGoal;
    }

    @Nonnull
    public List<Resource> getResources() {
        return this.resources;
    }

    @Nonnull
    public List<Resource> getTestResources() {
        return this.testResources;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFinalName() {
        return this.finalName;
    }

    @Nonnull
    public List<String> getFilters() {
        return this.filters;
    }

    @Override
    @Nonnull
    public Builder with() {
        return BuildBase.newBuilder(this);
    }

    @Override
    @Nonnull
    public BuildBase withPlugins(Collection<Plugin> plugins) {
        return ((Builder)BuildBase.newBuilder(this, true).plugins((Collection)plugins)).build();
    }

    @Override
    @Nonnull
    public BuildBase withPluginManagement(PluginManagement pluginManagement) {
        return BuildBase.newBuilder(this, true).pluginManagement(pluginManagement).build();
    }

    @Nonnull
    public BuildBase withDefaultGoal(String defaultGoal) {
        return BuildBase.newBuilder(this, true).defaultGoal(defaultGoal).build();
    }

    @Nonnull
    public BuildBase withResources(Collection<Resource> resources) {
        return BuildBase.newBuilder(this, true).resources(resources).build();
    }

    @Nonnull
    public BuildBase withTestResources(Collection<Resource> testResources) {
        return BuildBase.newBuilder(this, true).testResources(testResources).build();
    }

    @Nonnull
    public BuildBase withDirectory(String directory) {
        return BuildBase.newBuilder(this, true).directory(directory).build();
    }

    @Nonnull
    public BuildBase withFinalName(String finalName) {
        return BuildBase.newBuilder(this, true).finalName(finalName).build();
    }

    @Nonnull
    public BuildBase withFilters(Collection<String> filters) {
        return BuildBase.newBuilder(this, true).filters(filters).build();
    }

    @Nonnull
    public static BuildBase newInstance() {
        return BuildBase.newInstance(true);
    }

    @Nonnull
    public static BuildBase newInstance(boolean withDefaults) {
        return BuildBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return BuildBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(BuildBase from) {
        return BuildBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(BuildBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "BuildBase {" + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends PluginConfiguration.Builder {
        BuildBase base;
        String defaultGoal;
        Collection<Resource> resources;
        Collection<Resource> testResources;
        String directory;
        String finalName;
        Collection<String> filters;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(BuildBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.defaultGoal = base.defaultGoal;
                this.resources = base.resources;
                this.testResources = base.testResources;
                this.directory = base.directory;
                this.finalName = base.finalName;
                this.filters = base.filters;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public BuildBase build() {
            if (!(this.base == null || this.plugins != null && this.plugins != this.base.plugins || this.pluginManagement != null && this.pluginManagement != this.base.pluginManagement || this.defaultGoal != null && this.defaultGoal != this.base.defaultGoal || this.resources != null && this.resources != this.base.resources || this.testResources != null && this.testResources != this.base.testResources || this.directory != null && this.directory != this.base.directory || this.finalName != null && this.finalName != this.base.finalName || this.filters != null && this.filters != this.base.filters)) {
                return this.base;
            }
            return new BuildBase(this);
        }
    }
}

