/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.MojoExecution;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.internal.impl.model.reflection.ReflectionValueExtractor;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;

public class PluginParameterExpressionEvaluatorV4
implements TypeAwareExpressionEvaluator {
    private final Session session;
    private final MojoExecution mojoExecution;
    private final Project project;
    private final Path basedir;
    private final Map<String, String> properties;

    public PluginParameterExpressionEvaluatorV4(Session session, Project project) {
        this(session, project, null);
    }

    public PluginParameterExpressionEvaluatorV4(Session session, Project project, MojoExecution mojoExecution) {
        this.session = session;
        this.mojoExecution = mojoExecution;
        this.properties = session.getEffectiveProperties(project);
        this.project = project;
        Path basedir = null;
        if (project != null) {
            Path projectFile = project.getBasedir();
            basedir = projectFile.toAbsolutePath();
        }
        if (basedir == null) {
            basedir = session.getTopDirectory();
        }
        if (basedir == null) {
            basedir = Paths.get(System.getProperty("user.dir"), new String[0]);
        }
        this.basedir = basedir;
    }

    public Object evaluate(String expr) throws ExpressionEvaluationException {
        return this.evaluate(expr, null);
    }

    public Object evaluate(String expr, Class<?> type) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf(125, index)) >= 0) {
                Object subResult;
                Object retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? (String)retVal + expr.substring(index + 1, lastIndex + 1) : ((subResult = this.evaluate(expr.substring(index, lastIndex + 1))) != null ? (String)retVal + String.valueOf(subResult) : (String)retVal + "$" + expr.substring(index + 1, lastIndex + 1));
                retVal = (String)retVal + String.valueOf(this.evaluate(expr.substring(lastIndex + 1)));
                return retVal;
            }
            return expression.replace("$$", "$");
        }
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("session.", this.session);
        objects.put("project.", this.project);
        objects.put("mojo.", this.mojoExecution);
        objects.put("settings.", this.session.getSettings());
        for (Map.Entry ctx : objects.entrySet()) {
            if (!expression.startsWith((String)ctx.getKey())) continue;
            try {
                int pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    String pathExpression = expression.substring(0, pathSeparator);
                    value = ReflectionValueExtractor.evaluate((String)pathExpression, ctx.getValue());
                    if (pathSeparator >= expression.length() - 1) break;
                    if (value instanceof Path) {
                        value = ((Path)value).resolve(expression.substring(pathSeparator + 1));
                        break;
                    }
                    value = String.valueOf(value) + expression.substring(pathSeparator);
                    break;
                }
                value = ReflectionValueExtractor.evaluate((String)expression, ctx.getValue());
                break;
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
            }
        }
        if (value != null && type != null && !(value instanceof String) && !PluginParameterExpressionEvaluatorV4.isTypeCompatible(type, value)) {
            value = null;
        }
        if (value == null && this.properties != null) {
            value = this.properties.get(expression);
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + String.valueOf(this.evaluate(val.substring(exprStartDelimiter))) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private static boolean isTypeCompatible(Class<?> type, Object value) {
        if (type.isInstance(value)) {
            return true;
        }
        return (type.isPrimitive() || type.getName().startsWith("java.lang.")) && value.getClass().getName().startsWith("java.lang.");
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf(125) == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public File alignToBaseDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            file = file.getPath().startsWith(File.separator) ? file.getAbsoluteFile() : this.basedir.resolve(file.getPath()).normalize().toAbsolutePath().toFile();
        }
        return file;
    }
}

