/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.mvnenc.EncryptOptions;
import org.apache.maven.cling.invoker.LookupInvoker;
import org.apache.maven.cling.invoker.ProtoLookup;
import org.apache.maven.cling.invoker.mvnenc.EncryptContext;
import org.apache.maven.cling.invoker.mvnenc.Goal;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.jline.consoleui.prompt.ConsolePrompt;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Colors;
import org.jline.utils.OSUtils;

public class EncryptInvoker
extends LookupInvoker<EncryptContext> {
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int BAD_OPERATION = 2;
    public static final int CANCELED = 3;

    public EncryptInvoker(ProtoLookup protoLookup) {
        super(protoLookup);
    }

    @Override
    protected int execute(EncryptContext context) throws Exception {
        return this.doExecute(context);
    }

    @Override
    protected EncryptContext createContext(InvokerRequest invokerRequest) {
        return new EncryptContext(invokerRequest);
    }

    @Override
    protected void lookup(EncryptContext context) {
        context.goals = context.lookup.lookupMap(Goal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(EncryptContext context) throws Exception {
        try {
            if (!context.interactive) {
                context.terminal.writer().println("This tool works only in interactive mode!");
                context.terminal.writer().println("Tool purpose is to configure password management on developer workstations.");
                context.terminal.writer().println("Note: Generated configuration can be moved/copied to headless environments, if configured as such.");
                int n = 2;
                return n;
            }
            context.header = new ArrayList<AttributedString>();
            context.style = new AttributedStyle();
            context.addInHeader(context.style.italic().bold().foreground(Colors.rgbColor((String)"green").intValue()), "Maven Encryption " + CLIReportingUtils.showVersionMinimal());
            context.addInHeader("Tool for secure password management on workstations.");
            context.addInHeader("This tool is part of Apache Maven 4 distribution.");
            context.addInHeader("");
            Thread executeThread = Thread.currentThread();
            context.terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
            if (context.terminal.getType().equals("dumb") || context.terminal.getType().equals("dumb-color")) {
                context.terminal.writer().println(context.terminal.getName() + ": " + context.terminal.getType());
                throw new IllegalStateException("Dumb terminal detected.\nThis tool requires real terminal to work!\nNote: On Windows Jansi or JNA library must be included in classpath.");
            }
            ConsolePrompt.UiConfig config = OSUtils.IS_WINDOWS ? new ConsolePrompt.UiConfig(">", "( )", "(x)", "( )") : new ConsolePrompt.UiConfig("\u276f", "\u25ef ", "\u25c9 ", "\u25ef ");
            config.setCancellableFirstPrompt(true);
            context.reader = LineReaderBuilder.builder().terminal(context.terminal).build();
            context.prompt = new ConsolePrompt(context.reader, context.terminal, config);
            EncryptOptions options = (EncryptOptions)context.invokerRequest.options();
            if (options.goals().isEmpty() || ((List)options.goals().get()).size() != 1) {
                int n = this.badGoalsErrorMessage("No goal or multiple goals specified, specify only one goal.", context);
                return n;
            }
            String goalName = (String)((List)options.goals().get()).get(0);
            Goal goal = context.goals.get(goalName);
            if (goal == null) {
                int n = this.badGoalsErrorMessage("Unknown goal: " + goalName, context);
                return n;
            }
            int n = goal.execute(context);
            return n;
        }
        catch (InterruptedIOException | InterruptedException | UserInterruptException e) {
            context.terminal.writer().println("Goal canceled by user.");
            int n = 3;
            return n;
        }
        catch (Exception e) {
            if (context.invokerRequest.options().showErrors().orElse(false).booleanValue()) {
                context.terminal.writer().println(e.getMessage());
                e.printStackTrace(context.terminal.writer());
            } else {
                context.terminal.writer().println(e.getMessage());
            }
            int n = 1;
            return n;
        }
        finally {
            context.terminal.writer().flush();
        }
    }

    protected int badGoalsErrorMessage(String message, EncryptContext context) {
        context.terminal.writer().println(message);
        context.terminal.writer().println("Supported goals are: " + String.join((CharSequence)", ", context.goals.keySet()));
        context.terminal.writer().println("Use -h to display help.");
        return 2;
    }
}

