/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.Parser;
import org.apache.maven.api.cli.ParserException;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.cling.internal.extension.io.CoreExtensionsStaxReader;
import org.apache.maven.cling.invoker.Utils;
import org.apache.maven.cling.props.MavenPropertiesLoader;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.properties.internal.SystemProperties;

public abstract class BaseParser
implements Parser {
    public InvokerRequest parseInvocation(ParserRequest parserRequest) throws ParserException, IOException {
        Objects.requireNonNull(parserRequest);
        LocalContext context = new LocalContext(parserRequest);
        context.cwd = Objects.requireNonNull(this.getCwd(context));
        context.installationDirectory = Objects.requireNonNull(this.getInstallationDirectory(context));
        context.userHomeDirectory = Objects.requireNonNull(this.getUserHomeDirectory(context));
        context.topDirectory = Objects.requireNonNull(this.getTopDirectory(context));
        context.rootDirectory = this.getRootDirectory(context);
        List<Options> parsedOptions = this.parseCliOptions(context);
        PrintWriter printWriter = new PrintWriter(parserRequest.out() != null ? parserRequest.out() : System.out, true);
        parsedOptions.forEach(o -> o.warnAboutDeprecatedOptions(parserRequest, printWriter::println));
        context.options = this.assembleOptions(parsedOptions);
        context.systemProperties = this.populateSystemProperties(context);
        context.userProperties = this.populateUserProperties(context);
        context.options = context.options.interpolate(Arrays.asList(context.extraInterpolationSource(), context.userProperties, context.systemProperties));
        context.extensions = this.readCoreExtensionsDescriptor(context);
        return this.getInvokerRequest(context);
    }

    protected abstract InvokerRequest getInvokerRequest(LocalContext var1);

    protected Path getCwd(LocalContext context) throws ParserException {
        if (context.parserRequest.cwd() != null) {
            Path result = Utils.getCanonicalPath(context.parserRequest.cwd());
            context.systemPropertiesOverrides.put("user.dir", result.toString());
            return result;
        }
        return Utils.getCanonicalPath(Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    protected Path getInstallationDirectory(LocalContext context) throws ParserException {
        Path result;
        if (context.parserRequest.mavenHome() != null) {
            result = Utils.getCanonicalPath(context.parserRequest.mavenHome());
            context.systemPropertiesOverrides.put("maven.home", result.toString());
        } else {
            String mavenHome = System.getProperty("maven.home");
            if (mavenHome == null) {
                throw new ParserException("local mode requires maven.home Java System Property set");
            }
            result = Utils.getCanonicalPath(Paths.get(mavenHome, new String[0]));
        }
        return result;
    }

    protected Path getUserHomeDirectory(LocalContext context) throws ParserException {
        if (context.parserRequest.userHome() != null) {
            Path result = Utils.getCanonicalPath(context.parserRequest.userHome());
            context.systemPropertiesOverrides.put("user.home", result.toString());
            return result;
        }
        return Utils.getCanonicalPath(Paths.get(System.getProperty("user.home"), new String[0]));
    }

    protected Path getTopDirectory(LocalContext context) throws ParserException {
        Path topDirectory = Objects.requireNonNull(context.cwd);
        boolean isAltFile = false;
        for (String arg : context.parserRequest.args()) {
            if (isAltFile) {
                Path path = topDirectory.resolve(Utils.stripLeadingAndTrailingQuotes(arg));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    topDirectory = path;
                    break;
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    topDirectory = path.getParent();
                    if (Files.isDirectory(topDirectory, new LinkOption[0])) break;
                    throw new ParserException("Directory " + String.valueOf(topDirectory) + " extracted from the -f/--file command-line argument " + arg + " does not exist");
                }
                throw new ParserException("POM file " + arg + " specified with the -f/--file command line argument does not exist");
            }
            isAltFile = arg.equals("-f") || arg.equals("--file");
        }
        return Utils.getCanonicalPath(topDirectory);
    }

    @Nullable
    protected Path getRootDirectory(LocalContext context) throws ParserException {
        return Utils.findRoot(context.topDirectory);
    }

    protected Map<String, String> populateSystemProperties(LocalContext context) throws ParserException {
        Properties systemProperties = new Properties();
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        SystemProperties.addSystemProperties((Properties)systemProperties);
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString(buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
        Map<String, String> result = Utils.toMap(systemProperties);
        result.putAll(context.systemPropertiesOverrides);
        return result;
    }

    protected Map<String, String> populateUserProperties(LocalContext context) throws ParserException, IOException {
        Properties userProperties = new Properties();
        Map userSpecifiedProperties = context.options.userProperties().orElse(new HashMap());
        Map<String, String> paths = context.extraInterpolationSource();
        Function[] functionArray = new Function[3];
        functionArray[0] = paths::get;
        functionArray[1] = Utils.prefix("cli.", userSpecifiedProperties::get);
        functionArray[2] = context.systemProperties::get;
        Function<String, String> callback = Utils.or(functionArray);
        Path mavenConf = context.systemProperties.get("maven.installation.conf") != null ? context.installationDirectory.resolve(context.systemProperties.get("maven.installation.conf")) : (context.systemProperties.get("maven.conf") != null ? context.installationDirectory.resolve(context.systemProperties.get("maven.conf")) : (context.systemProperties.get("maven.home") != null ? context.installationDirectory.resolve(context.systemProperties.get("maven.home")).resolve("conf") : context.installationDirectory.resolve("")));
        Path propertiesFile = mavenConf.resolve("maven.properties");
        MavenPropertiesLoader.loadProperties(userProperties, propertiesFile, callback, false);
        userProperties.putAll((Map<?, ?>)userSpecifiedProperties);
        return Utils.toMap(userProperties);
    }

    protected abstract List<Options> parseCliOptions(LocalContext var1) throws ParserException, IOException;

    protected abstract Options assembleOptions(List<Options> var1);

    protected List<CoreExtension> readCoreExtensionsDescriptor(LocalContext context) throws ParserException, IOException {
        ArrayList<CoreExtension> extensions = new ArrayList<CoreExtension>();
        String installationExtensionsFile = context.userProperties.get("maven.installation.extensions");
        extensions.addAll(this.readCoreExtensionsDescriptorFromFile(context.installationDirectory.resolve(installationExtensionsFile)));
        String projectExtensionsFile = context.userProperties.get("maven.project.extensions");
        extensions.addAll(this.readCoreExtensionsDescriptorFromFile(context.cwd.resolve(projectExtensionsFile)));
        String userExtensionsFile = context.userProperties.get("maven.user.extensions");
        extensions.addAll(this.readCoreExtensionsDescriptorFromFile(context.userHomeDirectory.resolve(userExtensionsFile)));
        return extensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<CoreExtension> readCoreExtensionsDescriptorFromFile(Path extensionsFile) throws ParserException, IOException {
        List list;
        if (extensionsFile == null || !Files.exists(extensionsFile, new LinkOption[0])) return List.of();
        InputStream is = Files.newInputStream(extensionsFile, new OpenOption[0]);
        try {
            list = new CoreExtensionsStaxReader().read(is, true).getExtensions();
            if (is == null) return list;
        }
        catch (Throwable throwable) {
            try {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new ParserException("Failed to parse extensions file: " + String.valueOf(extensionsFile), (Throwable)e);
            }
        }
        is.close();
        return list;
    }

    protected List<String> getJvmArguments(Path rootDirectory) throws ParserException {
        Path jvmConfig;
        if (rootDirectory != null && Files.exists(jvmConfig = rootDirectory.resolve(".mvn/jvm.config"), new LinkOption[0])) {
            try {
                return Files.readAllLines(jvmConfig).stream().filter(l -> !l.isBlank() && !l.startsWith("#")).flatMap(l -> Arrays.stream(l.split(" "))).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new ParserException("Failed to read JVM configuration file: " + String.valueOf(jvmConfig), (Throwable)e);
            }
        }
        return null;
    }

    public static class LocalContext {
        public final ParserRequest parserRequest;
        public final Map<String, String> systemPropertiesOverrides;
        public Path cwd;
        public Path installationDirectory;
        public Path userHomeDirectory;
        public Map<String, String> systemProperties;
        public Map<String, String> userProperties;
        public Path topDirectory;
        @Nullable
        public Path rootDirectory;
        public List<CoreExtension> extensions;
        public Options options;

        public LocalContext(ParserRequest parserRequest) {
            this.parserRequest = parserRequest;
            this.systemPropertiesOverrides = new HashMap<String, String>();
        }

        public Map<String, String> extraInterpolationSource() {
            HashMap<String, String> extra = new HashMap<String, String>();
            extra.put("session.topDirectory", this.topDirectory.toString());
            if (this.rootDirectory != null) {
                extra.put("session.rootDirectory", this.rootDirectory.toString());
            }
            return extra;
        }
    }
}

