/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model.profile;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;
import org.apache.maven.api.services.model.RootLocator;
import org.apache.maven.internal.impl.model.DefaultInterpolator;
import org.apache.maven.internal.impl.model.ProfileActivationFilePathInterpolator;
import org.apache.maven.internal.impl.model.profile.ConditionFunctions;
import org.apache.maven.internal.impl.model.profile.ConditionParser;

@Named(value="condition")
@Singleton
public class ConditionProfileActivator
implements ProfileActivator {
    private final VersionParser versionParser;
    private final ProfileActivationFilePathInterpolator interpolator;
    private final RootLocator rootLocator;

    @Inject
    public ConditionProfileActivator(VersionParser versionParser, ProfileActivationFilePathInterpolator interpolator, RootLocator rootLocator) {
        this.versionParser = versionParser;
        this.interpolator = interpolator;
        this.rootLocator = rootLocator;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        if (profile.getActivation() == null || profile.getActivation().getCondition() == null) {
            return false;
        }
        String condition = profile.getActivation().getCondition();
        try {
            Map<String, ConditionParser.ExpressionFunction> functions = ConditionProfileActivator.registerFunctions(context, this.versionParser, this.interpolator);
            Function<String, String> propertyResolver = s -> ConditionProfileActivator.property(context, this.rootLocator, s);
            return ConditionParser.toBoolean(new ConditionParser(functions, propertyResolver).parse(condition));
        }
        catch (Exception e) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.V41, "Error parsing profile activation condition: " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        return activation.getCondition() != null && !activation.getCondition().isBlank();
    }

    public static Map<String, ConditionParser.ExpressionFunction> registerFunctions(ProfileActivationContext context, VersionParser versionParser, ProfileActivationFilePathInterpolator interpolator) {
        HashMap<String, ConditionParser.ExpressionFunction> functions = new HashMap<String, ConditionParser.ExpressionFunction>();
        ConditionFunctions conditionFunctions = new ConditionFunctions(context, versionParser, interpolator);
        for (Method method : ConditionFunctions.class.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.endsWith("_")) {
                methodName = methodName.substring(0, methodName.length() - 1);
            }
            String finalMethodName = methodName;
            functions.put(finalMethodName, args -> {
                try {
                    return method.invoke((Object)conditionFunctions, args);
                }
                catch (Exception e) {
                    StringBuilder causeChain = new StringBuilder();
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!causeChain.isEmpty()) {
                            causeChain.append(" Caused by: ");
                        }
                        causeChain.append(cause.toString());
                    }
                    throw new RuntimeException("Error invoking function '" + finalMethodName + "': " + String.valueOf(e) + ". Cause chain: " + String.valueOf(causeChain), e);
                }
            });
        }
        return functions;
    }

    static String property(ProfileActivationContext context, RootLocator rootLocator, String name) {
        String value = ConditionProfileActivator.doGetProperty(context, rootLocator, name);
        return new DefaultInterpolator().interpolate(value, s -> ConditionProfileActivator.doGetProperty(context, rootLocator, s));
    }

    static String doGetProperty(ProfileActivationContext context, RootLocator rootLocator, String name) {
        if ("project.basedir".equals(name)) {
            Path basedir = context.getModel().getProjectDirectory();
            return basedir != null ? basedir.toFile().getAbsolutePath() : null;
        }
        if ("project.rootDirectory".equals(name)) {
            Path basedir = context.getModel().getProjectDirectory();
            if (basedir != null) {
                Path root = rootLocator.findMandatoryRoot(basedir);
                return root.toFile().getAbsolutePath();
            }
            return null;
        }
        if ("project.artifactId".equals(name)) {
            return context.getModel().getArtifactId();
        }
        if ("project.packaging".equals(name)) {
            return context.getModel().getPackaging();
        }
        String v = context.getUserProperties().get(name);
        if (v == null) {
            v = (String)context.getModel().getProperties().get(name);
        }
        if (v == null) {
            v = context.getSystemProperties().get(name);
        }
        return v;
    }
}

