/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Optional;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Options;
import org.apache.maven.cli.DaemonPlexusContainerCapsuleFactory;
import org.apache.maven.cling.invoker.ContainerCapsuleFactory;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.ProtoLookup;
import org.apache.maven.cling.invoker.mvn.MavenContext;
import org.apache.maven.cling.invoker.mvn.resident.ResidentMavenContext;
import org.apache.maven.cling.invoker.mvn.resident.ResidentMavenInvoker;
import org.apache.maven.cling.utils.CLIReportingUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.jline.MessageUtils;
import org.apache.maven.logging.BuildEventListener;
import org.apache.maven.logging.LoggingOutputStream;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.mvndaemon.mvnd.common.Environment;

public class DaemonMavenInvoker
extends ResidentMavenInvoker {
    public DaemonMavenInvoker(ProtoLookup protoLookup) {
        super(protoLookup);
    }

    protected void createTerminal(ResidentMavenContext context) {
        MessageUtils.systemInstall(builder -> {
            builder.streams((InputStream)context.invokerRequest.in().orElseThrow(), (OutputStream)context.invokerRequest.out().orElseThrow());
            builder.systemOutput(TerminalBuilder.SystemOutput.ForcedSysOut);
            builder.provider("exec");
            if (context.coloredOutput != null) {
                builder.color(context.coloredOutput.booleanValue());
            }
        }, terminal -> this.doConfigureWithTerminal(context, (Terminal)terminal));
        context.terminal = MessageUtils.getTerminal();
        context.closeables.add(MessageUtils::systemUninstall);
        MessageUtils.registerShutdownHook();
        if (context.coloredOutput != null) {
            MessageUtils.setColorEnabled((boolean)context.coloredOutput);
        }
    }

    protected void doConfigureWithTerminal(ResidentMavenContext context, Terminal terminal) {
        super.doConfigureWithTerminal((LookupContext)context, terminal);
        Optional rawStreams = context.invokerRequest.options().rawStreams();
        if (rawStreams.orElse(false).booleanValue()) {
            System.setOut(this.printStream((OutputStream)context.invokerRequest.out().orElseThrow()));
            System.setErr(this.printStream((OutputStream)context.invokerRequest.err().orElseThrow()));
        }
    }

    private PrintStream printStream(OutputStream outputStream) {
        if (outputStream instanceof LoggingOutputStream) {
            LoggingOutputStream los = (LoggingOutputStream)outputStream;
            return los.printStream();
        }
        if (outputStream instanceof PrintStream) {
            PrintStream ps = (PrintStream)outputStream;
            return ps;
        }
        return new PrintStream(outputStream);
    }

    protected BuildEventListener doDetermineBuildEventListener(ResidentMavenContext context) {
        return (BuildEventListener)context.invokerRequest.lookup().lookup(BuildEventListener.class);
    }

    protected void helpOrVersionAndMayExit(ResidentMavenContext context) throws Exception {
        InvokerRequest invokerRequest = context.invokerRequest;
        BuildEventListener buildEventListener = (BuildEventListener)context.invokerRequest.parserRequest().lookup().lookup(BuildEventListener.class);
        if (invokerRequest.options().help().isPresent()) {
            context.invokerRequest.options().displayHelp(invokerRequest.parserRequest(), arg_0 -> ((BuildEventListener)buildEventListener).log(arg_0));
            throw new InvokerException.ExitException(0);
        }
        if (invokerRequest.options().showVersionAndExit().isPresent()) {
            if (invokerRequest.options().quiet().orElse(false).booleanValue()) {
                buildEventListener.log(CLIReportingUtils.showVersionMinimal());
            } else {
                buildEventListener.log(CLIReportingUtils.showVersion());
            }
            throw new InvokerException.ExitException(0);
        }
    }

    protected void preCommands(ResidentMavenContext context) throws Exception {
        Options mavenOptions = context.invokerRequest.options();
        if (mavenOptions.verbose().orElse(false).booleanValue() || mavenOptions.showVersion().orElse(false).booleanValue()) {
            ((BuildEventListener)context.invokerRequest.parserRequest().lookup().lookup(BuildEventListener.class)).log(CLIReportingUtils.showVersion());
        }
    }

    protected ContainerCapsuleFactory<ResidentMavenContext> createContainerCapsuleFactory() {
        return new DaemonPlexusContainerCapsuleFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(ResidentMavenContext context, MavenExecutionRequest request) throws Exception {
        context.logger.info(MessageUtils.builder().a((CharSequence)"Processing build on daemon ").strong((Object)Environment.MVND_ID.asString()).toString());
        context.logger.debug("Daemon status dump:");
        context.logger.debug("CWD: " + String.valueOf(context.invokerRequest.cwd()));
        context.logger.debug("MAVEN_HOME: " + String.valueOf(context.invokerRequest.installationDirectory()));
        context.logger.debug("USER_HOME: " + String.valueOf(context.invokerRequest.userHomeDirectory()));
        context.logger.debug("topDirectory: " + String.valueOf(context.invokerRequest.topDirectory()));
        context.logger.debug("rootDirectory: " + String.valueOf(context.invokerRequest.rootDirectory()));
        try {
            int n = super.doExecute((MavenContext)context, request);
            return n;
        }
        finally {
            LoggingOutputStream.forceFlush((PrintStream)System.out);
            LoggingOutputStream.forceFlush((PrintStream)System.err);
        }
    }
}

