/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

@Named
@Singleton
public class DefaultModelVersionParser
implements ModelVersionParser {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");
    private final VersionScheme versionScheme;

    @Inject
    public DefaultModelVersionParser(VersionScheme versionScheme) {
        this.versionScheme = Objects.requireNonNull(versionScheme, "versionScheme");
    }

    public org.apache.maven.api.Version parseVersion(String version) {
        Objects.requireNonNull(version, "version");
        return new DefaultVersion(this.versionScheme, version);
    }

    public VersionRange parseVersionRange(String range) {
        Objects.requireNonNull(range, "range");
        return new DefaultVersionRange(this.versionScheme, range);
    }

    public boolean isSnapshot(String version) {
        return DefaultModelVersionParser.checkSnapshot(version);
    }

    public static boolean checkSnapshot(String version) {
        return version.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    public VersionConstraint parseVersionConstraint(String constraint) {
        Objects.requireNonNull(constraint, "constraint");
        return new DefaultVersionConstraint(this.versionScheme, constraint);
    }

    static class DefaultVersion
    implements org.apache.maven.api.Version {
        private final VersionScheme versionScheme;
        private final Version delegate;

        DefaultVersion(VersionScheme versionScheme, Version delegate) {
            this.versionScheme = versionScheme;
            this.delegate = delegate;
        }

        DefaultVersion(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersion(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version: " + delegateValue, (Exception)((Object)e));
            }
        }

        public int compareTo(org.apache.maven.api.Version o) {
            if (o instanceof DefaultVersion) {
                return this.delegate.compareTo((Object)((DefaultVersion)o).delegate);
            }
            return this.compareTo(new DefaultVersion(this.versionScheme, o.asString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersion that = (DefaultVersion)o;
            return this.delegate.equals((Object)that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }
    }

    static class DefaultVersionRange
    implements VersionRange {
        private final VersionScheme versionScheme;
        private final org.eclipse.aether.version.VersionRange delegate;

        DefaultVersionRange(VersionScheme versionScheme, org.eclipse.aether.version.VersionRange delegate) {
            this.versionScheme = versionScheme;
            this.delegate = delegate;
        }

        DefaultVersionRange(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersionRange(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version range: " + delegateValue, (Exception)((Object)e));
            }
        }

        public boolean contains(org.apache.maven.api.Version version) {
            if (version instanceof DefaultVersion) {
                return this.delegate.containsVersion(((DefaultVersion)version).delegate);
            }
            return this.contains(new DefaultVersion(this.versionScheme, version.asString()));
        }

        public VersionRange.Boundary getUpperBoundary() {
            final VersionRange.Bound bound = this.delegate.getUpperBound();
            if (bound == null) {
                return null;
            }
            return new VersionRange.Boundary(){

                public org.apache.maven.api.Version getVersion() {
                    return new DefaultVersion(versionScheme, bound.getVersion());
                }

                public boolean isInclusive() {
                    return bound.isInclusive();
                }
            };
        }

        public VersionRange.Boundary getLowerBoundary() {
            final VersionRange.Bound bound = this.delegate.getLowerBound();
            if (bound == null) {
                return null;
            }
            return new VersionRange.Boundary(){

                public org.apache.maven.api.Version getVersion() {
                    return new DefaultVersion(versionScheme, bound.getVersion());
                }

                public boolean isInclusive() {
                    return bound.isInclusive();
                }
            };
        }

        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersionRange that = (DefaultVersionRange)o;
            return this.delegate.equals((Object)that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    static class DefaultVersionConstraint
    implements VersionConstraint {
        private final VersionScheme versionScheme;
        private final org.eclipse.aether.version.VersionConstraint delegate;

        DefaultVersionConstraint(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersionConstraint(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version constraint: " + delegateValue, (Exception)((Object)e));
            }
        }

        public boolean contains(org.apache.maven.api.Version version) {
            if (version instanceof DefaultVersion) {
                return this.delegate.containsVersion(((DefaultVersion)version).delegate);
            }
            return this.contains(new DefaultVersion(this.versionScheme, version.asString()));
        }

        public String asString() {
            return this.delegate.toString();
        }

        public VersionRange getVersionRange() {
            if (this.delegate.getRange() == null) {
                return null;
            }
            return new DefaultVersionRange(this.versionScheme, this.delegate.getRange());
        }

        public org.apache.maven.api.Version getRecommendedVersion() {
            if (this.delegate.getVersion() == null) {
                return null;
            }
            return new DefaultVersion(this.versionScheme, this.delegate.getVersion());
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersionConstraint that = (DefaultVersionConstraint)o;
            return this.delegate.equals((Object)that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

