/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.model.v4.MavenStaxWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Named
@Singleton
public class DefaultModelWriter
implements ModelWriter {
    @Override
    public void write(File output, Map<String, Object> options, org.apache.maven.api.model.Model model) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(model, "model cannot be null");
        output.getParentFile().mkdirs();
        this.write((Writer)new XmlStreamWriter(Files.newOutputStream(output.toPath(), new OpenOption[0])), options, model);
    }

    @Override
    public void write(Writer output, Map<String, Object> options, org.apache.maven.api.model.Model model) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(model, "model cannot be null");
        try (Writer out = output;){
            new MavenStaxWriter().write(out, model);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(OutputStream output, Map<String, Object> options, org.apache.maven.api.model.Model model) throws IOException {
        Objects.requireNonNull(output, "output cannot be null");
        Objects.requireNonNull(model, "model cannot be null");
        String encoding = model.getModelEncoding();
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        try (OutputStreamWriter out = new OutputStreamWriter(output, encoding);){
            this.write((Writer)out, options, model);
        }
    }

    @Override
    public void write(File output, Map<String, Object> options, Model model) throws IOException {
        this.write(output, options, model.getDelegate());
    }

    @Override
    public void write(Writer output, Map<String, Object> options, Model model) throws IOException {
        this.write(output, options, model.getDelegate());
    }

    @Override
    public void write(OutputStream output, Map<String, Object> options, Model model) throws IOException {
        this.write(output, options, model.getDelegate());
    }
}

