/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.services.ModelTransformer;
import org.apache.maven.api.services.ModelTransformerContext;

@Named
@Singleton
public class BuildModelTransformer
implements ModelTransformer {
    public static final String NAMESPACE_PREFIX = "http://maven.apache.org/POM/";

    public Model transform(ModelTransformerContext context, Model model, Path path) {
        Model.Builder builder = Model.newBuilder((Model)model);
        this.handleModelVersion(context, model, path, builder);
        this.handleParent(context, model, path, builder);
        this.handleReactorDependencies(context, model, path, builder);
        this.handleCiFriendlyVersion(context, model, path, builder);
        return builder.build();
    }

    void handleModelVersion(ModelTransformerContext context, Model model, Path pomFile, Model.Builder builder) {
        String namespace = model.getNamespaceUri();
        if (model.getModelVersion() == null && namespace != null && namespace.startsWith(NAMESPACE_PREFIX)) {
            builder.modelVersion(namespace.substring(NAMESPACE_PREFIX.length()));
        }
    }

    void handleParent(ModelTransformerContext context, Model model, Path pomFile, Model.Builder builder) {
        Parent parent = model.getParent();
        if (parent != null) {
            Optional<RelativeProject> resolvedParent;
            String version = parent.getVersion();
            String path = Optional.ofNullable(parent.getRelativePath()).orElse("..");
            if (version == null && !path.isEmpty() && (resolvedParent = this.resolveRelativePath(pomFile, context, Paths.get(path, new String[0]), parent.getGroupId(), parent.getArtifactId())).isPresent()) {
                version = resolvedParent.get().getVersion();
            }
            String modVersion = this.replaceCiFriendlyVersion(context, version);
            builder.parent(parent.withVersion(modVersion));
        }
    }

    void handleCiFriendlyVersion(ModelTransformerContext context, Model model, Path pomFile, Model.Builder builder) {
        String version = model.getVersion();
        String modVersion = this.replaceCiFriendlyVersion(context, version);
        builder.version(modVersion);
    }

    void handleReactorDependencies(ModelTransformerContext context, Model model, Path pomFile, Model.Builder builder) {
        ArrayList<Dependency> newDeps = new ArrayList<Dependency>();
        boolean modified = false;
        for (Dependency dep : model.getDependencies()) {
            Model depModel;
            if (dep.getVersion() == null && (depModel = context.getRawModel(model.getPomFile(), dep.getGroupId(), dep.getArtifactId())) != null) {
                String v = depModel.getVersion();
                if (v == null && depModel.getParent() != null) {
                    v = depModel.getParent().getVersion();
                }
                dep = dep.withVersion(v);
                modified = true;
            }
            newDeps.add(dep);
        }
        if (modified) {
            builder.dependencies(newDeps);
        }
    }

    protected String replaceCiFriendlyVersion(ModelTransformerContext context, String version) {
        if (version != null) {
            for (String key : Arrays.asList("changelist", "revision", "sha1")) {
                String val = context.getUserProperty(key);
                if (val == null) continue;
                version = version.replace("${" + key + "}", val);
            }
        }
        return version;
    }

    protected Optional<RelativeProject> resolveRelativePath(Path pomFile, ModelTransformerContext context, Path relativePath, String groupId, String artifactId) {
        RelativeProject project;
        Path pomPath = pomFile.resolveSibling(relativePath).normalize();
        if (Files.isDirectory(pomPath, new LinkOption[0])) {
            pomPath = context.locate(pomPath);
        }
        if (pomPath == null || !Files.isRegularFile(pomPath, new LinkOption[0])) {
            return Optional.empty();
        }
        Optional<RelativeProject> mappedProject = Optional.ofNullable(context.getRawModel(pomFile, pomPath.normalize())).map(BuildModelTransformer::toRelativeProject);
        if (mappedProject.isPresent() && Objects.equals(groupId, (project = mappedProject.get()).getGroupId()) && Objects.equals(artifactId, project.getArtifactId())) {
            return mappedProject;
        }
        return Optional.empty();
    }

    private static RelativeProject toRelativeProject(Model m) {
        String version;
        String groupId = m.getGroupId();
        if (groupId == null && m.getParent() != null) {
            groupId = m.getParent().getGroupId();
        }
        if ((version = m.getVersion()) == null && m.getParent() != null) {
            version = m.getParent().getVersion();
        }
        return new RelativeProject(groupId, m.getArtifactId(), version);
    }

    protected static class RelativeProject {
        private final String groupId;
        private final String artifactId;
        private final String version;

        protected RelativeProject(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

