/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.java;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.toolchain.DefaultToolchain;
import org.apache.maven.toolchain.java.JavaToolchain;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.apache.maven.utils.Os;
import org.slf4j.Logger;

public class JavaToolchainImpl
extends DefaultToolchain
implements JavaToolchain {
    private String javaHome;
    public static final String KEY_JAVAHOME = "jdkHome";

    JavaToolchainImpl(ToolchainModel model, Logger logger) {
        super(model, "jdk", logger);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    @Override
    public String toString() {
        return "JDK[" + this.getJavaHome() + "]";
    }

    @Override
    public String findTool(String toolName) {
        Path toRet = JavaToolchainImpl.findTool(toolName, Paths.get(this.getJavaHome(), new String[0]).normalize());
        if (toRet != null) {
            return toRet.toAbsolutePath().toString();
        }
        return null;
    }

    private static Path findTool(String toolName, Path installDir) {
        Path bin = installDir.resolve("bin");
        if (Files.isDirectory(bin, new LinkOption[0])) {
            Path tool;
            if (Os.IS_WINDOWS && Files.exists(tool = bin.resolve(toolName + ".exe"), new LinkOption[0])) {
                return tool;
            }
            tool = bin.resolve(toolName);
            if (Files.exists(tool, new LinkOption[0])) {
                return tool;
            }
        }
        return null;
    }
}

