/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.api.spi.ExtensibleEnumProvider;
import org.apache.maven.api.spi.LifecycleProvider;
import org.apache.maven.internal.impl.DefaultPackagingRegistry;
import org.apache.maven.internal.impl.Lifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Named
@Singleton
public class DefaultLifecycleRegistry
implements LifecycleRegistry {
    private final List<LifecycleProvider> providers;

    public DefaultLifecycleRegistry() {
        this(Collections.emptyList());
    }

    @Inject
    public DefaultLifecycleRegistry(List<LifecycleProvider> providers) {
        ArrayList<LifecycleProvider> p = new ArrayList<LifecycleProvider>(providers);
        p.add(() -> List.of(new CleanLifecycle(), new DefaultLifecycle(), new SiteLifecycle(), new WrapperLifecycle()));
        this.providers = p;
        Iterator<org.apache.maven.api.Lifecycle> iterator = this.iterator();
        while (iterator.hasNext()) {
            org.apache.maven.api.Lifecycle lifecycle = iterator.next();
            HashSet set = new HashSet();
            lifecycle.phases().forEach(phase -> {
                if (!set.add(phase.name())) {
                    throw new IllegalArgumentException("Found duplicated phase '" + phase.name() + "' in '" + lifecycle.id() + "' lifecycle");
                }
            });
        }
    }

    public Iterator<org.apache.maven.api.Lifecycle> iterator() {
        return this.stream().toList().iterator();
    }

    public Stream<org.apache.maven.api.Lifecycle> stream() {
        return this.providers.stream().map(ExtensibleEnumProvider::provides).flatMap(Collection::stream);
    }

    public Optional<org.apache.maven.api.Lifecycle> lookup(String id) {
        return this.stream().filter(lf -> Objects.equals(id, lf.id())).findAny();
    }

    static class CleanLifecycle
    implements org.apache.maven.api.Lifecycle {
        private static final String MAVEN_CLEAN_PLUGIN_VERSION = "3.2.0";

        CleanLifecycle() {
        }

        public String id() {
            return "clean";
        }

        public Collection<Lifecycle.Phase> phases() {
            return Arrays.asList(Lifecycles.phase("pre-clean"), Lifecycles.phase("clean", Lifecycles.plugin("org.apache.maven.plugins:maven-clean-plugin:3.2.0:clean", "clean")), Lifecycles.phase("post-clean"));
        }
    }

    static class DefaultLifecycle
    implements org.apache.maven.api.Lifecycle {
        DefaultLifecycle() {
        }

        public String id() {
            return "default";
        }

        public Collection<Lifecycle.Phase> phases() {
            return Arrays.asList(Lifecycles.phase("validate"), Lifecycles.phase("initialize"), Lifecycles.phase("generate-sources"), Lifecycles.phase("process-sources"), Lifecycles.phase("generate-resources"), Lifecycles.phase("process-resources"), Lifecycles.phase("compile"), Lifecycles.phase("process-classes"), Lifecycles.phase("generate-test-sources"), Lifecycles.phase("process-test-sources"), Lifecycles.phase("generate-test-resources"), Lifecycles.phase("process-test-resources"), Lifecycles.phase("test-compile"), Lifecycles.phase("process-test-classes"), Lifecycles.phase("test"), Lifecycles.phase("prepare-package"), Lifecycles.phase("package"), Lifecycles.phase("pre-integration-test"), Lifecycles.phase("integration-test"), Lifecycles.phase("post-integration-test"), Lifecycles.phase("verify"), Lifecycles.phase("install"), Lifecycles.phase("deploy"));
        }
    }

    static class SiteLifecycle
    implements org.apache.maven.api.Lifecycle {
        private static final String MAVEN_SITE_PLUGIN_VERSION = "3.12.1";

        SiteLifecycle() {
        }

        public String id() {
            return "site";
        }

        public Collection<Lifecycle.Phase> phases() {
            return Arrays.asList(Lifecycles.phase("pre-site"), Lifecycles.phase("site", Lifecycles.plugin("org.apache.maven.plugins:maven-site-plugin:3.12.1:site", "site")), Lifecycles.phase("post-site"), Lifecycles.phase("site-deploy", Lifecycles.plugin("org.apache.maven.plugins:maven-site-plugin:3.12.1:deploy", "site-deploy")));
        }
    }

    static class WrapperLifecycle
    implements org.apache.maven.api.Lifecycle {
        private static final String MAVEN_WRAPPER_PLUGIN_VERSION = "3.2.0";

        WrapperLifecycle() {
        }

        public String id() {
            return "wrapper";
        }

        public Collection<Lifecycle.Phase> phases() {
            return Collections.singleton(Lifecycles.phase("wrapper", Lifecycles.plugin("org.apache.maven.plugins:maven-wrapper-plugin:3.2.0:wrapper", "wrapper")));
        }
    }

    @Singleton
    @Named(value="wrapper")
    static class WrapperLifecycleProvider
    extends BaseLifecycleProvider {
        WrapperLifecycleProvider() {
            super("wrapper");
        }
    }

    @Singleton
    @Named(value="site")
    static class SiteLifecycleProvider
    extends BaseLifecycleProvider {
        SiteLifecycleProvider() {
            super("site");
        }
    }

    @Singleton
    @Named(value="default")
    static class DefaultLifecycleProvider
    extends BaseLifecycleProvider {
        DefaultLifecycleProvider() {
            super("default");
        }
    }

    @Singleton
    @Named(value="clean")
    static class CleanLifecycleProvider
    extends BaseLifecycleProvider {
        CleanLifecycleProvider() {
            super("clean");
        }
    }

    static abstract class BaseLifecycleProvider
    implements Provider<Lifecycle> {
        @Inject
        private PlexusContainer lookup;
        private final String name;

        BaseLifecycleProvider(String name) {
            this.name = name;
        }

        public Lifecycle get() {
            try {
                LifecycleRegistry registry = (LifecycleRegistry)this.lookup.lookup(LifecycleRegistry.class);
                return new WrappedLifecycle((org.apache.maven.api.Lifecycle)registry.require(this.name));
            }
            catch (ComponentLookupException e) {
                throw new LookupException((Exception)((Object)e));
            }
        }
    }

    static class WrappedLifecycle
    extends Lifecycle {
        WrappedLifecycle(org.apache.maven.api.Lifecycle lifecycle) {
            super(lifecycle);
        }
    }

    @Named
    @Singleton
    public static class LifecycleWrapperProvider
    implements LifecycleProvider {
        private final PlexusContainer container;

        @Inject
        public LifecycleWrapperProvider(PlexusContainer container) {
            this.container = container;
        }

        public Collection<org.apache.maven.api.Lifecycle> provides() {
            try {
                Map all = this.container.lookupMap(Lifecycle.class);
                return all.keySet().stream().filter(id -> !"clean".equals(id) && !"default".equals(id) && !"site".equals(id) && !"wrapper".equals(id)).map(id -> this.wrap((Lifecycle)all.get(id))).collect(Collectors.toList());
            }
            catch (ComponentLookupException e) {
                throw new LookupException((Exception)((Object)e));
            }
        }

        private org.apache.maven.api.Lifecycle wrap(final Lifecycle lifecycle) {
            return new org.apache.maven.api.Lifecycle(){

                public String id() {
                    return lifecycle.getId();
                }

                public Collection<Lifecycle.Phase> phases() {
                    return lifecycle.getPhases().stream().map(name -> new Lifecycle.Phase(){
                        final /* synthetic */ String val$name;
                        final /* synthetic */ Lifecycle val$lifecycle;
                        {
                            this.val$name = string;
                            this.val$lifecycle = lifecycle;
                        }

                        public String name() {
                            return this.val$name;
                        }

                        public List<Plugin> plugins() {
                            LifecyclePhase phase;
                            Map<String, LifecyclePhase> lfPhases = this.val$lifecycle.getDefaultLifecyclePhases();
                            LifecyclePhase lifecyclePhase = phase = lfPhases != null ? lfPhases.get(this.val$name) : null;
                            if (phase != null) {
                                LinkedHashMap<String, Plugin> plugins = new LinkedHashMap<String, Plugin>();
                                DefaultPackagingRegistry.parseLifecyclePhaseDefinitions(plugins, this.val$name, phase);
                                return plugins.values().stream().toList();
                            }
                            return List.of();
                        }
                    }).toList();
                }
            };
        }
    }
}

