/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.normalization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.normalization.ModelNormalizer;

@Named
@Singleton
public class DefaultModelNormalizer
implements ModelNormalizer {
    private DuplicateMerger merger = new DuplicateMerger();

    @Override
    public void mergeDuplicates(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        model.update((Object)this.mergeDuplicates(model.getDelegate(), request, problems));
    }

    @Override
    public void injectDefaultValues(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        model.update((Object)this.injectDefaultValues(model.getDelegate(), request, problems));
    }

    @Override
    public org.apache.maven.api.model.Model mergeDuplicates(org.apache.maven.api.model.Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        LinkedHashMap<String, Object> normalized;
        Model.Builder builder = org.apache.maven.api.model.Model.newBuilder((org.apache.maven.api.model.Model)model);
        Build build = model.getBuild();
        if (build != null) {
            List plugins = build.getPlugins();
            normalized = new LinkedHashMap<String, Object>(plugins.size() * 2);
            for (Plugin plugin : plugins) {
                String key = plugin.getKey();
                Plugin first = (Plugin)normalized.get(key);
                if (first != null) {
                    plugin = this.merger.mergePlugin(plugin, first);
                }
                normalized.put(key, plugin);
            }
            if (plugins.size() != normalized.size()) {
                builder.build(Build.newBuilder((Build)build).plugins(normalized.values()).build());
            }
        }
        List dependencies = model.getDependencies();
        normalized = new LinkedHashMap(dependencies.size() * 2);
        for (Dependency dependency : dependencies) {
            normalized.put(dependency.getManagementKey(), dependency);
        }
        if (dependencies.size() != normalized.size()) {
            builder.dependencies(normalized.values());
        }
        return builder.build();
    }

    @Override
    public org.apache.maven.api.model.Model injectDefaultValues(org.apache.maven.api.model.Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Model.Builder builder = org.apache.maven.api.model.Model.newBuilder((org.apache.maven.api.model.Model)model);
        builder.dependencies(this.injectList(model.getDependencies(), this::injectDependency));
        Build build = model.getBuild();
        if (build != null) {
            Build newBuild = Build.newBuilder((Build)build).plugins(this.injectList(build.getPlugins(), this::injectPlugin)).build();
            builder.build((Build)(newBuild != build ? newBuild : null));
        }
        return builder.build();
    }

    private Plugin injectPlugin(Plugin p) {
        return Plugin.newBuilder((Plugin)p).dependencies(this.injectList(p.getDependencies(), this::injectDependency)).build();
    }

    private Dependency injectDependency(Dependency d) {
        return d.getScope() == null || d.getScope().isEmpty() ? d.withScope("compile") : d;
    }

    private <T> List<T> injectList(List<T> list, Function<T, T> modifer) {
        ArrayList<T> newList = null;
        for (int i = 0; i < list.size(); ++i) {
            T oldT = list.get(i);
            T newT = modifer.apply(oldT);
            if (newT == oldT) continue;
            if (newList == null) {
                newList = new ArrayList<T>(list);
            }
            newList.set(i, newT);
        }
        return newList;
    }

    protected static class DuplicateMerger
    extends MavenModelMerger {
        protected DuplicateMerger() {
        }

        public Plugin mergePlugin(Plugin target, Plugin source) {
            return super.mergePlugin(target, source, false, Collections.emptyMap());
        }
    }
}

