/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Source;

@Experimental
public interface ToolchainsBuilderRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Optional<Source> getGlobalToolchainsSource();

    @Nonnull
    public Optional<Source> getUserToolchainsSource();

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull Session session, @Nullable Source globalToolchainsSource, @Nullable Source userToolchainsSource) {
        return ToolchainsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalToolchainsSource(globalToolchainsSource).userToolchainsSource(userToolchainsSource).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull Session session, @Nullable Path globalToolchainsPath, @Nullable Path userToolchainsPath) {
        return ToolchainsBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).globalToolchainsSource(globalToolchainsPath != null && Files.exists(globalToolchainsPath, new LinkOption[0]) ? Source.fromPath(globalToolchainsPath) : null).userToolchainsSource(userToolchainsPath != null && Files.exists(userToolchainsPath, new LinkOption[0]) ? Source.fromPath(userToolchainsPath) : null).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequestBuilder builder() {
        return new ToolchainsBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class ToolchainsBuilderRequestBuilder {
        Session session;
        Source globalToolchainsSource;
        Source userToolchainsSource;

        public ToolchainsBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ToolchainsBuilderRequestBuilder globalToolchainsSource(Source globalToolchainsSource) {
            this.globalToolchainsSource = globalToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequestBuilder userToolchainsSource(Source userToolchainsSource) {
            this.userToolchainsSource = userToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequest build() {
            return new DefaultToolchainsBuilderRequest(this.session, this.globalToolchainsSource, this.userToolchainsSource);
        }

        private static class DefaultToolchainsBuilderRequest
        extends BaseRequest
        implements ToolchainsBuilderRequest {
            private final Source globalToolchainsSource;
            private final Source userToolchainsSource;

            DefaultToolchainsBuilderRequest(@Nonnull Session session, @Nullable Source globalToolchainsSource, @Nullable Source userToolchainsSource) {
                super(session);
                this.globalToolchainsSource = globalToolchainsSource;
                this.userToolchainsSource = userToolchainsSource;
            }

            @Override
            @Nonnull
            public Optional<Source> getGlobalToolchainsSource() {
                return Optional.ofNullable(this.globalToolchainsSource);
            }

            @Override
            @Nonnull
            public Optional<Source> getUserToolchainsSource() {
                return Optional.ofNullable(this.userToolchainsSource);
            }
        }
    }
}

