/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelCache;
import org.apache.maven.api.services.ModelRepositoryHolder;
import org.apache.maven.api.services.ModelResolver;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformerContextBuilder;

@Experimental
@Immutable
public interface ModelBuilderRequest {
    public static final int VALIDATION_LEVEL_MINIMAL = 0;
    public static final int VALIDATION_LEVEL_MAVEN_2_0 = 20;
    public static final int VALIDATION_LEVEL_MAVEN_3_0 = 30;
    public static final int VALIDATION_LEVEL_MAVEN_3_1 = 31;
    public static final int VALIDATION_LEVEL_MAVEN_4_0 = 40;
    public static final int VALIDATION_LEVEL_STRICT = 40;

    @Nonnull
    public Session getSession();

    @Nonnull
    public ModelSource getSource();

    public int getValidationLevel();

    public boolean isTwoPhaseBuilding();

    public boolean isLocationTracking();

    public boolean isProjectBuild();

    public boolean isProcessPlugins();

    @Nonnull
    public Collection<Profile> getProfiles();

    @Nonnull
    public List<String> getActiveProfileIds();

    @Nonnull
    public List<String> getInactiveProfileIds();

    @Nonnull
    public Map<String, String> getSystemProperties();

    @Nonnull
    public Map<String, String> getUserProperties();

    @Nonnull
    public ModelResolver getModelResolver();

    @Nonnull
    public ModelRepositoryHolder getModelRepositoryHolder();

    @Nullable
    public ModelCache getModelCache();

    @Nullable
    public Object getListener();

    @Nullable
    public ModelBuilderResult getInterimResult();

    @Nullable
    public ModelTransformerContextBuilder getTransformerContextBuilder();

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull ModelBuilderRequest request, @Nonnull ModelSource source) {
        return ModelBuilderRequest.builder(BaseRequest.nonNull(request, "request cannot be null")).source(BaseRequest.nonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull Session session, @Nonnull ModelSource source) {
        return ModelBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).source(BaseRequest.nonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ModelBuilderRequest build(@Nonnull Session session, @Nonnull Path path) {
        return ModelBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).source(ModelSource.fromPath(path)).build();
    }

    @Nonnull
    public static ModelBuilderRequestBuilder builder() {
        return new ModelBuilderRequestBuilder();
    }

    @Nonnull
    public static ModelBuilderRequestBuilder builder(ModelBuilderRequest request) {
        return new ModelBuilderRequestBuilder(request);
    }

    @NotThreadSafe
    public static class ModelBuilderRequestBuilder {
        Session session;
        int validationLevel;
        boolean locationTracking;
        boolean twoPhaseBuilding;
        ModelSource source;
        boolean projectBuild;
        boolean processPlugins = true;
        Collection<Profile> profiles;
        List<String> activeProfileIds;
        List<String> inactiveProfileIds;
        Map<String, String> systemProperties;
        Map<String, String> userProperties;
        ModelResolver modelResolver;
        ModelRepositoryHolder modelRepositoryHolder;
        ModelCache modelCache;
        Object listener;
        ModelBuilderResult interimResult;
        ModelTransformerContextBuilder transformerContextBuilder;

        ModelBuilderRequestBuilder() {
        }

        ModelBuilderRequestBuilder(ModelBuilderRequest request) {
            this.session = request.getSession();
            this.validationLevel = request.getValidationLevel();
            this.locationTracking = request.isLocationTracking();
            this.twoPhaseBuilding = request.isTwoPhaseBuilding();
            this.source = request.getSource();
            this.projectBuild = request.isProjectBuild();
            this.processPlugins = request.isProcessPlugins();
            this.profiles = request.getProfiles();
            this.activeProfileIds = request.getActiveProfileIds();
            this.inactiveProfileIds = request.getInactiveProfileIds();
            this.systemProperties = request.getSystemProperties();
            this.userProperties = request.getUserProperties();
            this.modelResolver = request.getModelResolver();
            this.modelRepositoryHolder = request.getModelRepositoryHolder();
            this.modelCache = request.getModelCache();
            this.listener = request.getListener();
            this.interimResult = request.getInterimResult();
            this.transformerContextBuilder = request.getTransformerContextBuilder();
        }

        public ModelBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ModelBuilderRequestBuilder validationLevel(int validationLevel) {
            this.validationLevel = validationLevel;
            return this;
        }

        public ModelBuilderRequestBuilder twoPhaseBuilding(boolean twoPhaseBuilding) {
            this.twoPhaseBuilding = twoPhaseBuilding;
            return this;
        }

        public ModelBuilderRequestBuilder locationTracking(boolean locationTracking) {
            this.locationTracking = locationTracking;
            return this;
        }

        public ModelBuilderRequestBuilder source(ModelSource source) {
            this.source = source;
            return this;
        }

        public ModelBuilderRequestBuilder projectBuild(boolean projectBuild) {
            this.projectBuild = projectBuild;
            return this;
        }

        public ModelBuilderRequestBuilder processPlugins(boolean processPlugins) {
            this.processPlugins = processPlugins;
            return this;
        }

        public ModelBuilderRequestBuilder profiles(List<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }

        public ModelBuilderRequestBuilder activeProfileIds(List<String> activeProfileIds) {
            this.activeProfileIds = activeProfileIds;
            return this;
        }

        public ModelBuilderRequestBuilder inactiveProfileIds(List<String> inactiveProfileIds) {
            this.inactiveProfileIds = inactiveProfileIds;
            return this;
        }

        public ModelBuilderRequestBuilder systemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
            return this;
        }

        public ModelBuilderRequestBuilder userProperties(Map<String, String> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public ModelBuilderRequestBuilder modelResolver(ModelResolver modelResolver) {
            this.modelResolver = modelResolver;
            return this;
        }

        public ModelBuilderRequestBuilder modelRepositoryHolder(ModelRepositoryHolder modelRepositoryHolder) {
            this.modelRepositoryHolder = modelRepositoryHolder;
            return this;
        }

        public ModelBuilderRequestBuilder modelCache(ModelCache modelCache) {
            this.modelCache = modelCache;
            return this;
        }

        public ModelBuilderRequestBuilder listener(Object listener) {
            this.listener = listener;
            return this;
        }

        public ModelBuilderRequestBuilder interimResult(ModelBuilderResult interimResult) {
            this.interimResult = interimResult;
            return this;
        }

        public ModelBuilderRequestBuilder transformerContextBuilder(ModelTransformerContextBuilder transformerContextBuilder) {
            this.transformerContextBuilder = transformerContextBuilder;
            return this;
        }

        public ModelBuilderRequest build() {
            return new DefaultModelBuilderRequest(this.session, this.validationLevel, this.locationTracking, this.twoPhaseBuilding, this.source, this.projectBuild, this.processPlugins, this.profiles, this.activeProfileIds, this.inactiveProfileIds, this.systemProperties, this.userProperties, this.modelResolver, this.modelRepositoryHolder, this.modelCache, this.listener, this.interimResult, this.transformerContextBuilder);
        }

        private static class DefaultModelBuilderRequest
        extends BaseRequest
        implements ModelBuilderRequest {
            private final int validationLevel;
            private final boolean locationTracking;
            private final boolean twoPhaseBuilding;
            private final ModelSource source;
            private final boolean projectBuild;
            private final boolean processPlugins;
            private final Collection<Profile> profiles;
            private final List<String> activeProfileIds;
            private final List<String> inactiveProfileIds;
            private final Map<String, String> systemProperties;
            private final Map<String, String> userProperties;
            private final ModelResolver modelResolver;
            private final ModelRepositoryHolder modelRepositoryHolder;
            private final ModelCache modelCache;
            private final Object listener;
            private final ModelBuilderResult interimResult;
            private final ModelTransformerContextBuilder transformerContextBuilder;

            DefaultModelBuilderRequest(@Nonnull Session session, int validationLevel, boolean locationTracking, boolean twoPhaseBuilding, @Nonnull ModelSource source, boolean projectBuild, boolean processPlugins, Collection<Profile> profiles, List<String> activeProfileIds, List<String> inactiveProfileIds, Map<String, String> systemProperties, Map<String, String> userProperties, ModelResolver modelResolver, ModelRepositoryHolder modelRepositoryHolder, ModelCache modelCache, Object listener, ModelBuilderResult interimResult, ModelTransformerContextBuilder transformerContextBuilder) {
                super(session);
                this.validationLevel = validationLevel;
                this.locationTracking = locationTracking;
                this.twoPhaseBuilding = twoPhaseBuilding;
                this.source = source;
                this.projectBuild = projectBuild;
                this.processPlugins = processPlugins;
                this.profiles = profiles != null ? List.copyOf(profiles) : List.of();
                this.activeProfileIds = activeProfileIds != null ? List.copyOf(activeProfileIds) : List.of();
                this.inactiveProfileIds = inactiveProfileIds != null ? List.copyOf(inactiveProfileIds) : List.of();
                this.systemProperties = systemProperties != null ? Map.copyOf(systemProperties) : session.getSystemProperties();
                this.userProperties = userProperties != null ? Map.copyOf(userProperties) : session.getUserProperties();
                this.modelResolver = modelResolver;
                this.modelRepositoryHolder = modelRepositoryHolder;
                this.modelCache = modelCache;
                this.listener = listener;
                this.interimResult = interimResult;
                this.transformerContextBuilder = transformerContextBuilder;
            }

            @Override
            public int getValidationLevel() {
                return this.validationLevel;
            }

            @Override
            public boolean isTwoPhaseBuilding() {
                return this.twoPhaseBuilding;
            }

            @Override
            public boolean isLocationTracking() {
                return this.locationTracking;
            }

            @Override
            @Nonnull
            public ModelSource getSource() {
                return this.source;
            }

            @Override
            public boolean isProjectBuild() {
                return this.projectBuild;
            }

            @Override
            public boolean isProcessPlugins() {
                return this.processPlugins;
            }

            @Override
            public Collection<Profile> getProfiles() {
                return this.profiles;
            }

            @Override
            public List<String> getActiveProfileIds() {
                return this.activeProfileIds;
            }

            @Override
            public List<String> getInactiveProfileIds() {
                return this.inactiveProfileIds;
            }

            @Override
            public Map<String, String> getSystemProperties() {
                return this.systemProperties;
            }

            @Override
            public Map<String, String> getUserProperties() {
                return this.userProperties;
            }

            @Override
            public ModelResolver getModelResolver() {
                return this.modelResolver;
            }

            @Override
            public ModelRepositoryHolder getModelRepositoryHolder() {
                return this.modelRepositoryHolder;
            }

            @Override
            public ModelCache getModelCache() {
                return this.modelCache;
            }

            @Override
            public Object getListener() {
                return this.listener;
            }

            @Override
            public ModelBuilderResult getInterimResult() {
                return this.interimResult;
            }

            @Override
            public ModelTransformerContextBuilder getTransformerContextBuilder() {
                return this.transformerContextBuilder;
            }
        }
    }
}

