/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collections;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;

@Experimental
public class ModelBuilderException
extends MavenException {
    private final ModelBuilderResult result;

    public ModelBuilderException(ModelBuilderResult result) {
        super(result.toString());
        this.result = result;
    }

    public ModelBuilderResult getResult() {
        return this.result;
    }

    public String getModelId() {
        if (this.result == null || this.result.getModelIds().isEmpty()) {
            return "";
        }
        return this.result.getModelIds().get(0);
    }

    public List<ModelProblem> getProblems() {
        if (this.result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.result.getProblems());
    }
}

