/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.DependencyCollectorRequest;

@Experimental
public interface DependencyResolverRequest
extends DependencyCollectorRequest {
    @Nonnull
    public PathScope getPathScope();

    public Predicate<PathType> getPathTypeFilter();

    @Nonnull
    public static DependencyResolverRequestBuilder builder() {
        return new DependencyResolverRequestBuilder();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, Project project) {
        return DependencyResolverRequest.build(session, project, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, Project project, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).project(project).pathScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, DependencyCoordinate dependency) {
        return DependencyResolverRequest.build(session, dependency, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, DependencyCoordinate dependency, PathScope scope) {
        return new DependencyResolverRequestBuilder().session(session).dependency(dependency).pathScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, List<DependencyCoordinate> dependencies) {
        return DependencyResolverRequest.build(session, dependencies, PathScope.MAIN_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, List<DependencyCoordinate> dependencies, PathScope scope) {
        return ((DependencyResolverRequestBuilder)new DependencyResolverRequestBuilder().session(session).dependencies((List)dependencies)).pathScope(scope).build();
    }

    @NotThreadSafe
    public static class DependencyResolverRequestBuilder
    extends DependencyCollectorRequest.DependencyCollectorRequestBuilder {
        PathScope pathScope;
        Predicate<PathType> pathTypeFilter;

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder session(@Nonnull Session session) {
            super.session(session);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder project(@Nullable Project project) {
            super.project(project);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder rootArtifact(@Nullable Artifact rootArtifact) {
            super.rootArtifact(rootArtifact);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder root(@Nullable DependencyCoordinate root) {
            super.root(root);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder dependencies(@Nullable List<DependencyCoordinate> dependencies) {
            super.dependencies(dependencies);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder dependency(@Nullable DependencyCoordinate dependency) {
            super.dependency(dependency);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder managedDependencies(@Nullable List<DependencyCoordinate> managedDependencies) {
            super.managedDependencies(managedDependencies);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder managedDependency(@Nullable DependencyCoordinate managedDependency) {
            super.managedDependency(managedDependency);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder verbose(boolean verbose) {
            super.verbose(verbose);
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathScope(@Nonnull PathScope pathScope) {
            this.pathScope = pathScope;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathTypeFilter(@Nonnull Predicate<PathType> pathTypeFilter) {
            this.pathTypeFilter = pathTypeFilter;
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder pathTypeFilter(@Nonnull Collection<PathType> desiredTypes) {
            return this.pathTypeFilter(desiredTypes::contains);
        }

        @Override
        public DependencyResolverRequest build() {
            return new DefaultDependencyResolverRequest(this.session, this.project, this.rootArtifact, this.root, this.dependencies, this.managedDependencies, this.verbose, this.pathScope, this.pathTypeFilter);
        }

        static class DefaultDependencyResolverRequest
        extends DependencyCollectorRequest.DependencyCollectorRequestBuilder.DefaultDependencyCollectorRequest
        implements DependencyResolverRequest {
            private final PathScope pathScope;
            private final Predicate<PathType> pathTypeFilter;

            DefaultDependencyResolverRequest(Session session, Project project, Artifact rootArtifact, DependencyCoordinate root, Collection<DependencyCoordinate> dependencies, Collection<DependencyCoordinate> managedDependencies, boolean verbose, PathScope pathScope, Predicate<PathType> pathTypeFilter) {
                super(session, project, rootArtifact, root, dependencies, managedDependencies, verbose);
                this.pathScope = DefaultDependencyResolverRequest.nonNull(pathScope, "pathScope cannot be null");
                Predicate<PathType> predicate = this.pathTypeFilter = pathTypeFilter != null ? pathTypeFilter : t -> true;
                if (verbose) {
                    throw new IllegalArgumentException("verbose cannot be true for resolving dependencies");
                }
            }

            @Override
            @Nonnull
            public PathScope getPathScope() {
                return this.pathScope;
            }

            @Override
            public Predicate<PathType> getPathTypeFilter() {
                return this.pathTypeFilter;
            }
        }
    }
}

