/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.building.Source;
import org.apache.maven.model.building.ModelCache;

public class SnapshotModelCache
implements ModelCache {
    private final ModelCache globalCache;
    private final ModelCache reactorCache;

    public SnapshotModelCache(ModelCache globalCache, ModelCache reactorCache) {
        this.globalCache = Objects.requireNonNull(globalCache);
        this.reactorCache = Objects.requireNonNull(reactorCache);
    }

    public <T> T computeIfAbsent(String groupId, String artifactId, String version, String tag, Supplier<T> data) {
        return (T)this.getDelegate(version).computeIfAbsent(groupId, artifactId, version, tag, data);
    }

    public <T> T computeIfAbsent(Source path, String tag, Supplier<T> data) {
        return (T)this.reactorCache.computeIfAbsent(path, tag, data);
    }

    private ModelCache getDelegate(String version) {
        return version.contains("SNAPSHOT") || version.contains("${") ? this.reactorCache : this.globalCache;
    }
}

