/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeImpl;

public class XmlNodeStaxBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static XmlNodeImpl build(InputStream stream, InputLocationBuilderStax locationBuilder) throws XMLStreamException {
        XMLStreamReader parser = WstxInputFactory.newFactory().createXMLStreamReader(stream);
        return XmlNodeStaxBuilder.build(parser, true, locationBuilder);
    }

    public static XmlNodeImpl build(Reader reader, InputLocationBuilderStax locationBuilder) throws XMLStreamException {
        XMLStreamReader parser = WstxInputFactory.newFactory().createXMLStreamReader(reader);
        return XmlNodeStaxBuilder.build(parser, true, locationBuilder);
    }

    public static XmlNodeImpl build(XMLStreamReader parser) throws XMLStreamException {
        return XmlNodeStaxBuilder.build(parser, true, null);
    }

    public static XmlNodeImpl build(XMLStreamReader parser, InputLocationBuilderStax locationBuilder) throws XMLStreamException {
        return XmlNodeStaxBuilder.build(parser, true, locationBuilder);
    }

    public static XmlNodeImpl build(XMLStreamReader parser, boolean trim, InputLocationBuilderStax locationBuilder) throws XMLStreamException {
        boolean spacePreserve = false;
        String lPrefix = null;
        String lNamespaceUri = null;
        String lName = null;
        String lValue = null;
        Object location = null;
        HashMap<Object, String> attrs = null;
        ArrayList<XmlNode> children = null;
        int eventType = parser.getEventType();
        int lastStartTag = -1;
        while (eventType != 8) {
            if (eventType == 1) {
                lastStartTag = parser.getLocation().getLineNumber() * 1000 + parser.getLocation().getColumnNumber();
                if (lName == null) {
                    int namespacesSize = parser.getNamespaceCount();
                    lPrefix = parser.getPrefix();
                    lNamespaceUri = parser.getNamespaceURI();
                    lName = parser.getLocalName();
                    location = locationBuilder != null ? locationBuilder.toInputLocation(parser) : null;
                    int attributesSize = parser.getAttributeCount();
                    if (attributesSize > 0 || namespacesSize > 0) {
                        int i;
                        attrs = new HashMap<Object, String>();
                        for (i = 0; i < namespacesSize; ++i) {
                            String nsPrefix = parser.getNamespacePrefix(i);
                            String nsUri = parser.getNamespaceURI(i);
                            attrs.put(nsPrefix != null && !nsPrefix.isEmpty() ? "xmlns:" + nsPrefix : "xmlns", nsUri);
                        }
                        for (i = 0; i < attributesSize; ++i) {
                            Object aName = parser.getAttributeLocalName(i);
                            String aValue = parser.getAttributeValue(i);
                            String aPrefix = parser.getAttributePrefix(i);
                            if (aPrefix != null && !aPrefix.isEmpty()) {
                                aName = aPrefix + ":" + (String)aName;
                            }
                            attrs.put(aName, aValue);
                            spacePreserve = spacePreserve || "xml:space".equals(aName) && "preserve".equals(aValue);
                        }
                    }
                } else {
                    if (children == null) {
                        children = new ArrayList<XmlNode>();
                    }
                    XmlNodeImpl child = XmlNodeStaxBuilder.build(parser, trim, locationBuilder);
                    children.add(child);
                }
            } else if (eventType == 4 || eventType == 12) {
                String text = parser.getText();
                lValue = lValue != null ? lValue + text : text;
            } else if (eventType == 2) {
                boolean emptyTag;
                boolean bl = emptyTag = lastStartTag == parser.getLocation().getLineNumber() * 1000 + parser.getLocation().getColumnNumber();
                if (lValue != null && trim && !spacePreserve) {
                    lValue = lValue.trim();
                }
                return new XmlNodeImpl(lPrefix, lNamespaceUri, lName, (String)(children == null ? (lValue != null ? lValue : (emptyTag ? null : "")) : null), attrs, children, location);
            }
            eventType = parser.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public static interface InputLocationBuilderStax {
        public Object toInputLocation(XMLStreamReader var1);
    }
}

