/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Source;

@Experimental
@Immutable
public interface ProjectBuilderRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public Optional<Path> getPath();

    @Nonnull
    public Optional<Source> getSource();

    public boolean isAllowStubModel();

    public boolean isRecursive();

    public boolean isProcessPlugins();

    @Nonnull
    public static ProjectBuilderRequest build(@Nonnull Session session, @Nonnull Source source) {
        return ProjectBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).source(BaseRequest.nonNull(source, "source cannot be null")).build();
    }

    @Nonnull
    public static ProjectBuilderRequest build(@Nonnull Session session, @Nonnull Path path) {
        return ProjectBuilderRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).path(BaseRequest.nonNull(path, "path cannot be null")).build();
    }

    @Nonnull
    public static ProjectBuilderRequestBuilder builder() {
        return new ProjectBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class ProjectBuilderRequestBuilder {
        Session session;
        Path path;
        Source source;
        boolean allowStubModel;
        boolean recursive;
        boolean processPlugins = true;

        ProjectBuilderRequestBuilder() {
        }

        public ProjectBuilderRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ProjectBuilderRequestBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public ProjectBuilderRequestBuilder source(Source source) {
            this.source = source;
            return this;
        }

        public ProjectBuilderRequestBuilder processPlugins(boolean processPlugins) {
            this.processPlugins = processPlugins;
            return this;
        }

        public ProjectBuilderRequest build() {
            return new DefaultProjectBuilderRequest(this.session, this.path, this.source, this.allowStubModel, this.recursive, this.processPlugins);
        }

        private static class DefaultProjectBuilderRequest
        extends BaseRequest
        implements ProjectBuilderRequest {
            private final Path path;
            private final Source source;
            private final boolean allowStubModel;
            private final boolean recursive;
            private final boolean processPlugins;

            DefaultProjectBuilderRequest(@Nonnull Session session, @Nullable Path path, @Nullable Source source, boolean allowStubModel, boolean recursive, boolean processPlugins) {
                super(session);
                this.path = path;
                this.source = source;
                this.allowStubModel = allowStubModel;
                this.recursive = recursive;
                this.processPlugins = processPlugins;
            }

            @Override
            @Nonnull
            public Optional<Path> getPath() {
                return Optional.ofNullable(this.path);
            }

            @Override
            @Nonnull
            public Optional<Source> getSource() {
                return Optional.ofNullable(this.source);
            }

            @Override
            public boolean isAllowStubModel() {
                return this.allowStubModel;
            }

            @Override
            public boolean isRecursive() {
                return this.recursive;
            }

            @Override
            public boolean isProcessPlugins() {
                return this.processPlugins;
            }
        }
    }
}

