/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CleanArgument;
import org.apache.maven.jline.MessageUtils;

public class CLIManager {
    public static final char ALTERNATE_POM_FILE = 'f';
    public static final char BATCH_MODE = 'B';
    public static final String NON_INTERACTIVE = "non-interactive";
    public static final String FORCE_INTERACTIVE = "force-interactive";
    public static final char SET_USER_PROPERTY = 'D';
    @Deprecated
    public static final char SET_SYSTEM_PROPERTY = 'D';
    public static final char OFFLINE = 'o';
    public static final char QUIET = 'q';
    public static final char VERBOSE = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char SHOW_VERSION = 'V';
    public static final char NON_RECURSIVE = 'N';
    public static final char UPDATE_SNAPSHOTS = 'U';
    public static final char ACTIVATE_PROFILES = 'P';
    public static final String SUPPRESS_SNAPSHOT_UPDATES = "nsu";
    public static final char CHECKSUM_FAILURE_POLICY = 'C';
    public static final char CHECKSUM_WARNING_POLICY = 'c';
    public static final char ALTERNATE_USER_SETTINGS = 's';
    public static final String ALTERNATE_PROJECT_SETTINGS = "ps";
    public static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
    public static final char ALTERNATE_USER_TOOLCHAINS = 't';
    public static final String ALTERNATE_GLOBAL_TOOLCHAINS = "gt";
    public static final String FAIL_FAST = "ff";
    public static final String FAIL_ON_SEVERITY = "fos";
    public static final String FAIL_AT_END = "fae";
    public static final String FAIL_NEVER = "fn";
    public static final String RESUME = "r";
    public static final String RESUME_FROM = "rf";
    public static final String PROJECT_LIST = "pl";
    public static final String ALSO_MAKE = "am";
    public static final String ALSO_MAKE_DEPENDENTS = "amd";
    public static final String LOG_FILE = "l";
    public static final String ENCRYPT_MASTER_PASSWORD = "emp";
    public static final String ENCRYPT_PASSWORD = "ep";
    public static final String THREADS = "T";
    public static final String BUILDER = "b";
    public static final String NO_TRANSFER_PROGRESS = "ntp";
    public static final String COLOR = "color";
    public static final String CACHE_ARTIFACT_NOT_FOUND = "canf";
    public static final String STRICT_ARTIFACT_DESCRIPTOR_POLICY = "sadp";
    public static final String IGNORE_TRANSITIVE_REPOSITORIES = "itr";
    @Deprecated
    public static final String DEBUG = "debug";
    protected Options options = new Options();

    public CLIManager() {
        this.options.addOption(Option.builder((String)Character.toString('h')).longOpt("help").desc("Display help information").build());
        this.options.addOption(Option.builder((String)Character.toString('f')).longOpt("file").hasArg().desc("Force the use of an alternate POM file (or directory with pom.xml)").build());
        this.options.addOption(Option.builder((String)Character.toString('D')).numberOfArgs(2).valueSeparator('=').desc("Define a user property").build());
        this.options.addOption(Option.builder((String)Character.toString('o')).longOpt("offline").desc("Work offline").build());
        this.options.addOption(Option.builder((String)Character.toString('v')).longOpt("version").desc("Display version information").build());
        this.options.addOption(Option.builder((String)Character.toString('q')).longOpt("quiet").desc("Quiet output - only show errors").build());
        this.options.addOption(Option.builder((String)Character.toString('X')).longOpt("verbose").desc("Produce execution verbose output").build());
        this.options.addOption(Option.builder((String)Character.toString('e')).longOpt("errors").desc("Produce execution error messages").build());
        this.options.addOption(Option.builder((String)Character.toString('N')).longOpt("non-recursive").desc("Do not recurse into sub-projects. When used together with -pl, do not recurse into sub-projects of selected aggregators").build());
        this.options.addOption(Option.builder((String)Character.toString('U')).longOpt("update-snapshots").desc("Forces a check for missing releases and updated snapshots on remote repositories").build());
        this.options.addOption(Option.builder((String)Character.toString('P')).longOpt("activate-profiles").desc("Comma-delimited list of profiles to activate. Prefixing a profile with ! excludes it, and ? marks it as optional").hasArg().build());
        this.options.addOption(Option.builder((String)Character.toString('B')).longOpt("batch-mode").desc("Run in non-interactive mode. Alias for --non-interactive (kept for backwards compatability)").build());
        this.options.addOption(Option.builder().longOpt(NON_INTERACTIVE).desc("Run in non-interactive mode. Alias for --batch-mode").build());
        this.options.addOption(Option.builder().longOpt(FORCE_INTERACTIVE).desc("Run in interactive mode. Overrides, if applicable, the CI environment variable and --non-interactive/--batch-mode options").build());
        this.options.addOption(Option.builder((String)SUPPRESS_SNAPSHOT_UPDATES).longOpt("no-snapshot-updates").desc("Suppress SNAPSHOT updates").build());
        this.options.addOption(Option.builder((String)Character.toString('C')).longOpt("strict-checksums").desc("Fail the build if checksums don't match").build());
        this.options.addOption(Option.builder((String)Character.toString('c')).longOpt("lax-checksums").desc("Warn if checksums don't match").build());
        this.options.addOption(Option.builder((String)Character.toString('s')).longOpt("settings").desc("Alternate path for the user settings file").hasArg().build());
        this.options.addOption(Option.builder((String)ALTERNATE_PROJECT_SETTINGS).longOpt("project-settings").desc("Alternate path for the project settings file").hasArg().build());
        this.options.addOption(Option.builder((String)ALTERNATE_GLOBAL_SETTINGS).longOpt("global-settings").desc("Alternate path for the global settings file").hasArg().build());
        this.options.addOption(Option.builder((String)Character.toString('t')).longOpt("toolchains").desc("Alternate path for the user toolchains file").hasArg().build());
        this.options.addOption(Option.builder((String)ALTERNATE_GLOBAL_TOOLCHAINS).longOpt("global-toolchains").desc("Alternate path for the global toolchains file").hasArg().build());
        this.options.addOption(Option.builder((String)FAIL_ON_SEVERITY).longOpt("fail-on-severity").desc("Configure which severity of logging should cause the build to fail").hasArg().build());
        this.options.addOption(Option.builder((String)FAIL_FAST).longOpt("fail-fast").desc("Stop at first failure in reactorized builds").build());
        this.options.addOption(Option.builder((String)FAIL_AT_END).longOpt("fail-at-end").desc("Only fail the build afterwards; allow all non-impacted builds to continue").build());
        this.options.addOption(Option.builder((String)FAIL_NEVER).longOpt("fail-never").desc("NEVER fail the build, regardless of project result").build());
        this.options.addOption(Option.builder((String)RESUME).longOpt("resume").desc("Resume reactor from the last failed project, using the resume.properties file in the build directory").build());
        this.options.addOption(Option.builder((String)RESUME_FROM).longOpt("resume-from").hasArg().desc("Resume reactor from specified project").build());
        this.options.addOption(Option.builder((String)PROJECT_LIST).longOpt("projects").desc("Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path. Prefixing a project with ! excludes it, and ? marks it as optional").hasArg().build());
        this.options.addOption(Option.builder((String)ALSO_MAKE).longOpt("also-make").desc("If project list is specified, also build projects required by the list").build());
        this.options.addOption(Option.builder((String)ALSO_MAKE_DEPENDENTS).longOpt("also-make-dependents").desc("If project list is specified, also build projects that depend on projects on the list").build());
        this.options.addOption(Option.builder((String)LOG_FILE).longOpt("log-file").hasArg().desc("Log file where all build output will go (disables output color)").build());
        this.options.addOption(Option.builder((String)Character.toString('V')).longOpt("show-version").desc("Display version information WITHOUT stopping build").build());
        this.options.addOption(Option.builder((String)ENCRYPT_MASTER_PASSWORD).longOpt("encrypt-master-password").hasArg().optionalArg(true).desc("Encrypt master security password").build());
        this.options.addOption(Option.builder((String)ENCRYPT_PASSWORD).longOpt("encrypt-password").hasArg().optionalArg(true).desc("Encrypt server password").build());
        this.options.addOption(Option.builder((String)THREADS).longOpt("threads").hasArg().desc("Thread count, for instance 4 (int) or 2C/2.5C (int/float) where C is core multiplied").build());
        this.options.addOption(Option.builder((String)BUILDER).longOpt("builder").hasArg().desc("The id of the build strategy to use").build());
        this.options.addOption(Option.builder((String)NO_TRANSFER_PROGRESS).longOpt("no-transfer-progress").desc("Do not display transfer progress when downloading or uploading").build());
        this.options.addOption(Option.builder().longOpt(COLOR).hasArg().optionalArg(true).desc("Defines the color mode of the output. Supported are 'auto', 'always', 'never'.").build());
        this.options.addOption(Option.builder((String)CACHE_ARTIFACT_NOT_FOUND).longOpt("cache-artifact-not-found").hasArg().desc("Defines caching behaviour for 'not found' artifacts. Supported values are 'true' (default), 'false'.").build());
        this.options.addOption(Option.builder((String)STRICT_ARTIFACT_DESCRIPTOR_POLICY).longOpt("strict-artifact-descriptor-policy").hasArg().desc("Defines 'strict' artifact descriptor policy. Supported values are 'true', 'false' (default).").build());
        this.options.addOption(Option.builder((String)IGNORE_TRANSITIVE_REPOSITORIES).longOpt("ignore-transitive-repositories").desc("If set, Maven will ignore remote repositories introduced by transitive dependencies.").build());
        this.options.addOption(Option.builder((String)"llr").longOpt("legacy-local-repository").desc("UNSUPPORTED: Use of this option will make Maven invocation fail.").build());
        this.options.addOption(Option.builder().longOpt(DEBUG).desc("Produce execution verbose output (deprecated; only kept for backward compatibility)").build());
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = CleanArgument.cleanArgs(args);
        DefaultParser parser = new DefaultParser();
        return parser.parse(this.options, cleanArgs);
    }

    public void displayHelp(PrintStream stdout) {
        stdout.println();
        PrintWriter pw = new PrintWriter(stdout);
        HelpFormatter formatter = new HelpFormatter();
        int width = MessageUtils.getTerminalWidth();
        if (width <= 0) {
            width = 74;
        }
        formatter.printHelp(pw, width, "mvn [args]", System.lineSeparator() + "Options:", this.options, 1, 3, System.lineSeparator(), false);
        pw.flush();
    }
}

