/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Repository;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.ModelRepositoryHolder;
import org.apache.maven.api.services.RepositoryFactory;

public class DefaultModelRepositoryHolder
implements ModelRepositoryHolder {
    final Session session;
    final RepositoryMerging repositoryMerging;
    List<RemoteRepository> pomRepositories;
    List<RemoteRepository> repositories;
    List<RemoteRepository> externalRepositories;
    Set<String> ids;

    public DefaultModelRepositoryHolder(Session session, RepositoryMerging repositoryMerging, List<RemoteRepository> externalRepositories) {
        this.session = session;
        this.repositoryMerging = repositoryMerging;
        this.pomRepositories = List.of();
        this.externalRepositories = List.copyOf(externalRepositories);
        this.repositories = List.copyOf(externalRepositories);
        this.ids = new HashSet<String>();
    }

    protected DefaultModelRepositoryHolder(DefaultModelRepositoryHolder holder) {
        this.session = holder.session;
        this.repositoryMerging = holder.repositoryMerging;
        this.pomRepositories = List.copyOf(holder.pomRepositories);
        this.externalRepositories = List.copyOf(holder.externalRepositories);
        this.repositories = List.copyOf(holder.repositories);
    }

    public void merge(List<org.apache.maven.api.model.Repository> toAdd, boolean replace) {
        List<RemoteRepository> repos = toAdd.stream().map(arg_0 -> ((Session)this.session).createRemoteRepository(arg_0)).toList();
        if (replace) {
            ids = repos.stream().map(Repository::getId).collect(Collectors.toSet());
            this.repositories = this.repositories.stream().filter(r -> !ids.contains(r.getId())).toList();
            this.pomRepositories = this.pomRepositories.stream().filter(r -> !ids.contains(r.getId())).toList();
        } else {
            ids = this.pomRepositories.stream().map(Repository::getId).collect(Collectors.toSet());
            repos = repos.stream().filter(r -> !ids.contains(r.getId())).toList();
        }
        RepositoryFactory repositoryFactory = (RepositoryFactory)this.session.getService(RepositoryFactory.class);
        if (this.repositoryMerging == RepositoryMerging.REQUEST_DOMINANT) {
            this.repositories = repositoryFactory.aggregate(this.session, this.repositories, repos, true);
            this.pomRepositories = this.repositories;
        } else {
            this.pomRepositories = repositoryFactory.aggregate(this.session, this.pomRepositories, repos, true);
            this.repositories = repositoryFactory.aggregate(this.session, this.pomRepositories, this.externalRepositories, false);
        }
    }

    public List<RemoteRepository> getRepositories() {
        return List.copyOf(this.repositories);
    }

    public ModelRepositoryHolder copy() {
        return new DefaultModelRepositoryHolder(this);
    }

    public static enum RepositoryMerging {
        POM_DOMINANT,
        REQUEST_DOMINANT;

    }
}

