/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.logging.slf4j;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.mvndaemon.mvnd.logging.slf4j.MvndBaseLogger;
import org.mvndaemon.mvnd.logging.slf4j.MvndSimpleLogger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public class MvndDaemonLogger
extends MvndBaseLogger {
    final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss.SSS").toFormatter();
    PrintStream printStream;

    public MvndDaemonLogger(String name) {
        super(name);
    }

    @Override
    protected String renderLevel(int levelInt) {
        switch (levelInt) {
            case 40: {
                return "E";
            }
            case 30: {
                return "W";
            }
            case 20: {
                return "I";
            }
            case 10: {
                return "D";
            }
            case 0: {
                return "T";
            }
        }
        throw new IllegalStateException("Unrecognized level [" + levelInt + "]");
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.append(this.dateTimeFormatter.format(LocalTime.now()));
        pw.append(" ");
        pw.append(this.renderLevel(level.toInt()));
        pw.append(" ");
        String message = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
        pw.append(message);
        if (throwable != null) {
            throwable.printStackTrace(pw);
        }
        PrintStream printStream = MvndSimpleLogger.CONFIG_PARAMS.outputChoice.getTargetPrintStream();
        printStream.println(sw);
        printStream.flush();
    }
}

