/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Language;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Model;

@Experimental
public interface Project {
    @Nonnull
    public String getGroupId();

    @Nonnull
    public String getArtifactId();

    @Nonnull
    public String getVersion();

    @Nonnull
    public Packaging getPackaging();

    @Nonnull
    default public Language getLanguage() {
        return this.getPackaging().language();
    }

    @Nonnull
    default public Artifact getPomArtifact() {
        return this.getArtifacts().get(0);
    }

    @Nonnull
    default public Optional<Artifact> getMainArtifact() {
        List<Artifact> artifacts = this.getArtifacts();
        return artifacts.size() == 2 ? Optional.of(artifacts.get(1)) : Optional.empty();
    }

    @Nonnull
    public List<Artifact> getArtifacts();

    @Nonnull
    public Model getModel();

    @Nonnull
    default public Build getBuild() {
        Build build = this.getModel().getBuild();
        return build != null ? build : Build.newInstance();
    }

    @Nonnull
    public Path getPomPath();

    @Nonnull
    public Path getBasedir();

    @Nonnull
    public List<DependencyCoordinate> getDependencies();

    @Nonnull
    public List<DependencyCoordinate> getManagedDependencies();

    @Nonnull
    default public String getId() {
        return this.getModel().getId();
    }

    public boolean isTopProject();

    public boolean isRootProject();

    @Nonnull
    public Path getRootDirectory();

    @Nonnull
    public Optional<Project> getParent();
}

