/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.feature.Features;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelCache;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelRepositoryHolder;
import org.apache.maven.api.services.ModelResolverException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformerContext;
import org.apache.maven.api.services.ModelTransformerContextBuilder;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.model.DefaultModelProblem;
import org.apache.maven.internal.impl.resolver.DefaultModelCache;
import org.apache.maven.internal.impl.resolver.DefaultModelRepositoryHolder;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ArtifactModelSource;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.building.ModelSource3;
import org.apache.maven.model.locator.ModelLocator;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.root.RootLocator;
import org.apache.maven.project.CycleDetectedException;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultModelBuildingListener;
import org.apache.maven.project.DefaultProjectBuildingResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.ProjectModelResolver;
import org.apache.maven.project.ReactorModelPool;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.apache.maven.utils.Os;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectBuilder
implements ProjectBuilder {
    public static final String BUILDER_PARALLELISM = "maven.projectBuilder.parallelism";
    public static final int DEFAULT_BUILDER_PARALLELISM = Runtime.getRuntime().availableProcessors() / 2 + 1;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModelBuilder modelBuilder;
    private final ModelProcessor modelProcessor;
    private final ProjectBuildingHelper projectBuildingHelper;
    private final MavenRepositorySystem repositorySystem;
    private final RepositorySystem repoSystem;
    private final RemoteRepositoryManager repositoryManager;
    private final ProjectDependenciesResolver dependencyResolver;
    private final RootLocator rootLocator;

    @Inject
    public DefaultProjectBuilder(ModelBuilder modelBuilder, ModelProcessor modelProcessor, ProjectBuildingHelper projectBuildingHelper, MavenRepositorySystem repositorySystem, RepositorySystem repoSystem, RemoteRepositoryManager repositoryManager, ProjectDependenciesResolver dependencyResolver, RootLocator rootLocator) {
        this.modelBuilder = modelBuilder;
        this.modelProcessor = modelProcessor;
        this.projectBuildingHelper = projectBuildingHelper;
        this.repositorySystem = repositorySystem;
        this.repoSystem = repoSystem;
        this.repositoryManager = repositoryManager;
        this.dependencyResolver = dependencyResolver;
        this.rootLocator = rootLocator;
    }

    @Override
    public ProjectBuildingResult build(File pomFile, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, false);){
            Path path = pomFile.toPath();
            ProjectBuildingResult projectBuildingResult = bs.build(path, org.apache.maven.api.services.ModelSource.fromPath((Path)path));
            return projectBuildingResult;
        }
    }

    @Override
    @Deprecated
    public ProjectBuildingResult build(ModelSource modelSource, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(DefaultProjectBuilder.toSource(modelSource), request);
    }

    @Deprecated
    static org.apache.maven.api.services.ModelSource toSource(final ModelSource modelSource) {
        if (modelSource instanceof FileModelSource) {
            FileModelSource fms = (FileModelSource)modelSource;
            return org.apache.maven.api.services.ModelSource.fromPath((Path)fms.getPath());
        }
        if (modelSource instanceof ArtifactModelSource) {
            ArtifactModelSource ams = (ArtifactModelSource)modelSource;
            return org.apache.maven.api.services.ModelSource.fromPath((Path)ams.getPath(), (String)ams.toString());
        }
        return new org.apache.maven.api.services.ModelSource(){

            public org.apache.maven.api.services.ModelSource resolve(final ModelSource.ModelLocator modelLocator, String relative) {
                if (modelSource instanceof ModelSource3) {
                    ModelSource3 ms = (ModelSource3)modelSource;
                    return DefaultProjectBuilder.toSource((ModelSource)ms.getRelatedSource(new ModelLocator(){

                        public File locatePom(File projectDirectory) {
                            return null;
                        }

                        public Path locatePom(Path projectDirectory) {
                            return null;
                        }

                        public Path locateExistingPom(Path project) {
                            return modelLocator.locateExistingPom(project);
                        }
                    }, relative));
                }
                return null;
            }

            public Path getPath() {
                return null;
            }

            public InputStream openStream() throws IOException {
                return modelSource.getInputStream();
            }

            public String getLocation() {
                return modelSource.getLocation();
            }

            public Source resolve(String relative) {
                if (modelSource instanceof ModelSource2) {
                    ModelSource2 ms = (ModelSource2)modelSource;
                    return DefaultProjectBuilder.toSource((ModelSource)ms.getRelatedSource(relative));
                }
                return null;
            }
        };
    }

    @Override
    public ProjectBuildingResult build(org.apache.maven.api.services.ModelSource modelSource, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, false);){
            ProjectBuildingResult projectBuildingResult = bs.build(null, modelSource);
            return projectBuildingResult;
        }
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, ProjectBuildingRequest request) throws ProjectBuildingException {
        return this.build(artifact, false, request);
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, boolean allowStubModel, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, false);){
            ProjectBuildingResult projectBuildingResult = bs.build(artifact, allowStubModel);
            return projectBuildingResult;
        }
    }

    @Override
    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest request) throws ProjectBuildingException {
        try (BuildSession bs = new BuildSession(request, true);){
            List<ProjectBuildingResult> list = bs.build(pomFiles, recursive);
            return list;
        }
    }

    private List<String> getProfileIds(List<org.apache.maven.api.model.Profile> profiles) {
        return profiles.stream().map(org.apache.maven.api.model.Profile::getId).collect(Collectors.toList());
    }

    private static org.apache.maven.api.services.ModelSource createStubModelSource(final Artifact artifact) {
        final StringBuilder buffer = new StringBuilder(1024);
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<project>");
        buffer.append("<modelVersion>4.0.0</modelVersion>");
        buffer.append("<groupId>").append(artifact.getGroupId()).append("</groupId>");
        buffer.append("<artifactId>").append(artifact.getArtifactId()).append("</artifactId>");
        buffer.append("<version>").append(artifact.getBaseVersion()).append("</version>");
        buffer.append("<packaging>").append(artifact.getType()).append("</packaging>");
        buffer.append("</project>");
        return new org.apache.maven.api.services.ModelSource(){

            public org.apache.maven.api.services.ModelSource resolve(ModelSource.ModelLocator modelLocator, String relative) {
                return null;
            }

            public Path getPath() {
                return null;
            }

            public InputStream openStream() throws IOException {
                return new ByteArrayInputStream(buffer.toString().getBytes(StandardCharsets.UTF_8));
            }

            public String getLocation() {
                return artifact.getId();
            }

            public Source resolve(String relative) {
                return null;
            }
        };
    }

    private static String inheritedGroupId(ModelBuilderResult result, int modelIndex) {
        String groupId = null;
        String modelId = (String)result.getModelIds().get(modelIndex);
        if (!modelId.isEmpty()) {
            org.apache.maven.api.model.Model model = (org.apache.maven.api.model.Model)result.getRawModel(modelId).orElseThrow();
            groupId = model.getGroupId() != null ? model.getGroupId() : DefaultProjectBuilder.inheritedGroupId(result, modelIndex + 1);
        }
        return groupId;
    }

    private static String inheritedVersion(ModelBuilderResult result, int modelIndex) {
        String version = null;
        String modelId = (String)result.getModelIds().get(modelIndex);
        if (!modelId.isEmpty() && (version = (String)result.getRawModel(modelId).map(org.apache.maven.api.model.Model::getVersion).orElse(null)) == null) {
            version = DefaultProjectBuilder.inheritedVersion(result, modelIndex + 1);
        }
        return version;
    }

    private static Map<String, String> toMap(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
        }
        return null;
    }

    static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        throw t;
    }

    class BuildSession
    implements AutoCloseable {
        private final ProjectBuildingRequest request;
        private final RepositorySystemSession session;
        private final List<RemoteRepository> repositories;
        private final ReactorModelPool modelPool;
        private final ConcurrentMap<String, Object> parentCache;
        private final ModelTransformerContextBuilder transformerContextBuilder;
        private final ExecutorService executor;
        private final ModelCache modelCache;
        private final org.apache.maven.api.services.ModelResolver modelResolver;

        BuildSession(final ProjectBuildingRequest request, boolean localProjects) {
            this.request = request;
            this.session = RepositoryUtils.overlay(request.getLocalRepository(), request.getRepositorySession(), DefaultProjectBuilder.this.repoSystem);
            InternalSession.from((RepositorySystemSession)this.session);
            this.repositories = RepositoryUtils.toRepos(request.getRemoteRepositories());
            this.executor = this.createExecutor(this.getParallelism(request));
            if (localProjects) {
                this.modelPool = new ReactorModelPool();
                this.transformerContextBuilder = DefaultProjectBuilder.this.modelBuilder.newTransformerContextBuilder();
            } else {
                this.modelPool = null;
                this.transformerContextBuilder = null;
            }
            this.parentCache = new ConcurrentHashMap<String, Object>();
            this.modelCache = DefaultModelCache.newInstance((RepositorySystemSession)this.session, (boolean)true);
            this.modelResolver = new ModelResolverWrapper(){

                @Override
                protected ModelResolver getResolver(List<RemoteRepository> repositories) {
                    return new ProjectModelResolver(BuildSession.this.session, RequestTrace.newChild(null, (Object)request), DefaultProjectBuilder.this.repoSystem, DefaultProjectBuilder.this.repositoryManager, repositories, request.getRepositoryMerging(), BuildSession.this.modelPool, BuildSession.this.parentCache);
                }
            };
        }

        ExecutorService createExecutor(final int parallelism) {
            return new ThreadPoolExecutor(parallelism, Integer.MAX_VALUE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()){
                final AtomicInteger parked;
                {
                    super(arg0, arg1, arg2, arg3, arg4);
                    this.parked = new AtomicInteger();
                }

                @Override
                public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
                    this.setCorePoolSize(parallelism + this.parked.incrementAndGet());
                    try {
                        List list = super.invokeAll(tasks);
                        return list;
                    }
                    finally {
                        this.setCorePoolSize(parallelism + this.parked.decrementAndGet());
                    }
                }
            };
        }

        @Override
        public void close() {
            this.executor.shutdownNow();
        }

        private int getParallelism(ProjectBuildingRequest request) {
            int parallelism = DEFAULT_BUILDER_PARALLELISM;
            try {
                String str = request.getUserProperties().getProperty(DefaultProjectBuilder.BUILDER_PARALLELISM);
                if (str == null) {
                    str = request.getSystemProperties().getProperty(DefaultProjectBuilder.BUILDER_PARALLELISM);
                }
                if (str != null) {
                    parallelism = Integer.parseInt(str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Math.max(1, Math.min(parallelism, Runtime.getRuntime().availableProcessors()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProjectBuildingResult build(Path pomFile, org.apache.maven.api.services.ModelSource modelSource) throws ProjectBuildingException {
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                MavenProject project = this.request.getProject();
                List modelProblems = null;
                ModelBuilderException error = null;
                if (project == null) {
                    ModelBuilderResult result;
                    project = new MavenProject();
                    project.setFile(pomFile != null ? pomFile.toFile() : null);
                    DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, DefaultProjectBuilder.this.projectBuildingHelper, this.request);
                    ModelBuilderRequest.ModelBuilderRequestBuilder builder = this.getModelBuildingRequest();
                    ModelBuilderRequest request = builder.projectBuild(this.modelPool != null).source(modelSource).projectBuild(true).locationTracking(true).listener((Object)listener).build();
                    if (pomFile != null) {
                        project.setRootDirectory(DefaultProjectBuilder.this.rootLocator.findRoot(pomFile.getParent()));
                    }
                    try {
                        result = DefaultProjectBuilder.this.modelBuilder.build(request);
                    }
                    catch (ModelBuilderException e) {
                        result = e.getResult();
                        if (result == null || result.getEffectiveModel() == null) {
                            throw new ProjectBuildingException(e.getModelId(), e.getMessage(), pomFile != null ? pomFile.toFile() : null, e);
                        }
                        error = e;
                    }
                    modelProblems = result.getProblems();
                    this.initProject(project, Collections.emptyMap(), result);
                } else if (this.request.isResolveDependencies()) {
                    DefaultProjectBuilder.this.projectBuildingHelper.selectProjectRealm(project);
                }
                DependencyResolutionResult resolutionResult = null;
                if (this.request.isResolveDependencies()) {
                    resolutionResult = this.resolveDependencies(project);
                }
                DefaultProjectBuildingResult result = new DefaultProjectBuildingResult(project, this.convert(modelProblems), resolutionResult);
                if (error != null) {
                    ProjectBuildingException e = new ProjectBuildingException(List.of(result));
                    e.initCause(error);
                    throw e;
                }
                DefaultProjectBuildingResult defaultProjectBuildingResult = result;
                return defaultProjectBuildingResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        ProjectBuildingResult build(Artifact artifact, boolean allowStubModel) throws ProjectBuildingException {
            boolean localProject;
            org.eclipse.aether.artifact.Artifact pomArtifact = RepositoryUtils.toArtifact(artifact);
            pomArtifact = ArtifactDescriptorUtils.toPomArtifact((org.eclipse.aether.artifact.Artifact)pomArtifact);
            try {
                ArtifactRequest pomRequest = new ArtifactRequest();
                pomRequest.setArtifact(pomArtifact);
                pomRequest.setRepositories(this.repositories);
                ArtifactResult pomResult = DefaultProjectBuilder.this.repoSystem.resolveArtifact(this.session, pomRequest);
                pomArtifact = pomResult.getArtifact();
                localProject = pomResult.getRepository() instanceof WorkspaceRepository;
            }
            catch (ArtifactResolutionException e) {
                if (((ArtifactResult)e.getResults().get(0)).isMissing() && allowStubModel) {
                    return this.build(null, DefaultProjectBuilder.createStubModelSource(artifact));
                }
                throw new ProjectBuildingException(artifact.getId(), "Error resolving project artifact: " + e.getMessage(), e);
            }
            Path pomFile = pomArtifact.getPath();
            if (!artifact.isResolved() && "pom".equals(artifact.getType())) {
                artifact.selectVersion(pomArtifact.getVersion());
                artifact.setFile(pomFile.toFile());
                artifact.setResolved(true);
            }
            if (localProject) {
                return this.build(pomFile, org.apache.maven.api.services.ModelSource.fromPath((Path)pomFile));
            }
            return this.build(null, org.apache.maven.api.services.ModelSource.fromPath((Path)pomFile, (String)(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion())));
        }

        List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive) throws ProjectBuildingException {
            List<ProjectBuildingResult> results = this.doBuild(pomFiles, recursive);
            if (results.stream().flatMap(r -> r.getProblems().stream()).anyMatch(p -> p.getSeverity() != ModelProblem.Severity.WARNING)) {
                org.apache.maven.model.building.ModelProblem cycle = results.stream().flatMap(r -> r.getProblems().stream()).filter(p -> p.getException() instanceof CycleDetectedException).findAny().orElse(null);
                if (cycle != null) {
                    throw new RuntimeException(new ProjectCycleException("The projects in the reactor contain a cyclic reference: " + cycle.getMessage(), (CycleDetectedException)cycle.getException()));
                }
                throw new ProjectBuildingException(results);
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<ProjectBuildingResult> doBuild(List<File> pomFiles, boolean recursive) {
            ConcurrentHashMap<File, MavenProject> projectIndex = new ConcurrentHashMap<File, MavenProject>(256);
            List<InterimResult> interimResults = this.build(projectIndex, pomFiles, new LinkedHashSet<File>(), true, recursive);
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                List<ProjectBuildingResult> results = this.build(projectIndex, interimResults);
                if (Features.buildConsumer((Properties)this.request.getUserProperties())) {
                    this.request.getRepositorySession().getData().set(ModelTransformerContext.KEY, (Object)this.transformerContextBuilder.build());
                }
                List<ProjectBuildingResult> list = results;
                return list;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        private List<InterimResult> build(Map<File, MavenProject> projectIndex, List<File> pomFiles, Set<File> aggregatorFiles, boolean root, boolean recursive) {
            List tasks = pomFiles.stream().map(pomFile -> () -> this.build(projectIndex, (File)pomFile, this.concat(aggregatorFiles, pomFile), root, recursive)).collect(Collectors.toList());
            try {
                List futures = this.executor.invokeAll(tasks);
                ArrayList<InterimResult> list = new ArrayList<InterimResult>();
                for (Future future : futures) {
                    InterimResult interimResult = (InterimResult)future.get();
                    list.add(interimResult);
                }
                return list;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private <T> Set<T> concat(Set<T> set, T elem) {
            HashSet<T> newSet = new HashSet<T>(set);
            newSet.add(elem);
            return newSet;
        }

        private InterimResult build(Map<File, MavenProject> projectIndex, File pomFile, Set<File> aggregatorFiles, boolean isRoot, boolean recursive) {
            ModelBuilderResult result;
            ModelBuilderRequest modelBuildingRequest;
            MavenProject project;
            block12: {
                project = new MavenProject();
                project.setFile(pomFile);
                project.setRootDirectory(DefaultProjectBuilder.this.rootLocator.findRoot(pomFile.getParentFile().toPath()));
                DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, DefaultProjectBuilder.this.projectBuildingHelper, this.request);
                modelBuildingRequest = this.getModelBuildingRequest().source(org.apache.maven.api.services.ModelSource.fromPath((Path)pomFile.toPath())).projectBuild(true).twoPhaseBuilding(true).locationTracking(true).listener((Object)listener).build();
                try {
                    result = DefaultProjectBuilder.this.modelBuilder.build(modelBuildingRequest);
                }
                catch (ModelBuilderException e) {
                    result = e.getResult();
                    if (result != null && result.getFileModel() != null) break block12;
                    return new InterimResult(modelBuildingRequest, new DefaultProjectBuildingResult(e.getModelId(), pomFile, this.convert(e.getProblems())));
                }
            }
            org.apache.maven.api.model.Model model = result.getActivatedFileModel();
            this.modelPool.put(model.getPomFile(), model);
            InterimResult interimResult = new InterimResult(pomFile, modelBuildingRequest, result, project, isRoot);
            if (recursive) {
                File basedir = pomFile.getParentFile();
                ArrayList<File> moduleFiles = new ArrayList<File>();
                for (String module : model.getModules()) {
                    File moduleFile;
                    if (module == null || module.isEmpty()) continue;
                    Path modulePath = DefaultProjectBuilder.this.modelProcessor.locateExistingPom(new File(basedir, module = module.replace('\\', File.separatorChar).replace('/', File.separatorChar)).toPath());
                    File file = moduleFile = modulePath != null ? modulePath.toFile() : null;
                    if (moduleFile == null) {
                        DefaultModelProblem problem = new DefaultModelProblem("Child module " + String.valueOf(moduleFile) + " of " + String.valueOf(pomFile) + " does not exist", BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        result.getProblems().add(problem);
                        continue;
                    }
                    if (Os.IS_WINDOWS) {
                        try {
                            moduleFile = moduleFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            moduleFile = moduleFile.getAbsoluteFile();
                        }
                    } else {
                        moduleFile = new File(moduleFile.toURI().normalize());
                    }
                    if (aggregatorFiles.contains(moduleFile)) {
                        StringBuilder buffer = new StringBuilder(256);
                        for (File aggregatorFile : aggregatorFiles) {
                            buffer.append(aggregatorFile).append(" -> ");
                        }
                        buffer.append(moduleFile);
                        DefaultModelProblem problem = new DefaultModelProblem("Child module " + String.valueOf(moduleFile) + " of " + String.valueOf(pomFile) + " forms aggregation cycle " + String.valueOf(buffer), BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        result.getProblems().add(problem);
                        continue;
                    }
                    moduleFiles.add(moduleFile);
                }
                if (!moduleFiles.isEmpty()) {
                    interimResult.modules = this.build(projectIndex, moduleFiles, aggregatorFiles, false, recursive);
                }
            }
            projectIndex.put(pomFile, project);
            return interimResult;
        }

        private List<ProjectBuildingResult> build(Map<File, MavenProject> projectIndex, List<InterimResult> interimResults) {
            ArrayList<ProjectBuildingResult> results = new ArrayList<ProjectBuildingResult>();
            boolean failure = false;
            for (InterimResult r : interimResults) {
                DefaultProjectBuildingResult res;
                try {
                    org.apache.maven.api.model.Model model = DefaultProjectBuilder.this.modelBuilder.buildRawModel(r.request);
                    res = new DefaultProjectBuildingResult(model.getId(), model.getPomFile() != null ? model.getPomFile().toFile() : null, null);
                }
                catch (ModelBuilderException e) {
                    failure = true;
                    res = new DefaultProjectBuildingResult(e.getModelId(), r.request.getSource().getPath() != null ? r.request.getSource().getPath().toFile() : null, this.convert(e.getProblems()));
                }
                results.add(res);
            }
            if (failure) {
                return results;
            }
            List callables = interimResults.stream().map(interimResult -> () -> this.doBuild(projectIndex, (InterimResult)interimResult)).collect(Collectors.toList());
            try {
                List futures = this.executor.invokeAll(callables);
                return futures.stream().map(listFuture -> {
                    try {
                        return (List)listFuture.get();
                    }
                    catch (InterruptedException e) {
                        DefaultProjectBuilder.uncheckedThrow(e);
                        return null;
                    }
                    catch (ExecutionException e) {
                        DefaultProjectBuilder.uncheckedThrow(e.getCause());
                        return null;
                    }
                }).flatMap(Collection::stream).collect(Collectors.toList());
            }
            catch (InterruptedException e) {
                DefaultProjectBuilder.uncheckedThrow(e);
                return null;
            }
        }

        private List<ProjectBuildingResult> doBuild(Map<File, MavenProject> projectIndex, InterimResult interimResult) {
            if (interimResult.projectBuildingResult != null) {
                return Collections.singletonList(interimResult.projectBuildingResult);
            }
            MavenProject project = interimResult.project;
            try {
                ModelBuilderResult result = DefaultProjectBuilder.this.modelBuilder.build(ModelBuilderRequest.builder((ModelBuilderRequest)interimResult.request).interimResult(interimResult.result).build());
                List<org.apache.maven.model.building.ModelProblem> problems = this.convert(result.getProblems());
                try {
                    this.initProject(project, projectIndex, result);
                }
                catch (InvalidArtifactRTException iarte) {
                    problems.add((org.apache.maven.model.building.ModelProblem)new org.apache.maven.model.building.DefaultModelProblem(null, ModelProblem.Severity.ERROR, null, new Model(result.getEffectiveModel()), -1, -1, (Exception)((Object)iarte)));
                }
                List<ProjectBuildingResult> results = this.build(projectIndex, interimResult.modules);
                project.setExecutionRoot(interimResult.root);
                project.setCollectedProjects(results.stream().map(ProjectBuildingResult::getProject).collect(Collectors.toList()));
                DependencyResolutionResult resolutionResult = null;
                if (this.request.isResolveDependencies()) {
                    resolutionResult = this.resolveDependencies(project);
                }
                results.add(new DefaultProjectBuildingResult(project, problems, resolutionResult));
                return results;
            }
            catch (ModelBuilderException e) {
                DefaultProjectBuildingResult result;
                if (project == null || interimResult.result.getEffectiveModel() == null) {
                    result = new DefaultProjectBuildingResult(e.getModelId(), interimResult.pomFile, this.convert(e.getProblems()));
                } else {
                    project.setModel(new Model(interimResult.result.getEffectiveModel()));
                    result = new DefaultProjectBuildingResult(project, this.convert(e.getProblems()), null);
                }
                return Collections.singletonList(result);
            }
        }

        private List<org.apache.maven.model.building.ModelProblem> convert(List<ModelProblem> problems) {
            if (problems == null) {
                return null;
            }
            return problems.stream().map(p -> new org.apache.maven.model.building.DefaultModelProblem(p.getMessage(), ModelProblem.Severity.valueOf((String)p.getSeverity().name()), ModelProblem.Version.valueOf((String)p.getVersion().name()), p.getSource(), p.getLineNumber(), p.getColumnNumber(), p.getModelId(), p.getException())).toList();
        }

        private void initProject(MavenProject project, Map<File, MavenProject> projects, ModelBuilderResult result) {
            ArtifactRepository repo;
            org.apache.maven.api.model.DeploymentRepository r;
            project.setModel(new Model(result.getEffectiveModel()));
            project.setOriginalModel(new Model(result.getFileModel()));
            this.initParent(project, projects, result);
            Artifact projectArtifact = DefaultProjectBuilder.this.repositorySystem.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
            project.setArtifact(projectArtifact);
            if (project.getFile() != null) {
                Build build = project.getBuild().getDelegate();
                project.addScriptSourceRoot(build.getScriptSourceDirectory());
                project.addCompileSourceRoot(build.getSourceDirectory());
                project.addTestCompileSourceRoot(build.getTestSourceDirectory());
            }
            project.setActiveProfiles(Stream.concat(result.getActivePomProfiles((String)result.getModelIds().get(0)).stream(), result.getActiveExternalProfiles().stream()).map(Profile::new).toList());
            project.setInjectedProfileIds("external", DefaultProjectBuilder.this.getProfileIds(result.getActiveExternalProfiles()));
            for (Object modelId : result.getModelIds()) {
                project.setInjectedProfileIds((String)modelId, DefaultProjectBuilder.this.getProfileIds(result.getActivePomProfiles((String)modelId)));
            }
            project.setProjectBuildingRequest(this.request);
            HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
            for (Object plugin : project.getModel().getDelegate().getBuild().getPlugins()) {
                Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createPluginArtifact(new Plugin((org.apache.maven.api.model.Plugin)plugin));
                if (artifact == null) continue;
                pluginArtifacts.add(artifact);
            }
            project.setPluginArtifacts(pluginArtifacts);
            HashSet<Artifact> reportArtifacts = new HashSet<Artifact>();
            for (ReportPlugin report : project.getModel().getDelegate().getReporting().getPlugins()) {
                org.apache.maven.api.model.Plugin pp = org.apache.maven.api.model.Plugin.newBuilder().groupId(report.getGroupId()).artifactId(report.getArtifactId()).version(report.getVersion()).build();
                Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createPluginArtifact(new Plugin(pp));
                if (artifact == null) continue;
                reportArtifacts.add(artifact);
            }
            project.setReportArtifacts(reportArtifacts);
            HashSet<Artifact> extensionArtifacts = new HashSet<Artifact>();
            List extensions = project.getModel().getDelegate().getBuild().getExtensions();
            if (extensions != null) {
                for (Extension ext : extensions) {
                    String version = ext.getVersion() == null || ext.getVersion().isEmpty() ? "RELEASE" : ext.getVersion();
                    Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createArtifact(ext.getGroupId(), ext.getArtifactId(), version, null, "jar");
                    if (artifact == null) continue;
                    extensionArtifacts.add(artifact);
                }
            }
            project.setExtensionArtifacts(extensionArtifacts);
            Map<String, Artifact> map = Collections.emptyMap();
            DependencyManagement dependencyManagement = project.getModel().getDelegate().getDependencyManagement();
            if (dependencyManagement != null && dependencyManagement.getDependencies() != null && !dependencyManagement.getDependencies().isEmpty()) {
                map = new LazyMap<String, Artifact>(() -> {
                    HashMap<String, Artifact> tmp = new HashMap<String, Artifact>();
                    for (Dependency d : dependencyManagement.getDependencies()) {
                        Artifact artifact = DefaultProjectBuilder.this.repositorySystem.createDependencyArtifact(new org.apache.maven.model.Dependency(d));
                        if (artifact == null) continue;
                        tmp.put(d.getManagementKey(), artifact);
                    }
                    return Collections.unmodifiableMap(tmp);
                });
            }
            project.setManagedVersionMap(map);
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null) {
                try {
                    r = project.getModel().getDelegate().getDistributionManagement().getRepository();
                    if (r.getId() != null && !r.getId().isEmpty() && r.getUrl() != null && !r.getUrl().isEmpty()) {
                        repo = MavenRepositorySystem.buildArtifactRepository((Repository)new DeploymentRepository(r));
                        DefaultProjectBuilder.this.repositorySystem.injectProxy(this.request.getRepositorySession(), List.of(repo));
                        DefaultProjectBuilder.this.repositorySystem.injectAuthentication(this.request.getRepositorySession(), List.of(repo));
                        project.setReleaseArtifactRepository(repo);
                    }
                }
                catch (InvalidRepositoryException e) {
                    throw new IllegalStateException("Failed to create release distribution repository for " + project.getId(), e);
                }
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getSnapshotRepository() != null) {
                try {
                    r = project.getModel().getDelegate().getDistributionManagement().getSnapshotRepository();
                    if (r.getId() != null && !r.getId().isEmpty() && r.getUrl() != null && !r.getUrl().isEmpty()) {
                        repo = MavenRepositorySystem.buildArtifactRepository((Repository)new DeploymentRepository(r));
                        DefaultProjectBuilder.this.repositorySystem.injectProxy(this.request.getRepositorySession(), List.of(repo));
                        DefaultProjectBuilder.this.repositorySystem.injectAuthentication(this.request.getRepositorySession(), List.of(repo));
                        project.setSnapshotArtifactRepository(repo);
                    }
                }
                catch (InvalidRepositoryException e) {
                    throw new IllegalStateException("Failed to create snapshot distribution repository for " + project.getId(), e);
                }
            }
        }

        private void initParent(MavenProject project, Map<File, MavenProject> projects, ModelBuilderResult result) {
            org.apache.maven.api.model.Model parentModel;
            org.apache.maven.api.model.Model model = parentModel = result.getModelIds().size() > 1 && !((String)result.getModelIds().get(1)).isEmpty() ? (org.apache.maven.api.model.Model)result.getRawModel((String)result.getModelIds().get(1)).orElse(null) : null;
            if (parentModel != null) {
                MavenProject parent;
                block11: {
                    String parentGroupId = DefaultProjectBuilder.inheritedGroupId(result, 1);
                    String parentVersion = DefaultProjectBuilder.inheritedVersion(result, 1);
                    project.setParentArtifact(DefaultProjectBuilder.this.repositorySystem.createProjectArtifact(parentGroupId, parentModel.getArtifactId(), parentVersion));
                    String parentModelId = (String)result.getModelIds().get(1);
                    Path parentPomFile = result.getRawModel(parentModelId).map(org.apache.maven.api.model.Model::getPomFile).orElse(null);
                    MavenProject mavenProject = parent = parentPomFile != null ? projects.get(parentPomFile.toFile()) : null;
                    if (parent == null) {
                        this.request.setRemoteRepositories(project.getRemoteArtifactRepositories());
                        if (parentPomFile != null) {
                            project.setParentFile(parentPomFile.toFile());
                            try {
                                parent = this.build(parentPomFile, org.apache.maven.api.services.ModelSource.fromPath((Path)parentPomFile)).getProject();
                            }
                            catch (ProjectBuildingException e) {
                                if (DefaultProjectBuilder.this.logger.isDebugEnabled()) {
                                    DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId(), (Throwable)e);
                                    break block11;
                                }
                                DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId());
                            }
                        } else {
                            Artifact parentArtifact = project.getParentArtifact();
                            try {
                                parent = this.build(parentArtifact, false).getProject();
                            }
                            catch (ProjectBuildingException e) {
                                if (DefaultProjectBuilder.this.logger.isDebugEnabled()) {
                                    DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId(), (Throwable)e);
                                }
                                DefaultProjectBuilder.this.logger.warn("Failed to build parent project for " + project.getId());
                            }
                        }
                    }
                }
                project.setParent(parent);
                if (project.getParentFile() == null && parent != null) {
                    project.setParentFile(parent.getFile());
                }
            }
        }

        private ModelBuilderRequest.ModelBuilderRequestBuilder getModelBuildingRequest() {
            ModelBuilderRequest.ModelBuilderRequestBuilder modelBuildingRequest = ModelBuilderRequest.builder();
            InternalSession internalSession = InternalSession.from((RepositorySystemSession)this.session);
            modelBuildingRequest.session(internalSession.withRemoteRepositories(this.request.getRemoteRepositories().stream().map(r -> internalSession.getRemoteRepository(RepositoryUtils.toRepo(r))).toList()));
            modelBuildingRequest.validationLevel(this.request.getValidationLevel());
            modelBuildingRequest.processPlugins(this.request.isProcessPlugins());
            modelBuildingRequest.profiles(this.request.getProfiles() != null ? this.request.getProfiles().stream().map(Profile::getDelegate).toList() : null);
            modelBuildingRequest.activeProfileIds(this.request.getActiveProfileIds());
            modelBuildingRequest.inactiveProfileIds(this.request.getInactiveProfileIds());
            modelBuildingRequest.systemProperties(DefaultProjectBuilder.toMap(this.request.getSystemProperties()));
            modelBuildingRequest.userProperties(DefaultProjectBuilder.toMap(this.request.getUserProperties()));
            modelBuildingRequest.modelResolver(this.modelResolver);
            DefaultModelRepositoryHolder holder = new DefaultModelRepositoryHolder((Session)internalSession, DefaultModelRepositoryHolder.RepositoryMerging.valueOf((String)this.request.getRepositoryMerging().name()), this.repositories.stream().map(arg_0 -> ((InternalSession)internalSession).getRemoteRepository(arg_0)).toList());
            modelBuildingRequest.modelRepositoryHolder((ModelRepositoryHolder)holder);
            modelBuildingRequest.modelCache(this.modelCache);
            modelBuildingRequest.transformerContextBuilder(this.transformerContextBuilder);
            internalSession.getData().set(SessionData.key(org.apache.maven.api.services.ModelResolver.class), (Object)this.modelResolver);
            return modelBuildingRequest;
        }

        private DependencyResolutionResult resolveDependencies(MavenProject project) {
            DependencyResolutionResult resolutionResult;
            try {
                DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, this.session);
                resolutionResult = DefaultProjectBuilder.this.dependencyResolver.resolve(resolution);
            }
            catch (DependencyResolutionException e) {
                resolutionResult = e.getResult();
            }
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            if (resolutionResult.getDependencyGraph() != null) {
                RepositoryUtils.toArtifacts(artifacts, resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
                LocalRepositoryManager lrm = this.session.getLocalRepositoryManager();
                for (Artifact artifact : artifacts) {
                    if (artifact.isResolved()) continue;
                    String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact(artifact));
                    artifact.setFile(lrm.getRepository().getBasePath().resolve(path).toFile());
                }
            }
            project.setResolvedArtifacts(artifacts);
            project.setArtifacts(artifacts);
            return resolutionResult;
        }
    }

    protected abstract class ModelResolverWrapper
    implements org.apache.maven.api.services.ModelResolver {
        protected ModelResolverWrapper() {
        }

        protected abstract ModelResolver getResolver(List<RemoteRepository> var1);

        public org.apache.maven.api.services.ModelSource resolveModel(Session session, String groupId, String artifactId, String version, Consumer<String> resolved) throws ModelResolverException {
            try {
                InternalSession internalSession = InternalSession.from((Session)session);
                ModelResolver resolver = this.getResolver(internalSession.toRepositories(internalSession.getRemoteRepositories()));
                org.apache.maven.model.Parent p = new org.apache.maven.model.Parent(Parent.newBuilder().groupId(groupId).artifactId(artifactId).version(version).build());
                ModelSource modelSource = resolver.resolveModel(p);
                if (!p.getVersion().equals(version)) {
                    resolved.accept(p.getVersion());
                }
                return DefaultProjectBuilder.toSource(modelSource);
            }
            catch (UnresolvableModelException e) {
                throw new ModelResolverException(e.getMessage(), e.getGroupId(), e.getArtifactId(), e.getVersion(), (Throwable)e);
            }
        }

        public org.apache.maven.api.services.ModelSource resolveModel(Session session, Parent parent, AtomicReference<Parent> modified) throws ModelResolverException {
            try {
                org.apache.maven.model.Parent p = new org.apache.maven.model.Parent(parent);
                InternalSession internalSession = InternalSession.from((Session)session);
                ModelResolver resolver = this.getResolver(internalSession.toRepositories(internalSession.getRemoteRepositories()));
                org.apache.maven.api.services.ModelSource source = DefaultProjectBuilder.toSource(resolver.resolveModel(p));
                if (p.getDelegate() != parent) {
                    modified.set(p.getDelegate());
                }
                return source;
            }
            catch (UnresolvableModelException e) {
                throw new ModelResolverException(e.getMessage(), e.getGroupId(), e.getArtifactId(), e.getVersion(), (Throwable)e);
            }
        }

        public org.apache.maven.api.services.ModelSource resolveModel(Session session, Dependency dependency, AtomicReference<Dependency> modified) throws ModelResolverException {
            try {
                org.apache.maven.model.Dependency d = new org.apache.maven.model.Dependency(dependency);
                InternalSession internalSession = InternalSession.from((Session)session);
                ModelResolver resolver = this.getResolver(internalSession.toRepositories(internalSession.getRemoteRepositories()));
                org.apache.maven.api.services.ModelSource source = DefaultProjectBuilder.toSource(resolver.resolveModel(d));
                if (d.getDelegate() != dependency) {
                    modified.set(d.getDelegate());
                }
                return source;
            }
            catch (UnresolvableModelException e) {
                throw new ModelResolverException(e.getMessage(), e.getGroupId(), e.getArtifactId(), e.getVersion(), (Throwable)e);
            }
        }
    }

    static class LazyMap<K, V>
    extends AbstractMap<K, V> {
        private final Supplier<Map<K, V>> supplier;
        private volatile Map<K, V> delegate;

        LazyMap(Supplier<Map<K, V>> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.delegate == null) {
                LazyMap lazyMap = this;
                synchronized (lazyMap) {
                    if (this.delegate == null) {
                        this.delegate = this.supplier.get();
                    }
                }
            }
            return this.delegate.entrySet();
        }
    }

    static class InterimResult {
        File pomFile;
        ModelBuilderRequest request;
        ModelBuilderResult result;
        MavenProject project;
        boolean root;
        List<InterimResult> modules = Collections.emptyList();
        ProjectBuildingResult projectBuildingResult;

        InterimResult(File pomFile, ModelBuilderRequest request, ModelBuilderResult result, MavenProject project, boolean root) {
            this.pomFile = pomFile;
            this.request = request;
            this.result = result;
            this.project = project;
            this.root = root;
        }

        InterimResult(ModelBuilderRequest request, ProjectBuildingResult projectBuildingResult) {
            this.request = request;
            this.projectBuildingResult = projectBuildingResult;
            this.pomFile = projectBuildingResult.getPomFile();
            this.project = projectBuildingResult.getProject();
        }
    }
}

