/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.List;
import java.util.Objects;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.model.ModelBuildingEvent;
import org.apache.maven.api.services.model.ModelBuildingListener;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectRealmCache;

public class DefaultModelBuildingListener
implements ModelBuildingListener {
    private final MavenProject project;
    private final ProjectBuildingHelper projectBuildingHelper;
    private final ProjectBuildingRequest projectBuildingRequest;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> pluginRepositories;

    public DefaultModelBuildingListener(MavenProject project, ProjectBuildingHelper projectBuildingHelper, ProjectBuildingRequest projectBuildingRequest) {
        this.project = Objects.requireNonNull(project, "project cannot be null");
        this.projectBuildingHelper = Objects.requireNonNull(projectBuildingHelper, "projectBuildingHelper cannot be null");
        this.projectBuildingRequest = Objects.requireNonNull(projectBuildingRequest, "projectBuildingRequest cannot be null");
        this.remoteRepositories = projectBuildingRequest.getRemoteRepositories();
        this.pluginRepositories = projectBuildingRequest.getPluginArtifactRepositories();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void buildExtensionsAssembled(ModelBuildingEvent event) {
        Model model = new Model(event.model());
        try {
            this.pluginRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getPluginRepositories(), this.pluginRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.problems().add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Invalid plugin repository: " + e.getMessage(), e);
        }
        this.project.setPluginArtifactRepositories(this.pluginRepositories);
        if (event.request().isProcessPlugins()) {
            try {
                ProjectRealmCache.CacheRecord record = this.projectBuildingHelper.createProjectRealm(this.project, model, this.projectBuildingRequest);
                this.project.setClassRealm(record.getRealm());
                this.project.setExtensionDependencyFilter(record.getExtensionArtifactFilter());
            }
            catch (PluginManagerException | PluginResolutionException | PluginVersionResolutionException e) {
                event.problems().add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Unresolvable build extension: " + e.getMessage(), e);
            }
            this.projectBuildingHelper.selectProjectRealm(this.project);
        }
        try {
            this.remoteRepositories = this.projectBuildingHelper.createArtifactRepositories(model.getRepositories(), this.remoteRepositories, this.projectBuildingRequest);
        }
        catch (Exception e) {
            event.problems().add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Invalid artifact repository: " + e.getMessage(), e);
        }
        this.project.setRemoteArtifactRepositories(this.remoteRepositories);
        if (model.getDelegate() != event.model()) {
            event.update().accept(model.getDelegate());
        }
    }
}

